/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ComplexSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EnumSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.LiteralSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.MapSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaTypeChoice;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeConverter<B>
extends OCFConverter<B> {
    public SchemaTypeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewSchemaTypeBean(Class<B> beanClass, InstanceHeader schemaRootHeader, String schemaTypeTypeName, InstanceProperties instanceProperties, List<Classification> schemaRootClassifications, int attributeCount, String validValueSetGUID, B externalSchemaType, B mapFromSchemaType, B mapToSchemaType, List<B> schemaTypeOptions, String methodName) throws PropertyServerException {
        try {
            B testBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (testBean instanceof SchemaType) {
                if (schemaRootHeader != null && instanceProperties != null) {
                    SchemaType returnBean = null;
                    if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "PrimitiveSchemaType")) {
                        returnBean = this.getPrimitiveSchemaType(instanceProperties);
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "LiteralSchemaType")) {
                        returnBean = this.getLiteralSchemaType(instanceProperties);
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "ComplexSchemaType")) {
                        returnBean = this.getComplexSchemaType(instanceProperties, attributeCount);
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "LiteralSchemaType")) {
                        returnBean = this.getEnumSchemaType(instanceProperties, validValueSetGUID);
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "MapSchemaType")) {
                        returnBean = this.getMapSchemaType(instanceProperties, mapFromSchemaType, mapToSchemaType);
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "SchemaTypeChoice")) {
                        returnBean = this.getSchemaTypeChoice(instanceProperties, schemaTypeOptions);
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeTypeName, "ExternalSchemaType")) {
                        returnBean = this.getExternalSchemaType(instanceProperties, externalSchemaType);
                    } else {
                        super.validateInstanceType("SchemaType", beanClass.getName(), schemaTypeTypeName, methodName);
                    }
                    if (returnBean != null) {
                        super.setUpElementHeader((ElementBase)returnBean, schemaRootHeader, schemaRootClassifications, methodName);
                        InstanceProperties classificationProperties = super.getClassificationProperties("CalculatedValue", schemaRootClassifications);
                        returnBean.setFormula(this.getFormula(classificationProperties));
                    }
                    return (B)returnBean;
                }
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
            }
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
        }
        return null;
    }

    private SchemaType getLiteralSchemaType(InstanceProperties instanceProperties) {
        LiteralSchemaType schemaType = new LiteralSchemaType();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaType)schemaType, propertiesCopy);
        schemaType.setDataType(this.removeDataType(propertiesCopy));
        schemaType.setFixedValue(this.removeFixedValue(propertiesCopy));
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaType getPrimitiveSchemaType(InstanceProperties instanceProperties) {
        PrimitiveSchemaType schemaType = new PrimitiveSchemaType();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaType)schemaType, propertiesCopy);
        schemaType.setDataType(this.removeDataType(propertiesCopy));
        schemaType.setDefaultValue(this.removeDefaultValue(propertiesCopy));
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaType getComplexSchemaType(InstanceProperties instanceProperties, int attributeCount) {
        ComplexSchemaType schemaType = new ComplexSchemaType();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaType)schemaType, propertiesCopy);
        schemaType.setAttributeCount(attributeCount);
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaType getEnumSchemaType(InstanceProperties instanceProperties, String validValueSetGUID) {
        EnumSchemaType schemaType = new EnumSchemaType();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaType)schemaType, propertiesCopy);
        schemaType.setDataType(this.removeDataType(propertiesCopy));
        schemaType.setDefaultValue(this.removeDefaultValue(propertiesCopy));
        schemaType.setValidValueSetGUID(validValueSetGUID);
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaType getSchemaTypeChoice(InstanceProperties instanceProperties, List<B> schemaTypeOptions) {
        SchemaTypeChoice schemaType = new SchemaTypeChoice();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaType)schemaType, propertiesCopy);
        if (schemaTypeOptions != null && !schemaTypeOptions.isEmpty()) {
            ArrayList<SchemaType> schemaTypeOptionBeans = new ArrayList<SchemaType>();
            for (B optionBean : schemaTypeOptions) {
                if (optionBean == null) continue;
                schemaTypeOptionBeans.add((SchemaType)optionBean);
            }
            if (!schemaTypeOptionBeans.isEmpty()) {
                schemaType.setSchemaOptions(schemaTypeOptionBeans);
            }
        }
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaType getExternalSchemaType(InstanceProperties instanceProperties, B externalSchemaType) {
        ExternalSchemaType schemaType = new ExternalSchemaType();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaType)schemaType, propertiesCopy);
        if (externalSchemaType != null) {
            schemaType.setLinkedSchemaType((SchemaType)externalSchemaType);
        }
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private SchemaType getMapSchemaType(InstanceProperties instanceProperties, B mapFromSchemaType, B mapToSchemaType) {
        MapSchemaType schemaType = new MapSchemaType();
        InstanceProperties propertiesCopy = new InstanceProperties(instanceProperties);
        this.updateBasicSchemaTypeProperties((SchemaType)schemaType, propertiesCopy);
        if (mapFromSchemaType != null) {
            schemaType.setMapFromElement((SchemaType)mapFromSchemaType);
        }
        if (mapToSchemaType != null) {
            schemaType.setMapFromElement((SchemaType)mapFromSchemaType);
        }
        schemaType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return schemaType;
    }

    private void updateBasicSchemaTypeProperties(SchemaType bean, InstanceProperties instanceProperties) {
        bean.setDisplayName(this.removeDisplayName(instanceProperties));
        bean.setDescription(this.removeDescription(instanceProperties));
        bean.setIsDeprecated(this.removeIsDeprecated(instanceProperties));
        bean.setVersionNumber(this.removeVersionNumber(instanceProperties));
        bean.setAuthor(this.removeAuthor(instanceProperties));
        bean.setUsage(this.removeUsage(instanceProperties));
        bean.setEncodingStandard(this.removeEncodingStandard(instanceProperties));
        bean.setNamespace(this.removeNamespace(instanceProperties));
        bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
    }
}

