/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.auditlog;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum OCFMetadataAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("CONNECTED-ASSET-SERVICES-0001", OMRSAuditLogRecordSeverity.STARTUP, "The Open Connector Framework (OCF) Metadata Management Service is initializing the connected asset services in a new server instance", "The local server has started up a new instance of the service which provides the metadata lookup services for OCF Connectors.", "No action is required.  This is part of the normal operation of the service."),
    SERVICE_INITIALIZED("CONNECTED-ASSET-SERVICES-0003", OMRSAuditLogRecordSeverity.STARTUP, "The Open Connector Framework (OCF) Metadata Management Service has initialized a new instance for server {0}", "The service has completed initialization of a new server instance.", "Verify that the service has started correctly."),
    SERVICE_SHUTDOWN("CONNECTED-ASSET-SERVICES-0004", OMRSAuditLogRecordSeverity.SHUTDOWN, "The Open Connector Framework (OCF) Metadata Management Service is shutting down its instance of the connected asset services for server {0}", "The local administrator has requested shut down of a server instance.", "No action is required if the server is shutting down."),
    SERVICE_INSTANCE_FAILURE("CONNECTED-ASSET-SERVICES-0005", OMRSAuditLogRecordSeverity.ERROR, "The Open Connector Framework (OCF) Metadata Management Service is unable to initialize a new instance of the connected asset services; error message is {0}", "The service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server.");

    private final AuditLogMessageDefinition messageDefinition;

    private OCFMetadataAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "OCFMetadataAuditCode{messageDefinition=" + this.messageDefinition + "}";
    }
}

