/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.admin;

import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.ffdc.OCFMetadataAuditCode;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.OCFMetadataInstanceHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.OCFMetadataServicesInstance;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class OCFMetadataOperationalServices {
    private final String serverName;
    private final AuditLog auditLog;

    public OCFMetadataOperationalServices(String serverName, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        this.serverName = serverName;
        this.auditLog = auditLog;
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", OCFMetadataAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        try {
            auditLog.logMessage("initialize", OCFMetadataAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{serverName}));
            new OCFMetadataServicesInstance(repositoryConnector, auditLog, localServerUserId, maxPageSize);
        }
        catch (NewInstanceException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", OCFMetadataAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", OCFMetadataAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
        new OCFMetadataInstanceHandler().removeServerServiceInstance(this.serverName);
    }
}

