/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.InformalTag;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class InformalTagConverter<B>
extends OCFConverter<B> {
    public InformalTagConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof InformalTag) {
                InformalTag bean = (InformalTag)returnBean;
                this.setUpElementHeader((ElementHeader)bean, entity, "InformalTag", methodName);
                InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                bean.setName(this.removeTagName(instanceProperties));
                bean.setDescription(this.removeTagDescription(instanceProperties));
                bean.setUser(entity.getCreatedBy());
                bean.setIsPrivateTag(!this.removeIsPublic(instanceProperties));
                if (relationship != null) {
                    instanceProperties = new InstanceProperties(relationship.getProperties());
                    bean.setIsPublic(this.getIsPublic(instanceProperties));
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

