/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CertificationHandler;
import org.odpi.openmetadata.commonservices.generichandlers.CommentHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalIdentifierHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ExternalReferenceHandler;
import org.odpi.openmetadata.commonservices.generichandlers.InformalTagHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LicenseHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LikeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LocationHandler;
import org.odpi.openmetadata.commonservices.generichandlers.NoteHandler;
import org.odpi.openmetadata.commonservices.generichandlers.NoteLogHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RatingHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedAssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedMediaHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SearchKeywordHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CertificationsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ExternalIdentifiersResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ExternalReferencesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.InformalTagsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.LicensesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.LikesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.LocationsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.MoreInformationResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.NoteLogResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.NoteLogsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.NotesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RatingsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RelatedAssetsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RelatedMediaReferencesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.OCFMetadataInstanceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Certification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalIdentifier;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalReference;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.InformalTag;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.License;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Like;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Location;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Note;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.NoteLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Rating;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedMediaReference;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SearchKeyword;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.slf4j.LoggerFactory;

public class OCFMetadataRESTServices {
    private static OCFMetadataInstanceHandler instanceHandler = new OCFMetadataInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OCFMetadataRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectionResponse getConnectionByGUID(String serverName, String serviceURLName, String userId, String guid) {
        String guidParameterName = "guid";
        String methodName = "getConnectionByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionByGUID");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            ConnectionHandler<Connection> connectionHandler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionByGUID");
            response.setConnection((Connection)connectionHandler.getBeanFromRepository(userId, guid, "guid", "Connection", false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getConnectionByGUID"), new Date(), "getConnectionByGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionResponse getConnectionByName(String serverName, String serviceURLName, String userId, String name) {
        String nameParameterName = "name";
        String methodName = "getConnectionByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionByName");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            ConnectionHandler<Connection> connectionHandler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionByName");
            response.setConnection((Connection)connectionHandler.getBeanByUniqueName(userId, name, "name", "qualifiedName", "114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", false, false, instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getConnectionByName"), null, "getConnectionByName"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse getAssetForConnectionGUID(String serverName, String serviceURLName, String userId, String connectionGUID) {
        String connectionGUIDParameterName = "connectionGUID";
        String methodName = "getAssetForConnectionGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAssetForConnectionGUID");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            AssetHandler<Asset> handler = instanceHandler.getAssetHandler(userId, serverName, "getAssetForConnectionGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAssetForConnectionGUID");
            response.setGUID(handler.getAssetForConnection(userId, connectionGUID, "connectionGUID", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getAssetForConnectionGUID"), "getAssetForConnectionGUID"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAssetForConnectionGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ConnectionResponse getConnectionForAsset(String serverName, String serviceURLName, String userId, String assetGUID) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "getConnectionForAsset";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnectionForAsset");
        ConnectionResponse response = new ConnectionResponse();
        AuditLog auditLog = null;
        try {
            ConnectionHandler<Connection> handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnectionForAsset");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnectionForAsset");
            response.setConnection((Connection)handler.getConnectionForAsset(userId, assetGUID, "assetGUID", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getConnectionForAsset"), new Date(), "getConnectionForAsset"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnectionForAsset", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private AssetResponse getAssetResponse(String serverName, String serviceURLName, String userId, String assetGUID, String connectionGUID, String methodName) {
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        String assetGUIDParameterName = "assetGUID";
        AssetResponse response = new AssetResponse();
        AuditLog auditLog = null;
        try {
            Asset asset;
            Relationship relationship;
            List supportedZones = instanceHandler.getSupportedZones(userId, serverName, serviceURLName, methodName);
            AssetHandler<Asset> assetHandler = instanceHandler.getAssetHandler(userId, serverName, methodName);
            RelatedAssetHandler<RelatedAsset> relatedAssetHandler = instanceHandler.getRelatedAssetHandler(userId, serverName, methodName);
            CertificationHandler<Certification> certificationHandler = instanceHandler.getCertificationHandler(userId, serverName, methodName);
            CommentHandler<Comment> commentHandler = instanceHandler.getCommentHandler(userId, serverName, methodName);
            ConnectionHandler<Connection> connectionHandler = instanceHandler.getConnectionHandler(userId, serverName, methodName);
            ExternalIdentifierHandler<ExternalIdentifier, Object> externalIdentifierHandler = instanceHandler.getExternalIdentifierHandler(userId, serverName, methodName);
            ExternalReferenceHandler<ExternalReference> externalReferenceHandler = instanceHandler.getExternalReferenceHandler(userId, serverName, methodName);
            InformalTagHandler<InformalTag> informalTagHandler = instanceHandler.getInformalTagHandler(userId, serverName, methodName);
            LicenseHandler<License> licenseHandler = instanceHandler.getLicenseHandler(userId, serverName, methodName);
            LikeHandler<Like> likeHandler = instanceHandler.getLikeHandler(userId, serverName, methodName);
            LocationHandler<Location> locationHandler = instanceHandler.getLocationHandler(userId, serverName, methodName);
            NoteLogHandler<NoteLog> noteLogHandler = instanceHandler.getNoteLogHandler(userId, serverName, methodName);
            RatingHandler<Rating> ratingHandler = instanceHandler.getRatingHandler(userId, serverName, methodName);
            RelatedMediaHandler<RelatedMediaReference> relatedMediaHandler = instanceHandler.getRelatedMediaHandler(userId, serverName, methodName);
            SearchKeywordHandler<SearchKeyword> keywordHandler = instanceHandler.getKeywordHandler(userId, serverName, methodName);
            SchemaTypeHandler<SchemaType> schemaTypeHandler = instanceHandler.getSchemaTypeHandler(userId, serverName, methodName);
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            Date effectiveTime = new Date();
            String assetSummary = null;
            if (connectionGUID != null && (relationship = assetHandler.getUniqueAttachmentLink(userId, assetGUID, "assetGUID", "Asset", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", connectionGUID, "Connection", effectiveTime, methodName)) != null) {
                OMRSRepositoryHelper repositoryHelper = instanceHandler.getRepositoryHelper(userId, serverName, methodName);
                assetSummary = repositoryHelper.getStringProperty(instanceHandler.getServiceName(serviceURLName), "assetSummary", relationship.getProperties(), methodName);
            }
            if ((asset = (Asset)assetHandler.getBeanFromRepository(userId, assetGUID, "assetGUID", "Asset", false, false, supportedZones, effectiveTime, methodName)) != null) {
                asset.setShortDescription(assetSummary);
                response.setAsset(asset);
                response.setCertificationCount(certificationHandler.countCertifications(userId, assetGUID, effectiveTime, methodName));
                response.setCommentCount(commentHandler.countAttachedComments(userId, assetGUID, effectiveTime, methodName));
                response.setConnectionCount(connectionHandler.countConnections(userId, assetGUID, effectiveTime, methodName));
                response.setExternalIdentifierCount(externalIdentifierHandler.countExternalIdentifiers(userId, assetGUID, effectiveTime, methodName));
                response.setExternalReferencesCount(externalReferenceHandler.countExternalReferences(userId, assetGUID, effectiveTime, methodName));
                response.setInformalTagCount(informalTagHandler.countTags(userId, assetGUID, methodName));
                response.setLicenseCount(licenseHandler.countLicenses(userId, assetGUID, effectiveTime, methodName));
                response.setLikeCount(likeHandler.countLikes(userId, assetGUID, methodName));
                response.setKeywordCount(keywordHandler.countKeywords(userId, assetGUID, methodName));
                response.setKnownLocationsCount(locationHandler.countKnownLocations(userId, assetGUID, effectiveTime, methodName));
                response.setNoteLogsCount(noteLogHandler.countAttachedNoteLogs(userId, assetGUID, methodName));
                response.setRatingsCount(ratingHandler.countRatings(userId, assetGUID, methodName));
                response.setRelatedAssetCount(relatedAssetHandler.getRelatedAssetCount(userId, assetGUID, "assetGUID", "Asset", null, null, supportedZones, effectiveTime, methodName));
                response.setRelatedMediaReferenceCount(relatedMediaHandler.countRelatedMedia(userId, assetGUID, effectiveTime, methodName));
                response.setSchemaType((SchemaType)schemaTypeHandler.getSchemaTypeForAsset(userId, assetGUID, "assetGUID", effectiveTime, methodName));
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, methodName, auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public AssetResponse getConnectedAssetSummary(String serverName, String serviceURLName, String userId, String assetGUID, String connectionGUID) {
        String methodName = "getConnectedAssetSummary";
        return this.getAssetResponse(serverName, serviceURLName, userId, assetGUID, connectionGUID, "getConnectedAssetSummary");
    }

    public AssetResponse getAssetSummary(String serverName, String serviceURLName, String userId, String assetGUID) {
        String methodName = "getAssetSummary";
        return this.getAssetResponse(serverName, serviceURLName, userId, assetGUID, null, "getAssetSummary");
    }

    public CertificationsResponse getCertifications(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getCertifications";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCertifications");
        String assetGUIDParameterName = "assetGUID";
        CertificationsResponse response = new CertificationsResponse();
        AuditLog auditLog = null;
        try {
            CertificationHandler<Certification> handler = instanceHandler.getCertificationHandler(userId, serverName, "getCertifications");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCertifications");
            response.setList(handler.getCertifications(userId, assetGUID, "assetGUID", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getCertifications"), elementStart, maxElements, new Date(), "getCertifications"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCertifications", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    private CommentsResponse getAttachedComments(String serverName, String serviceURLName, String userId, String assetGUID, String assetGUIDParameterName, String elementGUID, String elementGUIDParameterName, String elementTypeName, int elementStart, int maxElements, String methodName) {
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, methodName);
        CommentsResponse response = new CommentsResponse();
        AuditLog auditLog = null;
        try {
            CommentHandler<Comment> handler = instanceHandler.getCommentHandler(userId, serverName, methodName);
            auditLog = instanceHandler.getAuditLog(userId, serverName, methodName);
            List attachedComments = handler.getComments(userId, assetGUID, assetGUIDParameterName, elementGUID, elementGUIDParameterName, elementTypeName, instanceHandler.getSupportedZones(userId, serverName, serviceURLName, methodName), elementStart, maxElements, new Date(), methodName);
            ArrayList<CommentResponse> results = new ArrayList<CommentResponse>();
            if (attachedComments != null) {
                for (Comment comment : attachedComments) {
                    if (comment == null) continue;
                    CommentResponse commentResponse = new CommentResponse();
                    commentResponse.setComment(comment);
                    commentResponse.setReplyCount(handler.countAttachedComments(userId, comment.getGUID(), new Date(), methodName));
                    results.add(commentResponse);
                }
            }
            if (results.isEmpty()) {
                response.setList(null);
            } else {
                response.setList(results);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, methodName, auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CommentsResponse getAssetComments(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String assetGUIDParameterName = "assetGUID";
        String methodName = "getAssetComments";
        return this.getAttachedComments(serverName, serviceURLName, userId, assetGUID, "assetGUID", assetGUID, "assetGUID", "Asset", elementStart, maxElements, "getAssetComments");
    }

    public CommentsResponse getAssetCommentReplies(String serverName, String serviceURLName, String userId, String assetGUID, String commentGUID, int elementStart, int maxElements) {
        String assetGUIDParameterName = "assetGUID";
        String commentGUIDParameterName = "commentGUID";
        String methodName = "getAssetCommentReplies";
        return this.getAttachedComments(serverName, serviceURLName, userId, assetGUID, "assetGUID", commentGUID, "commentGUID", "Comment", elementStart, maxElements, "getAssetCommentReplies");
    }

    public ConnectionsResponse getConnections(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getConnections";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getConnections");
        ConnectionsResponse response = new ConnectionsResponse();
        AuditLog auditLog = null;
        try {
            ConnectionHandler<Connection> handler = instanceHandler.getConnectionHandler(userId, serverName, "getConnections");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getConnections");
            response.setList(handler.getConnectionsForAsset(userId, assetGUID, "assetGUID", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getConnections"), elementStart, maxElements, new Date(), "getConnections"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getConnections", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalIdentifiersResponse getExternalIdentifiers(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getExternalIdentifiersForElement";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalIdentifiersForElement");
        ExternalIdentifiersResponse response = new ExternalIdentifiersResponse();
        AuditLog auditLog = null;
        try {
            ExternalIdentifierHandler<ExternalIdentifier, Object> handler = instanceHandler.getExternalIdentifierHandler(userId, serverName, "getExternalIdentifiersForElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalIdentifiersForElement");
            response.setList(handler.getExternalIdentifiersForElement(userId, assetGUID, "assetGUID", "Asset", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getExternalIdentifiersForElement"), elementStart, maxElements, new Date(), "getExternalIdentifiersForElement"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalIdentifiersForElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public ExternalReferencesResponse getExternalReferences(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getExternalReferences";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getExternalReferences");
        ExternalReferencesResponse response = new ExternalReferencesResponse();
        AuditLog auditLog = null;
        try {
            ExternalReferenceHandler<ExternalReference> handler = instanceHandler.getExternalReferenceHandler(userId, serverName, "getExternalReferences");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExternalReferences");
            response.setList(handler.getExternalReferences(userId, assetGUID, "assetGUID", "Asset", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getExternalReferences"), elementStart, maxElements, new Date(), "getExternalReferences"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getExternalReferences", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public InformalTagsResponse getInformalTags(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getInformalTags";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getInformalTags");
        InformalTagsResponse response = new InformalTagsResponse();
        AuditLog auditLog = null;
        try {
            InformalTagHandler<InformalTag> handler = instanceHandler.getInformalTagHandler(userId, serverName, "getInformalTags");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getInformalTags");
            response.setList(handler.getAttachedTags(userId, assetGUID, "assetGUID", "Asset", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getInformalTags"), elementStart, maxElements, "getInformalTags"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getInformalTags", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LicensesResponse getLicenses(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getLicenses";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLicenses");
        LicensesResponse response = new LicensesResponse();
        AuditLog auditLog = null;
        try {
            LicenseHandler<License> handler = instanceHandler.getLicenseHandler(userId, serverName, "getLicenses");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLicenses");
            response.setList(handler.getLicenses(userId, assetGUID, "assetGUID", "Asset", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getLicenses"), elementStart, maxElements, new Date(), "getLicenses"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLicenses", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LikesResponse getLikes(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getLikes";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLikes");
        LikesResponse response = new LikesResponse();
        AuditLog auditLog = null;
        try {
            LikeHandler<Like> handler = instanceHandler.getLikeHandler(userId, serverName, "getLikes");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLikes");
            response.setList(handler.getLikes(userId, assetGUID, "assetGUID", "Asset", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getLikes"), elementStart, maxElements, "getLikes"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getLikes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public LocationsResponse getKnownLocations(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getKnownLocations";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getKnownLocations");
        LocationsResponse response = new LocationsResponse();
        AuditLog auditLog = null;
        try {
            LocationHandler<Location> handler = instanceHandler.getLocationHandler(userId, serverName, "getKnownLocations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getKnownLocations");
            response.setList(handler.getLocations(userId, assetGUID, "assetGUID", "Asset", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getKnownLocations"), elementStart, maxElements, new Date(), "getKnownLocations"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getKnownLocations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NoteLogsResponse getNoteLogs(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getNoteLogs";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNoteLogs");
        NoteLogsResponse response = new NoteLogsResponse();
        AuditLog auditLog = null;
        try {
            NoteLogHandler<NoteLog> handler = instanceHandler.getNoteLogHandler(userId, serverName, "getNoteLogs");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNoteLogs");
            List noteLogs = handler.getAttachedNoteLogs(userId, assetGUID, "assetGUID", "Asset", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getNoteLogs"), elementStart, maxElements, "getNoteLogs");
            ArrayList<NoteLogResponse> results = new ArrayList<NoteLogResponse>();
            if (noteLogs != null) {
                NoteHandler<Note> noteHandler = instanceHandler.getNoteHandler(userId, serverName, "getNoteLogs");
                for (NoteLog noteLog : noteLogs) {
                    if (noteLog == null) continue;
                    NoteLogResponse noteLogResponse = new NoteLogResponse();
                    noteLogResponse.setNoteLog(noteLog);
                    noteLogResponse.setNoteCount(noteHandler.countAttachedNotes(userId, noteLog.getGUID(), "getNoteLogs"));
                    results.add(noteLogResponse);
                }
            }
            if (results.isEmpty()) {
                response.setList(null);
            } else {
                response.setList(results);
            }
            response.setList(results);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNoteLogs", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public NotesResponse getNotes(String serverName, String serviceURLName, String userId, String noteLogGUID, int elementStart, int maxElements) {
        String methodName = "getNotes";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getNotes");
        NotesResponse response = new NotesResponse();
        AuditLog auditLog = null;
        try {
            NoteHandler<Note> handler = instanceHandler.getNoteHandler(userId, serverName, "getNotes");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getNotes");
            response.setList(handler.getNotes(userId, noteLogGUID, "assetGUID", "Asset", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getNotes"), elementStart, maxElements, "getNotes"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getNotes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RatingsResponse getRatings(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getRatings";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRatings");
        RatingsResponse response = new RatingsResponse();
        AuditLog auditLog = null;
        try {
            RatingHandler<Rating> handler = instanceHandler.getRatingHandler(userId, serverName, "getRatings");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRatings");
            response.setList(handler.getRatings(userId, assetGUID, "assetGUID", "Asset", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getRatings"), elementStart, maxElements, "getRatings"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRatings", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedAssetsResponse getRelatedAssets(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getRelatedAssets";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedAssets");
        RelatedAssetsResponse response = new RelatedAssetsResponse();
        AuditLog auditLog = null;
        try {
            RelatedAssetHandler<RelatedAsset> handler = instanceHandler.getRelatedAssetHandler(userId, serverName, "getRelatedAssets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedAssets");
            response.setList(handler.getRelatedAssets(userId, assetGUID, "assetGUID", "Asset", null, null, instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getRelatedAssets"), elementStart, maxElements, new Date(), "getRelatedAssets"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelatedAssets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public MoreInformationResponse getMoreInformation(String serverName, String serviceURLName, String userId, String elementGUID, int elementStart, int maxElements) {
        String methodName = "getMoreInformation";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMoreInformation");
        MoreInformationResponse response = new MoreInformationResponse();
        AuditLog auditLog = null;
        try {
            ReferenceableHandler<Referenceable> handler = instanceHandler.getReferenceableHandler(userId, serverName, "getMoreInformation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMoreInformation");
            response.setList(handler.getMoreInformation(userId, elementGUID, "assetGUID", "Referenceable", "Referenceable", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getMoreInformation"), elementStart, maxElements, new Date(), "getMoreInformation"));
            response.setStartingFromElement(elementStart);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMoreInformation", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RelatedMediaReferencesResponse getRelatedMediaReferences(String serverName, String serviceURLName, String userId, String assetGUID, int elementStart, int maxElements) {
        String methodName = "getRelatedMediaReferences";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRelatedMediaReferences");
        RelatedMediaReferencesResponse response = new RelatedMediaReferencesResponse();
        AuditLog auditLog = null;
        try {
            RelatedMediaHandler<RelatedMediaReference> handler = instanceHandler.getRelatedMediaHandler(userId, serverName, "getRelatedMediaReferences");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRelatedMediaReferences");
            response.setList(handler.getRelatedMedia(userId, assetGUID, "assetGUID", "Asset", instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getRelatedMediaReferences"), elementStart, maxElements, new Date(), "getRelatedMediaReferences"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRelatedMediaReferences", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public SchemaAttributesResponse getSchemaAttributes(String serverName, String serviceURLName, String userId, String schemaTypeGUID, int elementStart, int maxElements) {
        String methodName = "getSchemaAttributes";
        String guidParameterName = "assetGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getSchemaAttributes");
        SchemaAttributesResponse response = new SchemaAttributesResponse();
        AuditLog auditLog = null;
        try {
            SchemaAttributeHandler<SchemaAttribute, SchemaType> handler = instanceHandler.getSchemaAttributeHandler(userId, serverName, "getSchemaAttributes");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getSchemaAttributes");
            response.setList(handler.getSchemaAttributesForComplexSchemaType(userId, schemaTypeGUID, "assetGUID", "SchemaAttribute", null, null, instanceHandler.getSupportedZones(userId, serverName, serviceURLName, "getSchemaAttributes"), elementStart, maxElements, new Date(), "getSchemaAttributes"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getSchemaAttributes", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

