/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class CommentConverter<B>
extends OCFConverter<B> {
    public CommentConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof Comment) {
                Comment bean = (Comment)returnBean;
                this.setUpElementHeader((ElementHeader)bean, entity, OpenMetadataType.COMMENT.typeName, methodName);
                InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                bean.setCommentType(this.removeCommentTypeFromProperties(instanceProperties));
                bean.setCommentText(this.removeCommentText(instanceProperties));
                bean.setUser(entity.getCreatedBy());
                bean.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                if (relationship != null) {
                    instanceProperties = new InstanceProperties(relationship.getProperties());
                    bean.setIsPublic(this.getIsPublic(instanceProperties));
                }
                return returnBean;
            }
            super.handleUnexpectedBeanClass(beanClass.getName(), Comment.class.getName(), methodName);
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
        }
        return null;
    }

    private CommentType removeCommentTypeFromProperties(InstanceProperties properties) {
        CommentType commentType = this.getCommentTypeFromProperties(properties);
        if (properties != null) {
            Map instancePropertiesMap = properties.getInstanceProperties();
            if (instancePropertiesMap != null) {
                instancePropertiesMap.remove(OpenMetadataProperty.COMMENT_TYPE.name);
            }
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return commentType;
    }

    private CommentType getCommentTypeFromProperties(InstanceProperties properties) {
        InstancePropertyValue instancePropertyValue;
        Map instancePropertiesMap;
        CommentType commentType = CommentType.STANDARD_COMMENT;
        if (properties != null && (instancePropertiesMap = properties.getInstanceProperties()) != null && (instancePropertyValue = (InstancePropertyValue)instancePropertiesMap.get(OpenMetadataProperty.COMMENT_TYPE.name)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            commentType = switch (enumPropertyValue.getOrdinal()) {
                case 0 -> CommentType.STANDARD_COMMENT;
                case 1 -> CommentType.QUESTION;
                case 2 -> CommentType.ANSWER;
                case 3 -> CommentType.SUGGESTION;
                case 4 -> CommentType.USAGE_EXPERIENCE;
                case 99 -> CommentType.OTHER;
                default -> commentType;
            };
        }
        return commentType;
    }
}

