/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.RelatedAsset;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class RelatedAssetConverter<B>
extends OCFConverter<B> {
    public RelatedAssetConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, null, methodName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof RelatedAsset) {
                RelatedAsset bean = (RelatedAsset)returnBean;
                this.setUpElementHeader((ElementHeader)bean, entity, OpenMetadataType.ASSET.typeName, methodName);
                InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                bean.setResourceName(this.removeName(instanceProperties));
                bean.setVersionIdentifier(this.removeVersionIdentifier(instanceProperties));
                bean.setResourceDescription(this.removeDescription(instanceProperties));
                bean.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                if (relationship != null) {
                    TypeDef typeDef;
                    bean.setRelationshipName(relationship.getType().getTypeDefName());
                    boolean relatedAssetAtEndOne = true;
                    if (relationship.getEntityTwoProxy().getGUID().equals(entity.getGUID())) {
                        relatedAssetAtEndOne = false;
                    }
                    if ((typeDef = this.repositoryHelper.getTypeDefByName(methodName, relationship.getType().getTypeDefName())) instanceof RelationshipDef) {
                        RelationshipDef relationshipDef = (RelationshipDef)typeDef;
                        RelationshipEndDef endDef = relatedAssetAtEndOne ? relationshipDef.getEndDef1() : relationshipDef.getEndDef2();
                        bean.setAttributeName(endDef.getAttributeName());
                    }
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

