/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.AssetResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CertificationsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.CommentsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ExternalIdentifiersResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ExternalReferencesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.InformalTagsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.LicensesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.LikesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.LocationsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.MoreInformationResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.NoteLogsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.NotesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RatingsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RelatedAssetsResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.RelatedMediaReferencesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.SchemaAttributesResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.server.OCFMetadataRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/common-services/{serviceURLName}/connected-asset/users/{userId}"})
@Tag(name="OCF Metadata Management Services", description="OCF metadata management provides common services for Open Metadata Access Services (OMASs) that are supporting the Open Connector Framework (OCF).", externalDocs=@ExternalDocumentation(description="OCF Metadata Management", url="https://odpi.github.io/egeria-docs/services/ocf-metadata-management/"))
public class ConnectedAssetResource {
    private OCFMetadataRESTServices restAPI = new OCFMetadataRESTServices();

    @GetMapping(path={"/connections/{guid}"})
    public ConnectionResponse getConnectionByGUID(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getConnectionByGUID(serverName, serviceURLName, userId, guid);
    }

    @GetMapping(path={"/connections/by-name/{name}"})
    public ConnectionResponse getConnectionByName(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getConnectionByName(serverName, serviceURLName, userId, name);
    }

    @GetMapping(path={"/assets/{assetGUID}/connection"})
    public ConnectionResponse getConnectionForAsset(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.getConnectionForAsset(serverName, serviceURLName, userId, assetGUID);
    }

    @GetMapping(path={"/assets/by-connection/{connectionGUID}"})
    public GUIDResponse getAssetForConnectionGUID(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String connectionGUID) {
        return this.restAPI.getAssetForConnectionGUID(serverName, serviceURLName, userId, connectionGUID);
    }

    @GetMapping(path={"/assets/{assetGUID}/via-connection/{connectionGUID}"})
    public AssetResponse getConnectedAssetSummary(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String connectionGUID) {
        return this.restAPI.getConnectedAssetSummary(serverName, serviceURLName, userId, assetGUID, connectionGUID);
    }

    @GetMapping(path={"/assets/{assetGUID}"})
    public AssetResponse getAssetSummary(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID) {
        return this.restAPI.getAssetSummary(serverName, serviceURLName, userId, assetGUID);
    }

    @GetMapping(path={"/assets/{assetGUID}/certifications"})
    public CertificationsResponse getCertifications(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getCertifications(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/comments"})
    public CommentsResponse getAssetComments(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getAssetComments(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/comments/{commentGUID}/replies"})
    public CommentsResponse getAssetCommentReplies(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String commentGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getAssetCommentReplies(serverName, serviceURLName, userId, assetGUID, commentGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/connections"})
    public ConnectionsResponse getConnections(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getConnections(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/external-identifiers"})
    public ExternalIdentifiersResponse getExternalIdentifiers(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getExternalIdentifiers(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/external-references"})
    public ExternalReferencesResponse getExternalReferences(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getExternalReferences(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/informal-tags"})
    public InformalTagsResponse getInformalTags(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getInformalTags(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/licenses"})
    public LicensesResponse getLicenses(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getLicenses(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/likes"})
    public LikesResponse getLikes(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getLikes(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/known-locations"})
    public LocationsResponse getKnownLocations(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getKnownLocations(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/note-logs"})
    public NoteLogsResponse getNoteLogs(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getNoteLogs(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/note-log/{noteLogGUID}/notes"})
    public NotesResponse getNotes(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String noteLogGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getNotes(serverName, serviceURLName, userId, noteLogGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/ratings"})
    public RatingsResponse getRatings(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getRatings(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/related-assets"})
    public RelatedAssetsResponse getRelatedAssets(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getRelatedAssets(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/referenceables/{elementGUID}/more-information"})
    public MoreInformationResponse getMoreInformation(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getMoreInformation(serverName, serviceURLName, userId, elementGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/{assetGUID}/related-media-references"})
    public RelatedMediaReferencesResponse getRelatedMediaReferences(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getRelatedMediaReferences(serverName, serviceURLName, userId, assetGUID, elementStart, maxElements);
    }

    @GetMapping(path={"/assets/schemas/{schemaTypeGUID}/schema-attributes"})
    public SchemaAttributesResponse getSchemaAttributes(@PathVariable String serverName, @PathVariable String serviceURLName, @PathVariable String userId, @PathVariable String schemaTypeGUID, @RequestParam int elementStart, @RequestParam int maxElements) {
        return this.restAPI.getSchemaAttributes(serverName, serviceURLName, userId, schemaTypeGUID, elementStart, maxElements);
    }
}

