/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers;

import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.DataFieldHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AnnotationHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private DataFieldHandler dataFieldHandler;

    public AnnotationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, DataFieldHandler dataFieldHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.dataFieldHandler = dataFieldHandler;
    }

    List<Annotation> getAnnotationsLinkedToAnchor(String userId, String anchorGUID, String anchorGUIDParameterName, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, anchorGUIDParameterName, methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, methodName);
        return null;
    }

    List<Annotation> getAnnotationsLinkedToAnchor(String userId, String anchorGUID, String anchorGUIDParameterName, AnnotationStatus annotationStatus, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, anchorGUIDParameterName, methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, methodName);
        return null;
    }

    public List<Annotation> getExtendedAnnotations(String userId, String annotationGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameter = "annotationGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, methodName);
        return null;
    }

    public Annotation getAnnotation(String userId, String annotationGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
        return null;
    }

    private String addAnnotationToAnchor(String userId, String anchorGUID, String anchorGUIDParameterName, String relationshipTypeGUID, String relationshipTypeName, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationParameterName = "annotation";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, anchorGUIDParameterName, methodName);
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        return null;
    }

    public Annotation addAnnotationToAnnotation(String userId, String anchorAnnotationGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "anchorAnnotationGUID";
        String annotationParameterName = "annotation";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/extended-annotations";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorAnnotationGUID, "anchorAnnotationGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        return null;
    }

    public void linkAnnotation(String userId, String anchorGUID, String annotationGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String anchorGUIDParameterName = "anchorGUID";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/related-instances{3}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
    }

    public void unlinkAnnotation(String userId, String anchorGUID, String annotationGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String anchorGUIDParameterName = "anchorGUID";
        String annotationGUIDParameterName = "annotationGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", methodName);
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
    }

    public Annotation updateAnnotation(String userId, String annotationGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationParameterName = "annotation";
        String annotationGUIDParameterName = "annotationGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
        return null;
    }

    public void deleteAnnotation(String userId, String annotationGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
    }
}

