/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryAnalysisReportHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private AnnotationHandler annotationHandler;

    public DiscoveryAnalysisReportHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, AnnotationHandler annotationHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.annotationHandler = annotationHandler;
    }

    public DiscoveryAnalysisReport createDiscoveryAnalysisReport(String userId, String qualifiedName, String displayName, String description, Date creationDate, Map<String, String> analysisParameters, DiscoveryRequestStatus discoveryRequestStatus, String assetGUID, String discoveryEngineGUID, String discoveryServiceGUID, Map<String, String> additionalProperties, List<Classification> classifications, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "qualifiedName";
        String assetGUIDParameterName = "assetGUID";
        String discoveryEngineGUIDParameterName = "discoveryEngineGUID";
        String discoveryServiceGUIDParameterName = "discoveryServiceGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", methodName);
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", methodName);
        this.repositoryHandler.validateEntityGUID(userId, assetGUID, "Asset", methodName, "assetGUID");
        this.repositoryHandler.validateEntityGUID(userId, assetGUID, "OpenDiscoveryEngine", methodName, "discoveryEngineGUID");
        return null;
    }

    public DiscoveryAnalysisReport updateDiscoveryAnalysisReport(String userId, String discoveryReportGUID, DiscoveryAnalysisReport updatedReport) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDiscoveryAnalysisReport";
        String reportParameterName = "updatedReport";
        String reportGUIDParameterName = "updatedReport.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, "updateDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateObject((Object)updatedReport, "updatedReport", "updateDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(updatedReport.getGUID(), "updatedReport.getGUID()", "updateDiscoveryAnalysisReport");
        return null;
    }

    public DiscoveryAnalysisReport getDiscoveryAnalysisReport(String userId, String discoveryReportGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "discoveryReportGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", methodName);
        return null;
    }

    public List<DiscoveryAnalysisReport> getDiscoveryAnalysisReports(String userId, String assetGUID, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, methodName);
        return null;
    }

    public List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "discoveryReportGUID";
        return this.annotationHandler.getAnnotationsLinkedToAnchor(userId, discoveryReportGUID, "discoveryReportGUID", annotationStatus, startingFrom, maximumResults, methodName);
    }

    public List<Annotation> getAnnotationsForAssetByStatus(String userId, String assetGUID, AnnotationStatus status, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, methodName);
        return null;
    }

    public String addAnnotationToDiscoveryReport(String userId, String discoveryReportGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationParameterName = "annotation";
        String reportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        return null;
    }
}

