/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.odf.metadatamanagement.builders;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryAnalysisReportBuilder
extends ReferenceableBuilder {
    private String displayName;
    private String description;
    private Date creationDate = null;
    private Map<String, String> analysisParameters = null;
    private DiscoveryRequestStatus discoveryRequestStatus = null;
    private String assetGUID = null;
    private String discoveryEngineGUID = null;
    private String discoveryServiceGUID = null;

    public DiscoveryAnalysisReportBuilder(String qualifiedName, String displayName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = null;
    }

    public DiscoveryAnalysisReportBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    public DiscoveryAnalysisReportBuilder(String qualifiedName, String displayName, String description, Date creationDate, Map<String, String> analysisParameters, DiscoveryRequestStatus discoveryRequestStatus, String assetGUID, String discoveryEngineGUID, String discoveryServiceGUID, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.creationDate = creationDate;
        this.analysisParameters = analysisParameters;
        this.discoveryRequestStatus = discoveryRequestStatus;
        this.assetGUID = assetGUID;
        this.discoveryEngineGUID = discoveryEngineGUID;
        this.discoveryServiceGUID = discoveryServiceGUID;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.creationDate != null) {
            properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "executionDate", this.creationDate, methodName);
        }
        if (this.analysisParameters != null) {
            properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, "analysisParameters", this.analysisParameters, methodName);
        }
        if (this.discoveryRequestStatus != null) {
            properties = this.addDiscoveryRequestStatusToProperties(properties, methodName);
        }
        return properties;
    }

    public InstanceProperties getNameInstanceProperties(String methodName) {
        InstanceProperties properties = super.getNameInstanceProperties(methodName);
        if (this.displayName != null) {
            String literalName = this.repositoryHelper.getExactMatchRegex(this.displayName);
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", literalName, methodName);
        }
        return properties;
    }

    protected InstanceProperties addDiscoveryRequestStatusToProperties(InstanceProperties properties, String methodName) {
        InstanceProperties resultingProperties = properties;
        switch (this.discoveryRequestStatus) {
            case WAITING: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "discoveryRequestStatus", 0, "Waiting", "Discovery request is waiting to execute.", methodName);
                break;
            }
            case IN_PROGRESS: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "discoveryRequestStatus", 1, "InProgress", "Discovery request is executing.", methodName);
                break;
            }
            case FAILED: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "discoveryRequestStatus", 1, "Failed", "Discovery request has failed.", methodName);
                break;
            }
            case COMPLETED: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "discoveryRequestStatus", 1, "Completed", "Discovery request has completed successfully.", methodName);
                break;
            }
            case UNKNOWN_STATUS: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "discoveryRequestStatus", 99, "Unknown", "Discovery request status is unknown.", methodName);
            }
        }
        return resultingProperties;
    }
}

