/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.builders.AnnotationBuilder;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.builders.SuspectDuplicateAnnotationBuilder;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.converters.AnnotationConverter;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.DataFieldHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryRelatedEntitiesIterator;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.SuspectDuplicateAnnotation;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AnnotationHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private DataFieldHandler dataFieldHandler;

    public AnnotationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, DataFieldHandler dataFieldHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.dataFieldHandler = dataFieldHandler;
    }

    public List<String> getTypesOfAnnotation() {
        return this.repositoryHelper.getSubTypesOf(this.serviceName, "Annotation");
    }

    public Map<String, String> getTypesOfAnnotationDescriptions() {
        List annotationTypeList = this.repositoryHelper.getSubTypesOf(this.serviceName, "Annotation");
        HashMap<String, String> annotationDescriptions = new HashMap<String, String>();
        if (annotationTypeList != null) {
            for (String annotationTypeName : annotationTypeList) {
                TypeDef annotationTypeDef;
                if (annotationTypeName == null || (annotationTypeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, annotationTypeName)) == null) continue;
                annotationDescriptions.put(annotationTypeName, annotationTypeDef.getDescription());
            }
        }
        if (annotationDescriptions.isEmpty()) {
            return null;
        }
        return annotationDescriptions;
    }

    List<Annotation> getAnnotationsLinkedToAnchor(String userId, String anchorGUID, String anchorGUIDTypeName, String anchorGUIDParameterName, String relationshipTypeGUID, String relationshipTypeName, AnnotationStatus annotationStatus, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorGUID, anchorGUIDParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, methodName);
        RepositoryRelatedEntitiesIterator iterator = new RepositoryRelatedEntitiesIterator(this.repositoryHandler, userId, anchorGUID, anchorGUIDTypeName, relationshipTypeGUID, relationshipTypeName, startingFrom, queryPageSize, methodName);
        ArrayList<Annotation> results = new ArrayList<Annotation>();
        while (iterator.moreToReceive()) {
            EntityDetail annotationEntity = iterator.getNext();
            Relationship annotationReviewLink = this.repositoryHandler.getUniqueRelationshipByType(userId, annotationEntity.getGUID(), "Annotation", "6cea5b53-558c-48f1-8191-11d48db29fb4", "AnnotationReviewLink", methodName);
            EntityDetail annotationReviewEntity = null;
            if (annotationReviewLink != null) {
                annotationReviewEntity = this.repositoryHandler.getEntityByGUID(userId, annotationReviewLink.getEntityTwoProxy().getGUID(), "annotationReviewLink.end2.getGUID", "AnnotationReview", methodName);
            }
            AnnotationConverter converter = new AnnotationConverter(annotationEntity, annotationReviewLink, annotationReviewEntity, this.repositoryHelper, this.serviceName);
            results.add(converter.getBean());
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<Annotation> getExtendedAnnotations(String userId, String annotationGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameter = "annotationGUID";
        return this.getAnnotationsLinkedToAnchor(userId, annotationGUID, "Annotation", "annotationGUID", "605aaa6d-682e-405c-964b-ca6aaa94be1b", "Annotation", annotationStatus, startingFrom, maximumResults, methodName);
    }

    public Annotation getAnnotation(String userId, String annotationGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, annotationGUID, "annotationGUID", "Annotation", methodName);
        AnnotationConverter converter = new AnnotationConverter(entity, null, null, this.repositoryHelper, methodName);
        return converter.getBean();
    }

    public String addAnnotationToAnnotation(String userId, String anchorAnnotationGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "anchorAnnotationGUID";
        String annotationParameterName = "annotation";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(anchorAnnotationGUID, "anchorAnnotationGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        String annotationGUID = this.addNewAnnotation(userId, annotation, methodName);
        if (annotationGUID != null) {
            this.repositoryHandler.createRelationship(userId, "605aaa6d-682e-405c-964b-ca6aaa94be1b", anchorAnnotationGUID, annotationGUID, null, methodName);
        }
        return annotationGUID;
    }

    private InstanceProperties getAnnotationInstanceProperties(String userId, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parameterName = "annotation";
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        this.invalidParameterHandler.validateUserId(userId, methodName);
        if (annotation instanceof SuspectDuplicateAnnotation) {
            SuspectDuplicateAnnotation suspectDuplicateAnnotation = (SuspectDuplicateAnnotation)annotation;
            SuspectDuplicateAnnotationBuilder builder = new SuspectDuplicateAnnotationBuilder(suspectDuplicateAnnotation.getAnnotationType(), suspectDuplicateAnnotation.getSummary(), suspectDuplicateAnnotation.getConfidenceLevel(), suspectDuplicateAnnotation.getExpression(), suspectDuplicateAnnotation.getExplanation(), suspectDuplicateAnnotation.getAnalysisStep(), suspectDuplicateAnnotation.getJsonProperties(), suspectDuplicateAnnotation.getDuplicateAnchorGUIDs(), suspectDuplicateAnnotation.getMatchingPropertyNames(), suspectDuplicateAnnotation.getMatchingClassificationNames(), suspectDuplicateAnnotation.getMatchingAttachmentGUIDs(), suspectDuplicateAnnotation.getMatchingRelationshipGUIDs(), suspectDuplicateAnnotation.getAdditionalProperties(), this.repositoryHelper, this.serviceName, this.serverName);
            return builder.getAnnotationInstanceProperties(methodName);
        }
        AnnotationBuilder builder = new AnnotationBuilder(annotation.getAnnotationType(), annotation.getSummary(), annotation.getConfidenceLevel(), annotation.getExpression(), annotation.getExplanation(), annotation.getAnalysisStep(), annotation.getJsonProperties(), annotation.getAdditionalProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        return builder.getAnnotationInstanceProperties(methodName);
    }

    String getAnnotationTypeGUID(Annotation annotation) {
        String typeGUID = null;
        if (annotation != null && annotation.getType() != null) {
            typeGUID = annotation.getType().getElementTypeId();
        }
        if (typeGUID == null && annotation instanceof SuspectDuplicateAnnotation) {
            typeGUID = "f703a621-4078-4c07-ab22-e7c334b94235";
        }
        if (typeGUID != null) {
            return typeGUID;
        }
        return "6cea5b53-558c-48f1-8191-11d48db29fb4";
    }

    String getAnnotationTypeName(Annotation annotation) {
        String typeName = null;
        if (annotation != null && annotation.getType() != null) {
            typeName = annotation.getType().getElementTypeName();
        }
        if (typeName == null && annotation instanceof SuspectDuplicateAnnotation) {
            typeName = "SuspectDuplicateAnnotation";
        }
        if (typeName != null) {
            return typeName;
        }
        return "Annotation";
    }

    String addNewAnnotation(String userId, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties instanceProperties = this.getAnnotationInstanceProperties(userId, annotation, methodName);
        return this.repositoryHandler.createEntity(userId, this.getAnnotationTypeGUID(annotation), this.getAnnotationTypeName(annotation), instanceProperties, methodName);
    }

    public void updateAnnotation(String userId, String annotationGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
        InstanceProperties instanceProperties = this.getAnnotationInstanceProperties(userId, annotation, methodName);
        this.repositoryHandler.updateEntity(userId, annotationGUID, "6cea5b53-558c-48f1-8191-11d48db29fb4", "Annotation", instanceProperties, methodName);
    }

    public void deleteAnnotation(String userId, String annotationGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationGUIDParameterName = "annotationGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", methodName);
        this.repositoryHandler.removeIsolatedEntity(userId, annotationGUID, "6cea5b53-558c-48f1-8191-11d48db29fb4", "Annotation", methodName);
    }
}

