/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.odf.metadatamanagement.converters;

import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ElementHeaderConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AnnotationConverter
extends ElementHeaderConverter {
    private EntityDetail annotationEntity;
    private Relationship annotationReviewLink;
    private EntityDetail annotationReview;
    private OMRSRepositoryHelper repositoryHelper;
    private String serviceName;

    public AnnotationConverter(EntityDetail annotationEntity, Relationship annotationReviewLink, EntityDetail annotationReview, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(annotationEntity, annotationReviewLink, repositoryHelper, serviceName);
        this.annotationEntity = annotationEntity;
        this.annotationReviewLink = annotationReviewLink;
        this.annotationReview = annotationReview;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
    }

    Map<String, Object> updateBean(Annotation bean) {
        String methodName = "updateBean";
        HashMap<String, Object> extendedProperties = new HashMap<String, Object>();
        if (this.annotationEntity != null) {
            Map elementExtendedProperties;
            super.updateBean((ElementHeader)bean);
            InstanceProperties instanceProperties = this.entity.getProperties();
            if (instanceProperties != null) {
                bean.setAnnotationType(this.repositoryHelper.removeStringProperty(this.serviceName, "annotationType", instanceProperties, "updateBean"));
                bean.setSummary(this.repositoryHelper.removeStringProperty(this.serviceName, "summary", instanceProperties, "updateBean"));
                bean.setConfidenceLevel(this.repositoryHelper.removeIntProperty(this.serviceName, "confidenceLevel", instanceProperties, "updateBean"));
                bean.setExpression(this.repositoryHelper.removeStringProperty(this.serviceName, "expression", instanceProperties, "updateBean"));
                bean.setExplanation(this.repositoryHelper.removeStringProperty(this.serviceName, "explanation", instanceProperties, "updateBean"));
                bean.setAnalysisStep(this.repositoryHelper.removeStringProperty(this.serviceName, "analysisStep", instanceProperties, "updateBean"));
                bean.setJsonProperties(this.repositoryHelper.removeStringProperty(this.serviceName, "jsonProperties", instanceProperties, "updateBean"));
                bean.setAdditionalProperties(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "additionalProperties", instanceProperties, "updateBean"));
                elementExtendedProperties = this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties);
                if (elementExtendedProperties != null) {
                    extendedProperties.putAll(elementExtendedProperties);
                }
            }
            if (this.annotationReviewLink != null) {
                instanceProperties = this.annotationReviewLink.getProperties();
                bean.setAnnotationStatus(this.removeAnnotationStatusFromProperties(instanceProperties));
                elementExtendedProperties = this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties);
                if (elementExtendedProperties != null) {
                    extendedProperties.putAll(elementExtendedProperties);
                }
                if (this.annotationReview != null) {
                    instanceProperties = this.annotationReviewLink.getProperties();
                    bean.setReviewDate(this.repositoryHelper.removeDateProperty(this.serviceName, "reviewDate", instanceProperties, "updateBean"));
                    bean.setSteward(this.repositoryHelper.removeStringProperty(this.serviceName, "steward", instanceProperties, "updateBean"));
                    bean.setReviewComment(this.repositoryHelper.removeStringProperty(this.serviceName, "comment", instanceProperties, "updateBean"));
                    elementExtendedProperties = this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties);
                    if (elementExtendedProperties != null) {
                        extendedProperties.putAll(elementExtendedProperties);
                    }
                }
            }
        }
        if (!extendedProperties.isEmpty()) {
            return extendedProperties;
        }
        return null;
    }

    public Annotation getBean() {
        Annotation bean = null;
        if (this.annotationEntity != null) {
            bean = new Annotation();
            bean.setExtendedProperties(this.updateBean(bean));
        }
        return bean;
    }

    private AnnotationStatus removeAnnotationStatusFromProperties(InstanceProperties properties) {
        Map instancePropertiesMap;
        InstancePropertyValue instancePropertyValue;
        AnnotationStatus requestStatus = AnnotationStatus.UNKNOWN_STATUS;
        if (properties != null && (instancePropertyValue = (InstancePropertyValue)(instancePropertiesMap = properties.getInstanceProperties()).get("annotationStatus")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    requestStatus = AnnotationStatus.NEW_ANNOTATION;
                    break;
                }
                case 1: {
                    requestStatus = AnnotationStatus.REVIEWED_ANNOTATION;
                    break;
                }
                case 2: {
                    requestStatus = AnnotationStatus.APPROVED_ANNOTATION;
                    break;
                }
                case 3: {
                    requestStatus = AnnotationStatus.ACTIONED_ANNOTATION;
                    break;
                }
                case 4: {
                    requestStatus = AnnotationStatus.INVALID_ANNOTATION;
                    break;
                }
                case 5: {
                    requestStatus = AnnotationStatus.IGNORE_ANNOTATION;
                    break;
                }
                case 98: {
                    requestStatus = AnnotationStatus.OTHER_STATUS;
                    break;
                }
                default: {
                    requestStatus = AnnotationStatus.UNKNOWN_STATUS;
                }
            }
            instancePropertiesMap.remove("annotationStatus");
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return requestStatus;
    }
}

