/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.odf.metadatamanagement.builders;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class AnnotationReviewBuilder {
    protected AnnotationStatus annotationStatus;
    protected Date reviewDate;
    protected String steward;
    protected String reviewComment;
    protected Map<String, String> additionalProperties;
    protected Map<String, Object> extendedProperties;
    protected OMRSRepositoryHelper repositoryHelper;
    protected String serviceName;
    protected String serverName;

    public AnnotationReviewBuilder(AnnotationStatus annotationStatus, Date reviewDate, String steward, String reviewComment, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.annotationStatus = annotationStatus;
        this.reviewDate = reviewDate;
        this.steward = steward;
        this.reviewComment = reviewComment;
        this.additionalProperties = additionalProperties;
        this.extendedProperties = extendedProperties;
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    public InstanceProperties getReviewLinkInstanceProperties(String methodName) {
        InstanceProperties properties = new InstanceProperties();
        if (this.annotationStatus != null) {
            properties = this.addAnnotationStatusToProperties(properties, methodName);
        }
        return properties;
    }

    public InstanceProperties getAnnotationReviewInstanceProperties(String methodName) {
        InstanceProperties properties = new InstanceProperties();
        if (this.reviewDate != null) {
            properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "reviewDate", this.reviewDate, methodName);
        }
        if (this.steward != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "steward", this.steward, methodName);
        }
        if (this.reviewComment != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "comment", this.reviewComment, methodName);
        }
        return properties;
    }

    protected InstanceProperties addAnnotationStatusToProperties(InstanceProperties properties, String methodName) {
        InstanceProperties resultingProperties = properties;
        switch (this.annotationStatus) {
            case NEW_ANNOTATION: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "annotationStatus", 0, "New", "The annotation is new.", methodName);
                break;
            }
            case REVIEWED_ANNOTATION: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "annotationStatus", 1, "Reviewed", "The annotation has been reviewed by a steward.", methodName);
                break;
            }
            case APPROVED_ANNOTATION: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "annotationStatus", 2, "Approved", "The annotation has been approved.", methodName);
                break;
            }
            case ACTIONED_ANNOTATION: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "annotationStatus", 3, "Actioned", "The request has been actioned.", methodName);
                break;
            }
            case INVALID_ANNOTATION: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "annotationStatus", 4, "Invalid", "The annotation is invalid or incorrect.", methodName);
                break;
            }
            case IGNORE_ANNOTATION: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "annotationStatus", 5, "Ignore", "The annotation should be ignored.", methodName);
                break;
            }
            case OTHER_STATUS: {
                resultingProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, resultingProperties, "annotationStatus", 99, "Other", "Another status.", methodName);
            }
        }
        return resultingProperties;
    }
}

