/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.builders.DiscoveryAnalysisReportBuilder;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.converters.DiscoveryAnalysisReportConverter;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryAnalysisReportHandler {
    private String serviceName;
    private String serverName;
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;
    private AnnotationHandler annotationHandler;

    public DiscoveryAnalysisReportHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, AnnotationHandler annotationHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHandler = repositoryHandler;
        this.repositoryHelper = repositoryHelper;
        this.annotationHandler = annotationHandler;
    }

    public String createDiscoveryAnalysisReport(String userId, String qualifiedName, String displayName, String description, Date creationDate, Map<String, String> analysisParameters, DiscoveryRequestStatus discoveryRequestStatus, String assetGUID, String discoveryEngineGUID, String discoveryServiceGUID, Map<String, String> additionalProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "qualifiedName";
        String assetGUIDParameterName = "assetGUID";
        String discoveryEngineGUIDParameterName = "discoveryEngineGUID";
        String discoveryServiceGUIDParameterName = "discoveryServiceGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", methodName);
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", methodName);
        this.repositoryHandler.validateEntityGUID(userId, assetGUID, "Asset", methodName, "assetGUID");
        this.repositoryHandler.validateEntityGUID(userId, assetGUID, "OpenDiscoveryEngine", methodName, "discoveryEngineGUID");
        DiscoveryAnalysisReportBuilder builder = new DiscoveryAnalysisReportBuilder(qualifiedName, displayName, description, creationDate, analysisParameters, discoveryRequestStatus, additionalProperties, null, this.repositoryHelper, this.serviceName, this.serverName);
        String reportGUID = this.repositoryHandler.createEntity(userId, "acc7cbc8-09c3-472b-87dd-f78459323dcb", "OpenDiscoveryAnalysisReport", builder.getInstanceProperties(methodName), methodName);
        if (reportGUID != null) {
            this.repositoryHandler.createRelationship(userId, "7eded424-f176-4258-9ae6-138a46b2845f", assetGUID, reportGUID, null, methodName);
            this.repositoryHandler.createRelationship(userId, "2c318c3a-5dc2-42cd-a933-0087d852f67f", discoveryEngineGUID, reportGUID, null, methodName);
            this.repositoryHandler.createRelationship(userId, "1744d72b-903d-4273-9229-de20372a17e2", discoveryServiceGUID, reportGUID, null, methodName);
        }
        return reportGUID;
    }

    public void updateDiscoveryAnalysisReport(String userId, String discoveryReportGUID, DiscoveryAnalysisReport updatedReport) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDiscoveryAnalysisReport";
        String reportParameterName = "updatedReport";
        String reportGUIDParameterName = "updatedReport.getGUID()";
        this.invalidParameterHandler.validateUserId(userId, "updateDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateObject((Object)updatedReport, "updatedReport", "updateDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(updatedReport.getGUID(), "updatedReport.getGUID()", "updateDiscoveryAnalysisReport");
        DiscoveryAnalysisReportBuilder builder = new DiscoveryAnalysisReportBuilder(updatedReport.getQualifiedName(), updatedReport.getDisplayName(), updatedReport.getDescription(), updatedReport.getCreationDate(), updatedReport.getAnalysisParameters(), updatedReport.getDiscoveryRequestStatus(), updatedReport.getAdditionalProperties(), updatedReport.getExtendedProperties(), this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.updateEntity(userId, discoveryReportGUID, "acc7cbc8-09c3-472b-87dd-f78459323dcb", "OpenDiscoveryAnalysisReport", builder.getInstanceProperties("updateDiscoveryAnalysisReport"), "updateDiscoveryAnalysisReport");
    }

    public DiscoveryAnalysisReport getDiscoveryAnalysisReport(String userId, String discoveryReportGUID, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "discoveryReportGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", methodName);
        EntityDetail entity = this.repositoryHandler.getEntityByGUID(userId, discoveryReportGUID, "discoveryReportGUID", "OpenDiscoveryAnalysisReport", methodName);
        DiscoveryAnalysisReportConverter converter = new DiscoveryAnalysisReportConverter(entity, this.repositoryHelper, this.serviceName);
        return converter.getBean();
    }

    public List<DiscoveryAnalysisReport> getDiscoveryAnalysisReports(String userId, String assetGUID, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, methodName);
        List entities = this.repositoryHandler.getEntitiesForRelationshipType(userId, assetGUID, "Asset", "7eded424-f176-4258-9ae6-138a46b2845f", "AssetDiscoveryReport", startingFrom, queryPageSize, methodName);
        if (entities != null) {
            ArrayList<DiscoveryAnalysisReport> discoveryAnalysisReports = new ArrayList<DiscoveryAnalysisReport>();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                DiscoveryAnalysisReportConverter converter = new DiscoveryAnalysisReportConverter(entity, this.repositoryHelper, this.serviceName);
                discoveryAnalysisReports.add(converter.getBean());
            }
            if (!discoveryAnalysisReports.isEmpty()) {
                return discoveryAnalysisReports;
            }
        }
        return null;
    }

    public List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, AnnotationStatus annotationStatus, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "discoveryReportGUID";
        return this.annotationHandler.getAnnotationsLinkedToAnchor(userId, discoveryReportGUID, "OpenDiscoveryAnalysisReport", "discoveryReportGUID", "51d386a3-3857-42e3-a3df-14a6cad08b93", "DiscoveredAnnotation", annotationStatus, startingFrom, maximumResults, methodName);
    }

    public List<Annotation> getAnnotationsForAssetByStatus(String userId, String assetGUID, AnnotationStatus status, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String assetGUIDParameterName = "assetGUID";
        return null;
    }

    public String addAnnotationToDiscoveryReport(String userId, String discoveryReportGUID, Annotation annotation, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String annotationParameterName = "annotation";
        String reportGUIDParameterName = "discoveryReportGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", methodName);
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", methodName);
        String annotationGUID = this.annotationHandler.addNewAnnotation(userId, annotation, methodName);
        if (annotationGUID != null) {
            this.repositoryHandler.createRelationship(userId, "51d386a3-3857-42e3-a3df-14a6cad08b93", annotationGUID, discoveryReportGUID, null, methodName);
        }
        return annotationGUID;
    }
}

