/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.odf.metadatamanagement.converters;

import java.util.Map;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.converters.ReferenceableConverter;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryAnalysisReportConverter
extends ReferenceableConverter {
    public DiscoveryAnalysisReportConverter(EntityDetail mainEntity, OMRSRepositoryHelper repositoryHelper, String serviceName) {
        super(mainEntity, repositoryHelper, serviceName);
    }

    public DiscoveryAnalysisReport getBean() {
        String methodName = "getBean";
        DiscoveryAnalysisReport bean = new DiscoveryAnalysisReport();
        super.updateBean((Referenceable)bean);
        InstanceProperties instanceProperties = this.entity.getProperties();
        if (instanceProperties != null) {
            bean.setDisplayName(this.repositoryHelper.removeStringProperty(this.serviceName, "displayName", instanceProperties, "getBean"));
            bean.setDescription(this.repositoryHelper.removeStringProperty(this.serviceName, "description", instanceProperties, "getBean"));
            bean.setCreationDate(this.repositoryHelper.removeDateProperty(this.serviceName, "executionDate", instanceProperties, "getBean"));
            bean.setAnalysisParameters(this.repositoryHelper.removeStringMapFromProperty(this.serviceName, "analysisParameters", instanceProperties, "getBean"));
            bean.setAnalysisStep(this.repositoryHelper.removeStringProperty(this.serviceName, "discoveryRequestStep", instanceProperties, "getBean"));
            bean.setDiscoveryRequestStatus(this.removeRequestStatusFromProperties(instanceProperties));
            bean.setAssetGUID(this.repositoryHelper.removeStringProperty(this.serviceName, "anchorGUID", instanceProperties, "getBean"));
            bean.setExtendedProperties(this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties));
        }
        return bean;
    }

    private DiscoveryRequestStatus removeRequestStatusFromProperties(InstanceProperties properties) {
        Map instancePropertiesMap;
        InstancePropertyValue instancePropertyValue;
        DiscoveryRequestStatus requestStatus = DiscoveryRequestStatus.UNKNOWN_STATUS;
        if (properties != null && (instancePropertyValue = (InstancePropertyValue)(instancePropertiesMap = properties.getInstanceProperties()).get("discoveryServiceStatus")) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    requestStatus = DiscoveryRequestStatus.WAITING;
                    break;
                }
                case 1: {
                    requestStatus = DiscoveryRequestStatus.ACTIVATING;
                    break;
                }
                case 2: {
                    requestStatus = DiscoveryRequestStatus.IN_PROGRESS;
                    break;
                }
                case 3: {
                    requestStatus = DiscoveryRequestStatus.FAILED;
                    break;
                }
                case 4: {
                    requestStatus = DiscoveryRequestStatus.COMPLETED;
                    break;
                }
                case 5: {
                    requestStatus = DiscoveryRequestStatus.OTHER;
                    break;
                }
                default: {
                    requestStatus = DiscoveryRequestStatus.UNKNOWN_STATUS;
                }
            }
            instancePropertiesMap.remove("discoveryServiceStatus");
            properties.setInstanceProperties(instancePropertiesMap);
        }
        return requestStatus;
    }
}

