/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.client;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationReport;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationReportProperties;
import org.odpi.openmetadata.frameworkservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.frameworkservices.oif.client.rest.OpenIntegrationRESTClient;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationReportResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationReportsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.MetadataSourceRequestBody;

public class OpenIntegrationServiceBase
extends OpenIntegrationClient {
    private final OpenIntegrationRESTClient restClient;
    private final ConnectedAssetClientBase connectedAssetClientBase;
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final NullRequestBody nullRequestBody = new NullRequestBody();

    public OpenIntegrationServiceBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.restClient = new OpenIntegrationRESTClient(serverName, serverPlatformURLRoot);
        this.connectedAssetClientBase = new ConnectedAssetClientBase(serverName, serverPlatformURLRoot, serviceURLMarker);
    }

    public OpenIntegrationServiceBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, String serverUserId, String serverPassword, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.restClient = new OpenIntegrationRESTClient(serverName, serverPlatformURLRoot, serverUserId, serverPassword);
        this.connectedAssetClientBase = new ConnectedAssetClientBase(serverName, serverPlatformURLRoot, serviceURLMarker, serverUserId, serverPassword);
    }

    public OpenIntegrationServiceBase(String serviceURLMarker, String serverName, String serverPlatformURLRoot, OpenIntegrationRESTClient restClient, int maxPageSize) throws InvalidParameterException {
        super(serviceURLMarker, serverName, serverPlatformURLRoot);
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.restClient = restClient;
        this.connectedAssetClientBase = new ConnectedAssetClientBase(serverName, serverPlatformURLRoot, serviceURLMarker);
    }

    public String getMetadataSourceGUID(String userId, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getMetadataSourceGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "getMetadataSourceGUID");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "getMetadataSourceGUID");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-integration/users/{2}/metadata-sources/by-name";
        NameRequestBody requestBody = new NameRequestBody();
        requestBody.setName(qualifiedName);
        requestBody.setNamePropertyName("qualifiedName");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("getMetadataSourceGUID", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public String createMetadataSource(String userId, String softwareCapabilityTypeName, String classificationName, String qualifiedName, String deployedImplementationType) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createMetadataSource";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createMetadataSource");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createMetadataSource");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-integration/users/{2}/metadata-sources/new";
        MetadataSourceRequestBody requestBody = new MetadataSourceRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setTypeName(softwareCapabilityTypeName);
        requestBody.setClassificationName(classificationName);
        requestBody.setDeployedImplementationType(deployedImplementationType);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createMetadataSource", urlTemplate, requestBody, new Object[]{this.serverName, this.serviceURLMarker, userId});
        return restResult.getGUID();
    }

    public void addCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCatalogTarget";
        String propertiesParameterName = "properties";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/catalog-targets/{4}";
        this.invalidParameterHandler.validateUserId(userId, "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "addCatalogTarget");
        this.restClient.callVoidPostRESTCall("addCatalogTarget", urlTemplate, properties, new Object[]{this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID});
    }

    public CatalogTarget getCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTarget";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/catalog-targets/{4}";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTarget");
        CatalogTargetResponse restResult = this.restClient.callCatalogTargetGetRESTCall("getCatalogTarget", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID);
        return restResult.getElement();
    }

    public List<CatalogTarget> getCatalogTargets(String userId, String integrationConnectorGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTargets";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-integration/users/{2}/integration-connectors/{2}/catalog-targets?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTargets");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTargets");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getCatalogTargets");
        CatalogTargetsResponse restResult = this.restClient.callCatalogTargetsGetRESTCall("getCatalogTargets", urlTemplate, this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID, startingFrom, maximumResults);
        return restResult.getElements();
    }

    public void removeCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeCatalogTarget";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/governance-configuration-service/users/{2}/integration-connectors/{3}/catalog-targets/{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "removeCatalogTarget");
        this.restClient.callVoidPostRESTCall("removeCatalogTarget", urlTemplate, this.nullRequestBody, new Object[]{this.serverName, this.serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID});
    }

    public void publishIntegrationReport(String userId, String elementGUID, IntegrationReportProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishIntegrationReport";
        String guidParameterName = "elementGUID";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "publishIntegrationReport");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "publishIntegrationReport");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "publishIntegrationReport");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-integration/users/{2}/elements/{3}/integration-reports";
        this.restClient.callVoidPostRESTCall("publishIntegrationReport", urlTemplate, properties, new Object[]{this.serverName, userId, elementGUID});
    }

    public IntegrationReport getIntegrationReport(String userId, String reportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationReport";
        String guidParameterName = "reportGUID";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationReport");
        this.invalidParameterHandler.validateGUID(reportGUID, "reportGUID", "getIntegrationReport");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-integration/users/{2}/integration-reports/{3}";
        IntegrationReportResponse restResult = this.restClient.callIntegrationReportGetRESTCall("getIntegrationReport", urlTemplate, this.serverName, this.serviceURLMarker, userId, reportGUID);
        return restResult.getElement();
    }

    public List<IntegrationReport> getIntegrationReportsForElement(String userId, String elementGUID, Date afterCompletionDate, Date beforeStartDate, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationReportsForElement";
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationReportsForElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getIntegrationReportsForElement");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-integration/users/{2}/integration-reports/for-element/{3}?afterCompletionDate={4}&beforeStartDate={5}&startingFrom={6}&maximumResults={7}";
        IntegrationReportsResponse restResult = this.restClient.callIntegrationReportsGetRESTCall("getIntegrationReportsForElement", urlTemplate, this.serverName, this.serviceURLMarker, userId, elementGUID, afterCompletionDate, beforeStartDate, startingFrom, maximumResults);
        return restResult.getElements();
    }

    public List<IntegrationReport> getIntegrationReports(String userId, Date afterCompletionDate, Date beforeStartDate, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationReports";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationReports");
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/framework-services/{1}/open-integration/users/{2}/integration-reports?afterCompletionDate={3}&beforeStartDate={4}&startingFrom={5}&maximumResults={6}";
        IntegrationReportsResponse restResult = this.restClient.callIntegrationReportsGetRESTCall("getIntegrationReports", urlTemplate, this.serverName, this.serviceURLMarker, userId, afterCompletionDate, beforeStartDate, startingFrom, maximumResults);
        return restResult.getElements();
    }

    public String saveConnection(String userId, Connection connection) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectionCheckedException, ConnectorCheckedException {
        return this.connectedAssetClientBase.saveConnection(userId, connection);
    }

    public String saveConnection(String userId, String assetGUID, Connection connection) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectionCheckedException, ConnectorCheckedException {
        return this.connectedAssetClientBase.saveConnection(userId, assetGUID, connection);
    }

    public AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.connectedAssetClientBase.getAssetProperties(this.serviceURLMarker, userId, assetGUID);
    }

    public Connector getConnectorToAsset(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectionCheckedException, ConnectorCheckedException {
        return this.connectedAssetClientBase.getConnectorForAsset(userId, assetGUID);
    }
}

