/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.server;

import java.util.Date;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationReportProperties;
import org.odpi.openmetadata.frameworkservices.oif.handlers.OpenIntegrationHandler;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationReportResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationReportsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.frameworkservices.oif.server.OpenIntegrationInstanceHandler;
import org.slf4j.LoggerFactory;

public class OpenIntegrationRESTServices {
    private static final OpenIntegrationInstanceHandler instanceHandler = new OpenIntegrationInstanceHandler();
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(OpenIntegrationRESTServices.class), instanceHandler.getServiceName());

    public GUIDResponse getMetadataSourceGUID(String serverName, String userId, NameRequestBody requestBody) {
        String methodName = "getMetadataSourceGUID";
        String parameterName = "qualifiedName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getMetadataSourceGUID");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getMetadataSourceGUID");
            if (requestBody != null) {
                SoftwareCapabilityHandler<Object> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "getMetadataSourceGUID");
                response.setGUID(handler.getBeanGUIDByQualifiedName(userId, "54055c38-b9ad-4a66-a75b-14dc643d4c69", "SoftwareCapability", requestBody.getName(), "qualifiedName", false, false, new Date(), "getMetadataSourceGUID"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "getMetadataSourceGUID", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getMetadataSourceGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createMetadataSource(String serverName, String userId, MetadataSourceRequestBody requestBody) {
        String methodName = "createMetadataSource";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createMetadataSource");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createMetadataSource");
            if (requestBody != null) {
                SoftwareCapabilityHandler<Object> handler = instanceHandler.getMetadataSourceHandler(userId, serverName, "createMetadataSource");
                response.setGUID(handler.createSoftwareCapability(userId, null, null, requestBody.getTypeName(), requestBody.getClassificationName(), requestBody.getQualifiedName(), null, null, null, null, null, null, null, null, null, null, null, false, false, new Date(), "createMetadataSource"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createMetadataSource", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createMetadataSource", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CatalogTargetsResponse getCatalogTargets(String serverName, String userId, String integrationConnectorGUID, int startingFrom, int maximumResults) {
        String methodName = "getCatalogTargets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCatalogTargets");
        CatalogTargetsResponse response = new CatalogTargetsResponse();
        AuditLog auditLog = null;
        try {
            OpenIntegrationHandler handler = instanceHandler.getOpenIntegrationHandler(userId, serverName, "getCatalogTargets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCatalogTargets");
            response.setElements(handler.getCatalogTargets(userId, integrationConnectorGUID, startingFrom, maximumResults));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCatalogTargets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse publishIntegrationReport(String serverName, String userId, String anchorGUID, IntegrationReportProperties properties) {
        String methodName = "publishIntegrationReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "publishIntegrationReport");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            OpenIntegrationHandler handler = instanceHandler.getOpenIntegrationHandler(userId, serverName, "publishIntegrationReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "publishIntegrationReport");
            handler.publishIntegrationReport(userId, anchorGUID, properties);
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "publishIntegrationReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationReportResponse getIntegrationReport(String serverName, String userId, String reportGUID) {
        String methodName = "getIntegrationReport";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationReport");
        IntegrationReportResponse response = new IntegrationReportResponse();
        AuditLog auditLog = null;
        try {
            OpenIntegrationHandler handler = instanceHandler.getOpenIntegrationHandler(userId, serverName, "getIntegrationReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationReport");
            response.setElement(handler.getIntegrationReport(userId, reportGUID));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationReport", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationReportsResponse getIntegrationReportsForElement(String serverName, String userId, String elementGUID, Date afterCompletionDate, Date beforeStartDate, int startingFrom, int maximumResults) {
        String methodName = "getIntegrationReportsForElement";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationReportsForElement");
        IntegrationReportsResponse response = new IntegrationReportsResponse();
        AuditLog auditLog = null;
        try {
            OpenIntegrationHandler handler = instanceHandler.getOpenIntegrationHandler(userId, serverName, "getIntegrationReportsForElement");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationReportsForElement");
            response.setElements(handler.getIntegrationReportsForElement(userId, elementGUID, afterCompletionDate, beforeStartDate, startingFrom, maximumResults));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationReportsForElement", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationReportsResponse getIntegrationReports(String serverName, String userId, Date afterCompletionDate, Date beforeStartDate, int startingFrom, int maximumResults) {
        String methodName = "getIntegrationReports";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationReports");
        IntegrationReportsResponse response = new IntegrationReportsResponse();
        AuditLog auditLog = null;
        try {
            OpenIntegrationHandler handler = instanceHandler.getOpenIntegrationHandler(userId, serverName, "getIntegrationReports");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationReports");
            response.setElements(handler.getIntegrationReports(userId, afterCompletionDate, beforeStartDate, startingFrom, maximumResults));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationReports", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

