/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationReport;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationReportProperties;
import org.odpi.openmetadata.frameworkservices.oif.builder.IntegrationReportBuilder;
import org.odpi.openmetadata.frameworkservices.oif.converters.CatalogTargetConverter;
import org.odpi.openmetadata.frameworkservices.oif.converters.IntegrationReportConverter;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class OpenIntegrationHandler {
    private final ReferenceableHandler<IntegrationReport> integrationReportHandler;
    private final SoftwareCapabilityHandler<CatalogTarget> integrationGroupHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final CatalogTargetConverter<CatalogTarget> catalogTargetConverter;

    public OpenIntegrationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.catalogTargetConverter = new CatalogTargetConverter(repositoryHelper, serviceName, serverName);
        this.integrationGroupHandler = new SoftwareCapabilityHandler(this.catalogTargetConverter, CatalogTarget.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.integrationReportHandler = new ReferenceableHandler(new IntegrationReportConverter(repositoryHelper, serviceName, serverName), IntegrationReport.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<CatalogTarget> getCatalogTargets(String userId, String integrationConnectorGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTargets";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTargets");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTargets");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getCatalogTargets");
        List relationships = this.integrationGroupHandler.getAttachmentLinks(userId, integrationConnectorGUID, "integrationConnectorGUID", "IntegrationConnector", "bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", null, "OpenMetadataRoot", 2, false, false, startingFrom, maximumResults, new Date(), "getCatalogTargets");
        if (relationships != null) {
            ArrayList<CatalogTarget> results = new ArrayList<CatalogTarget>();
            for (Relationship relationship : relationships) {
                results.add(this.catalogTargetConverter.getNewBean(CatalogTarget.class, relationship, "getCatalogTargets"));
            }
            return results;
        }
        return null;
    }

    public void publishIntegrationReport(String userId, String anchorGUID, IntegrationReportProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishIntegrationReport";
        String guidParameterName = "anchorGUID";
        String reportGUIDParameterName = "reportGUID";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "publishIntegrationReport");
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", "publishIntegrationReport");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "publishIntegrationReport");
        IntegrationReportBuilder builder = new IntegrationReportBuilder(properties.getServerName(), properties.getConnectorId(), properties.getConnectorName(), properties.getRefreshStartDate(), properties.getRefreshCompletionDate(), properties.getCreatedElements(), properties.getUpdatedElements(), properties.getDeletedElements(), properties.getAdditionalProperties(), "b8703d3f-8668-4e6a-bf26-27db1607220d", "IntegrationReport", this.integrationReportHandler.getRepositoryHelper(), this.integrationGroupHandler.getServiceName(), this.integrationGroupHandler.getServerName());
        builder.setAnchors(userId, anchorGUID, "publishIntegrationReport");
        String reportGUID = this.integrationReportHandler.createBeanInRepository(userId, null, null, "b8703d3f-8668-4e6a-bf26-27db1607220d", "IntegrationReport", (OpenMetadataAPIGenericBuilder)builder, new Date(), "publishIntegrationReport");
        if (reportGUID != null) {
            this.integrationReportHandler.linkElementToElement(userId, null, null, anchorGUID, "anchorGUID", "OpenMetadataRoot", reportGUID, "reportGUID", "IntegrationReport", true, true, this.integrationReportHandler.getSupportedZones(), "83d12156-f8f3-4b4b-b31b-18c140df9aa3", "RelatedIntegrationReport", null, null, null, null, "publishIntegrationReport");
        }
    }

    public IntegrationReport getIntegrationReport(String userId, String reportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationReport";
        String guidParameterName = "reportGUID";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationReport");
        this.invalidParameterHandler.validateGUID(reportGUID, "reportGUID", "getIntegrationReport");
        return (IntegrationReport)this.integrationReportHandler.getBeanFromRepository(userId, reportGUID, "reportGUID", "IntegrationReport", true, true, this.integrationReportHandler.getSupportedZones(), null, "getIntegrationReport");
    }

    public List<IntegrationReport> getIntegrationReportsForElement(String userId, String elementGUID, Date afterCompletionDate, Date beforeStartDate, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationReportsForElement";
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationReportsForElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getIntegrationReportsForElement");
        int pageSize = this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getIntegrationReportsForElement");
        List integrationReports = this.integrationReportHandler.getAttachedElements(userId, null, null, elementGUID, "elementGUID", "OpenMetadataRoot", "83d12156-f8f3-4b4b-b31b-18c140df9aa3", "RelatedIntegrationReport", "IntegrationReport", null, null, 2, true, true, this.integrationGroupHandler.getSupportedZones(), startingFrom, 0, null, "getIntegrationReportsForElement");
        return this.filterIntegrationReports(integrationReports, afterCompletionDate, beforeStartDate, startingFrom, pageSize);
    }

    public List<IntegrationReport> getIntegrationReports(String userId, Date afterCompletionDate, Date beforeStartDate, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationReports";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationReports");
        int pageSize = this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getIntegrationReports");
        List integrationReports = this.integrationReportHandler.getBeansByType(userId, "b8703d3f-8668-4e6a-bf26-27db1607220d", "IntegrationReport", "connectorId", false, false, this.integrationReportHandler.getSupportedZones(), startingFrom, 0, null, "getIntegrationReports");
        return this.filterIntegrationReports(integrationReports, afterCompletionDate, beforeStartDate, startingFrom, pageSize);
    }

    private List<IntegrationReport> filterIntegrationReports(List<IntegrationReport> retrievedIntegrationReports, Date afterCompletionDate, Date beforeStartDate, int startingFrom, int maximumResults) {
        if (afterCompletionDate == null && beforeStartDate == null) {
            return retrievedIntegrationReports;
        }
        ArrayList<IntegrationReport> results = new ArrayList<IntegrationReport>();
        for (IntegrationReport report : retrievedIntegrationReports) {
            results.add(report);
        }
        return results;
    }
}

