/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class IntegrationConnectorConverter<B>
extends OCFConverter<B> {
    public IntegrationConnectorConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof IntegrationConnectorElement) {
                IntegrationConnectorElement bean = (IntegrationConnectorElement)returnBean;
                IntegrationConnectorProperties properties = new IntegrationConnectorProperties();
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    properties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    properties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    properties.setDisplayName(this.removeName(instanceProperties));
                    properties.setVersionIdentifier(this.removeVersionIdentifier(instanceProperties));
                    properties.setDescription(this.removeDescription(instanceProperties));
                    properties.setUsesBlockingCalls(this.removeUsesBlockingCalls(instanceProperties));
                    if (supplementaryEntities != null) {
                        for (EntityDetail entity : supplementaryEntities) {
                            if (entity == null || entity.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, entity.getType().getTypeDefName(), "Connection")) continue;
                            properties.setConnection(super.getEmbeddedConnection(beanClass, entity, supplementaryEntities, relationships, methodName));
                        }
                    }
                    bean.setProperties(properties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            } else {
                this.handleUnexpectedBeanClass(beanClass.getName(), IntegrationConnectorProperties.class.getName(), methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

