/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OCFConverter;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationReport;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationReportProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class IntegrationReportConverter<B>
extends OCFConverter<B> {
    public IntegrationReportConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof IntegrationReport) {
                IntegrationReport bean = (IntegrationReport)returnBean;
                IntegrationReportProperties reportProperties = new IntegrationReportProperties();
                if (entity != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    reportProperties.setConnectorId(this.repositoryHelper.getStringProperty(this.serviceName, "connectorId", instanceProperties, methodName));
                    reportProperties.setConnectorName(this.repositoryHelper.getStringProperty(this.serviceName, "connectorName", instanceProperties, methodName));
                    reportProperties.setServerName(this.repositoryHelper.getStringProperty(this.serviceName, "serverName", instanceProperties, methodName));
                    reportProperties.setRefreshStartDate(this.repositoryHelper.getDateProperty(this.serviceName, "refreshStartDate", instanceProperties, methodName));
                    reportProperties.setRefreshCompletionDate(this.repositoryHelper.getDateProperty(this.serviceName, "refreshCompletionDate", instanceProperties, methodName));
                    reportProperties.setCreatedElements(this.repositoryHelper.getStringArrayProperty(this.serviceName, "createdElements", instanceProperties, methodName));
                    reportProperties.setUpdatedElements(this.repositoryHelper.getStringArrayProperty(this.serviceName, "updatedElements", instanceProperties, methodName));
                    reportProperties.setDeletedElements(this.repositoryHelper.getStringArrayProperty(this.serviceName, "deletedElements", instanceProperties, methodName));
                    reportProperties.setAdditionalProperties(this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, instanceProperties, methodName));
                    bean.setProperties(reportProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, primaryEntity, methodName);
    }
}

