/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SoftwareCapabilityHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationGroupElement;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.frameworks.integration.properties.RegisteredIntegrationConnectorElement;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.oif.converters.CatalogTargetConverter;
import org.odpi.openmetadata.frameworkservices.oif.converters.IntegrationConnectorConverter;
import org.odpi.openmetadata.frameworkservices.oif.converters.IntegrationGroupConverter;
import org.odpi.openmetadata.frameworkservices.oif.converters.RegisteredIntegrationConnectorConverter;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class IntegrationGroupConfigurationHandler {
    private final String serviceName;
    private final String serverName;
    private final RepositoryHandler repositoryHandler;
    private final OMRSRepositoryHelper repositoryHelper;
    private final SoftwareCapabilityHandler<IntegrationGroupElement> integrationGroupHandler;
    private final AssetHandler<IntegrationConnectorElement> integrationConnectorHandler;
    private final ConnectionHandler<Connection> connectionHandler;
    private final InvalidParameterHandler invalidParameterHandler;
    private final RegisteredIntegrationConnectorConverter registeredIntegrationConnectorConverter;
    private final CatalogTargetConverter<CatalogTarget> catalogTargetConverter;

    public IntegrationGroupConfigurationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.registeredIntegrationConnectorConverter = new RegisteredIntegrationConnectorConverter(repositoryHelper, serviceName);
        this.catalogTargetConverter = new CatalogTargetConverter(repositoryHelper, serviceName, serverName);
        this.integrationGroupHandler = new SoftwareCapabilityHandler(new IntegrationGroupConverter(repositoryHelper, serviceName, serverName), IntegrationGroupElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.integrationConnectorHandler = new AssetHandler(new IntegrationConnectorConverter(repositoryHelper, serviceName, serverName), IntegrationConnectorElement.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.connectionHandler = new ConnectionHandler((OpenMetadataAPIGenericConverter)new ConnectionConverter(repositoryHelper, serviceName, serverName), Connection.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createIntegrationGroup(String userId, IntegrationGroupProperties properties, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIntegrationGroup";
        return this.integrationGroupHandler.createSoftwareCapability(userId, null, null, OpenMetadataType.INTEGRATION_GROUP.typeName, null, properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), DeployedImplementationType.INTEGRATION_GROUP.getDeployedImplementationType(), properties.getVersion(), properties.getPatchLevel(), properties.getSource(), properties.getAdditionalProperties(), null, null, null, null, false, false, new Date(), "createIntegrationGroup");
    }

    public IntegrationGroupElement getIntegrationGroupByGUID(String userId, String guid, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupByGUID";
        String guidParameter = "guid";
        return (IntegrationGroupElement)this.integrationGroupHandler.getBeanFromRepository(userId, guid, "guid", OpenMetadataType.INTEGRATION_GROUP.typeName, false, false, serviceSupportedZones, new Date(), "getIntegrationGroupByGUID");
    }

    public IntegrationGroupElement getIntegrationGroupByName(String userId, String name, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationGroupByName";
        String nameParameter = "name";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        return (IntegrationGroupElement)this.integrationGroupHandler.getBeanByValue(userId, name, "name", OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, specificMatchPropertyNames, false, false, serviceSupportedZones, null, "getIntegrationGroupByName");
    }

    public List<IntegrationGroupElement> getAllIntegrationGroups(String userId, int startingFrom, int maximumResults, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationGroups";
        return this.integrationGroupHandler.getBeansByType(userId, OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, null, false, false, serviceSupportedZones, startingFrom, maximumResults, new Date(), "getAllIntegrationGroups");
    }

    public void updateIntegrationGroup(String userId, String guid, boolean isMergeUpdate, IntegrationGroupProperties properties, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateIntegrationGroup";
        String guidParameter = "guid";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateIntegrationGroup");
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "qualifiedName", "updateIntegrationGroup");
        }
        SoftwareCapabilityBuilder builder = new SoftwareCapabilityBuilder(properties.getQualifiedName(), properties.getDisplayName(), properties.getDescription(), DeployedImplementationType.INTEGRATION_GROUP.getDeployedImplementationType(), properties.getVersion(), properties.getPatchLevel(), properties.getSource(), properties.getAdditionalProperties(), OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, null, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties instanceProperties = builder.getInstanceProperties("updateIntegrationGroup");
        this.integrationGroupHandler.updateBeanInRepository(userId, null, null, guid, "guid", OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, false, false, serviceSupportedZones, instanceProperties, isMergeUpdate, new Date(), "updateIntegrationGroup");
    }

    public void deleteIntegrationGroup(String userId, String guid, String qualifiedName, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteIntegrationGroup";
        String guidParameter = "integrationGroupGUID";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "deleteIntegrationGroup");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteIntegrationGroup");
        this.integrationGroupHandler.deleteBeanInRepository(userId, null, null, guid, "integrationGroupGUID", OpenMetadataType.INTEGRATION_GROUP.typeGUID, OpenMetadataType.INTEGRATION_GROUP.typeName, "qualifiedName", qualifiedName, false, false, serviceSupportedZones, new Date(), "deleteIntegrationGroup");
    }

    public String createIntegrationConnector(String userId, String qualifiedName, String versionIdentifier, String displayName, String description, boolean usesBlockingCalls, Map<String, String> additionalProperties, Connection connection, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createIntegrationConnector";
        String connectionParameterName = "createIntegrationConnector";
        String assetGUIDParameterName = "assetGUID";
        this.invalidParameterHandler.validateConnection(connection, "createIntegrationConnector", "createIntegrationConnector");
        Date effectiveTime = new Date();
        HashMap<String, Boolean> extendedProperties = new HashMap<String, Boolean>();
        extendedProperties.put("usesBlockingCalls", usesBlockingCalls);
        String assetGUID = this.integrationConnectorHandler.createAssetInRepository(userId, null, null, qualifiedName, displayName, versionIdentifier, description, additionalProperties, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, extendedProperties, InstanceStatus.ACTIVE, null, null, effectiveTime, "createIntegrationConnector");
        if (assetGUID != null) {
            this.connectionHandler.saveConnection(userId, null, null, assetGUID, assetGUID, "assetGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, qualifiedName, connection, "Connection to create integration connector", false, false, serviceSupportedZones, effectiveTime, "createIntegrationConnector");
        }
        return assetGUID;
    }

    public IntegrationConnectorElement getIntegrationConnectorByGUID(String userId, String guid, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorByGUID";
        String guidParameter = "guid";
        return (IntegrationConnectorElement)this.integrationConnectorHandler.getAssetWithConnection(userId, guid, "guid", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, false, false, serviceSupportedZones, new Date(), "getIntegrationConnectorByGUID");
    }

    public IntegrationConnectorElement getIntegrationConnectorByName(String userId, String name, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationConnectorByName";
        String nameParameter = "name";
        return (IntegrationConnectorElement)this.integrationConnectorHandler.getAssetByNameWithConnection(userId, name, "name", OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, false, false, serviceSupportedZones, new Date(), "getIntegrationConnectorByName");
    }

    public List<IntegrationConnectorElement> getAllIntegrationConnectors(String userId, int startingFrom, int maximumResults, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationConnectors";
        return this.integrationConnectorHandler.getAllAssetsWithConnection(userId, OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, startingFrom, maximumResults, false, false, serviceSupportedZones, new Date(), "getAllIntegrationConnectors");
    }

    public List<String> getIntegrationConnectorRegistrations(String userId, String integrationConnectorGUID, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllIntegrationConnectors";
        String guidParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAllIntegrationConnectors");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getAllIntegrationConnectors");
        Date effectiveTime = new Date();
        this.connectionHandler.getEntityFromRepository(userId, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, null, null, false, false, serviceSupportedZones, effectiveTime, "getAllIntegrationConnectors");
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, integrationConnectorGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", 1, false, false, 0, 0, effectiveTime, "getAllIntegrationConnectors");
        ArrayList<String> results = new ArrayList<String>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getEntityOneProxy().getGUID() == null) continue;
                results.add(relationship.getEntityOneProxy().getGUID());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void updateIntegrationConnector(String userId, String guid, boolean isMergeUpdate, String qualifiedName, String versionIdentifier, String displayName, String description, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateIntegrationConnector";
        String guidParameter = "guid";
        this.integrationConnectorHandler.updateAssetWithConnection(userId, null, null, guid, "guid", qualifiedName, displayName, versionIdentifier, description, additionalProperties, OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, extendedProperties, null, null, isMergeUpdate, null, connection, false, false, serviceSupportedZones, new Date(), "updateIntegrationConnector");
    }

    public void deleteIntegrationConnector(String userId, String guid, String qualifiedName, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteIntegrationConnector";
        String qualifiedNameParameter = "qualifiedName";
        String guidParameter = "integrationConnectorGUID";
        this.connectionHandler.deleteBeanInRepository(userId, null, null, guid, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, "qualifiedName", qualifiedName, false, false, serviceSupportedZones, new Date(), "deleteIntegrationConnector");
    }

    public void registerIntegrationConnectorWithGroup(String userId, String integrationGroupGUID, String integrationConnectorGUID, String connectorName, String connectorUserId, String metadataSourceQualifiedName, Date startDate, long refreshTimeInterval, Date stopDate, PermittedSynchronization permittedSynchronization, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerIntegrationConnectorWithGroup";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String governanceRequestTypeParameter = "connectorName";
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "registerIntegrationConnectorWithGroup");
        this.invalidParameterHandler.validateName(connectorName, "connectorName", "registerIntegrationConnectorWithGroup");
        InstanceProperties instanceProperties = new InstanceProperties();
        this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "connectorName", connectorName, "registerIntegrationConnectorWithGroup");
        instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "connectorUserId", connectorUserId, "registerIntegrationConnectorWithGroup");
        instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "metadataSourceQualifiedName", metadataSourceQualifiedName, "registerIntegrationConnectorWithGroup");
        instanceProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.START_DATE.name, startDate, "registerIntegrationConnectorWithGroup");
        instanceProperties = this.repositoryHelper.addLongPropertyToInstance(this.serviceName, instanceProperties, "refreshTimeInterval", refreshTimeInterval, "registerIntegrationConnectorWithGroup");
        instanceProperties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, instanceProperties, "stopDate", stopDate, "registerIntegrationConnectorWithGroup");
        if (permittedSynchronization != null) {
            try {
                instanceProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, "973a9f4c-93fa-43a5-a0c5-d97dbd164e78", "PermittedSynchronization", permittedSynchronization.getOpenTypeOrdinal(), "registerIntegrationConnectorWithGroup");
            }
            catch (TypeErrorException error) {
                throw new InvalidParameterException((OCFCheckedExceptionBase)error, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name);
            }
        }
        this.integrationGroupHandler.linkElementToElement(userId, null, null, integrationGroupGUID, "integrationGroupGUID", OpenMetadataType.INTEGRATION_GROUP.typeName, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, false, false, serviceSupportedZones, "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", instanceProperties, null, null, new Date(), "registerIntegrationConnectorWithGroup");
    }

    public RegisteredIntegrationConnectorElement getRegisteredIntegrationConnector(String userId, String integrationGroupGUID, String integrationConnectorGUID, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredIntegrationConnector";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredIntegrationConnector");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "getRegisteredIntegrationConnector");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getRegisteredIntegrationConnector");
        List relationships = this.repositoryHandler.getRelationshipsBetweenEntities(userId, integrationConnectorGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, integrationGroupGUID, "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", 1, false, false, null, "getRegisteredIntegrationConnector");
        if (relationships != null && !relationships.isEmpty()) {
            return this.registeredIntegrationConnectorConverter.getBean(this.getIntegrationConnectorByGUID(userId, integrationConnectorGUID, serviceSupportedZones), (Relationship)relationships.get(0));
        }
        return null;
    }

    public List<RegisteredIntegrationConnectorElement> getRegisteredIntegrationConnectors(String userId, String integrationGroupGUID, int startingFrom, int maximumResults, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredIntegrationConnectors";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        List relationships = this.integrationGroupHandler.getAttachmentLinks(userId, integrationGroupGUID, "integrationGroupGUID", OpenMetadataType.INTEGRATION_GROUP.typeName, "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", null, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, 2, false, false, startingFrom, maximumResults, new Date(), "getRegisteredIntegrationConnectors");
        if (relationships != null) {
            ArrayList<RegisteredIntegrationConnectorElement> results = new ArrayList<RegisteredIntegrationConnectorElement>();
            for (Relationship relationship : relationships) {
                IntegrationConnectorElement connectorElement = this.getIntegrationConnectorByGUID(userId, relationship.getEntityTwoProxy().getGUID(), serviceSupportedZones);
                results.add(this.registeredIntegrationConnectorConverter.getBean(connectorElement, relationship));
            }
            return results;
        }
        return null;
    }

    public void unregisterIntegrationConnectorFromGroup(String userId, String integrationGroupGUID, String integrationConnectorGUID, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterIntegrationConnectorFromGroup";
        String integrationGroupGUIDParameter = "integrationGroupGUID";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "unregisterIntegrationConnectorFromGroup");
        this.invalidParameterHandler.validateGUID(integrationGroupGUID, "integrationGroupGUID", "unregisterIntegrationConnectorFromGroup");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "unregisterIntegrationConnectorFromGroup");
        this.integrationGroupHandler.unlinkElementFromElement(userId, false, null, null, integrationGroupGUID, "integrationGroupGUID", OpenMetadataType.INTEGRATION_GROUP.typeName, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeGUID, OpenMetadataType.INTEGRATION_CONNECTOR.typeName, false, false, serviceSupportedZones, "7528bcd4-ae4c-47d0-a33f-4aeebbaa92c2", "RegisteredIntegrationConnector", new Date(), "unregisterIntegrationConnectorFromGroup");
    }

    public void addCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties properties, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addCatalogTarget";
        String propertiesParameterName = "properties";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "addCatalogTarget");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "addCatalogTarget");
        InstanceProperties instanceProperties = new InstanceProperties();
        instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, "catalogTargetName", properties.getCatalogTargetName(), "addCatalogTarget");
        instanceProperties = this.repositoryHelper.addMapPropertyToInstance(this.serviceName, instanceProperties, "configurationProperties", properties.getConfigurationProperties(), "addCatalogTarget");
        this.integrationGroupHandler.linkElementToElement(userId, null, null, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, serviceSupportedZones, "bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", instanceProperties, null, null, new Date(), "addCatalogTarget");
    }

    public CatalogTarget getCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTarget";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTarget");
        Relationship relationship = this.integrationGroupHandler.getUniqueAttachmentLink(userId, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, "bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", metadataElementGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, 2, false, false, serviceSupportedZones, null, "getCatalogTarget");
        if (relationship != null) {
            return this.catalogTargetConverter.getNewBean(CatalogTarget.class, relationship, "getCatalogTarget");
        }
        return null;
    }

    public List<CatalogTarget> getCatalogTargets(String userId, String integrationConnectorGUID, int startingFrom, int maximumResults, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getCatalogTargets";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCatalogTargets");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "getCatalogTargets");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getCatalogTargets");
        List relationships = this.integrationGroupHandler.getAttachmentLinks(userId, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, "bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", null, OpenMetadataType.OPEN_METADATA_ROOT.typeName, 2, false, false, serviceSupportedZones, startingFrom, maximumResults, new Date(), "getCatalogTargets");
        if (relationships != null) {
            ArrayList<CatalogTarget> results = new ArrayList<CatalogTarget>();
            for (Relationship relationship : relationships) {
                results.add(this.catalogTargetConverter.getNewBean(CatalogTarget.class, relationship, "getCatalogTargets"));
            }
            return results;
        }
        return null;
    }

    public void removeCatalogTarget(String userId, String integrationConnectorGUID, String metadataElementGUID, List<String> serviceSupportedZones) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeCatalogTarget";
        String integrationConnectorGUIDParameter = "integrationConnectorGUID";
        String metadataElementGUIDParameter = "metadataElementGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(integrationConnectorGUID, "integrationConnectorGUID", "removeCatalogTarget");
        this.invalidParameterHandler.validateGUID(metadataElementGUID, "metadataElementGUID", "removeCatalogTarget");
        this.integrationGroupHandler.unlinkElementFromElement(userId, false, null, null, integrationConnectorGUID, "integrationConnectorGUID", OpenMetadataType.INTEGRATION_CONNECTOR.typeName, metadataElementGUID, "metadataElementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, false, false, serviceSupportedZones, "bc5a5eb1-881b-4055-aa2c-78f314282ac2", "CatalogTarget", new Date(), "removeCatalogTarget");
    }
}

