/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.frameworks.integration.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.frameworkservices.oif.handlers.IntegrationGroupConfigurationHandler;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationConnectorElementResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationConnectorElementsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationGroupElementResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationGroupElementsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.RegisteredIntegrationConnectorResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.RegisteredIntegrationConnectorsResponse;
import org.odpi.openmetadata.frameworkservices.oif.server.OpenIntegrationInstanceHandler;
import org.slf4j.LoggerFactory;

public class IntegrationConfigRESTServices {
    private static final OpenIntegrationInstanceHandler instanceHandler = new OpenIntegrationInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(IntegrationConfigRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createIntegrationGroup(String serverName, String serviceURLMarker, String userId, IntegrationGroupProperties requestBody) {
        String methodName = "createIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createIntegrationGroup");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "createIntegrationGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createIntegrationGroup");
            if (requestBody != null) {
                response.setGUID(handler.createIntegrationGroup(userId, requestBody, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createIntegrationGroup")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createIntegrationGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createIntegrationGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupElementResponse getIntegrationGroupByGUID(String serverName, String serviceURLMarker, String userId, String guid) {
        String methodName = "getIntegrationGroupByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupByGUID");
        IntegrationGroupElementResponse response = new IntegrationGroupElementResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getIntegrationGroupByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationGroupByGUID");
            response.setElement(handler.getIntegrationGroupByGUID(userId, guid, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getIntegrationGroupByGUID")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationGroupByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupElementResponse getIntegrationGroupByName(String serverName, String serviceURLMarker, String userId, String name) {
        String methodName = "getIntegrationGroupByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationGroupByName");
        IntegrationGroupElementResponse response = new IntegrationGroupElementResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getIntegrationGroupByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationGroupByName");
            response.setElement(handler.getIntegrationGroupByName(userId, name, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getIntegrationGroupByName")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationGroupByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationGroupElementsResponse getAllIntegrationGroups(String serverName, String serviceURLMarker, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllIntegrationGroups";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllIntegrationGroups");
        IntegrationGroupElementsResponse response = new IntegrationGroupElementsResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getAllIntegrationGroups");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllIntegrationGroups");
            response.setElements(handler.getAllIntegrationGroups(userId, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAllIntegrationGroups")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllIntegrationGroups", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateIntegrationGroup(String serverName, String serviceURLMarker, String userId, String guid, boolean isMergeUpdate, IntegrationGroupProperties requestBody) {
        String methodName = "updateIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateIntegrationGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "updateIntegrationGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateIntegrationGroup");
            if (requestBody != null) {
                handler.updateIntegrationGroup(userId, guid, isMergeUpdate, requestBody, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateIntegrationGroup"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateIntegrationGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateIntegrationGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteIntegrationGroup(String serverName, String serviceURLMarker, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteIntegrationGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteIntegrationGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "deleteIntegrationGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteIntegrationGroup");
            if (requestBody != null) {
                handler.deleteIntegrationGroup(userId, guid, requestBody.getQualifiedName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteIntegrationGroup"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteIntegrationGroup", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteIntegrationGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDResponse createIntegrationConnector(String serverName, String serviceURLMarker, String userId, IntegrationConnectorProperties requestBody) {
        String methodName = "createIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createIntegrationConnector");
        GUIDResponse response = new GUIDResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "createIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createIntegrationConnector");
            if (requestBody != null) {
                response.setGUID(handler.createIntegrationConnector(userId, requestBody.getQualifiedName(), requestBody.getVersionIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getUsesBlockingCalls(), requestBody.getAdditionalProperties(), requestBody.getConnection(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "createIntegrationConnector")));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "createIntegrationConnector", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "createIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationConnectorElementResponse getIntegrationConnectorByGUID(String serverName, String serviceURLMarker, String userId, String guid) {
        String methodName = "getIntegrationConnectorByGUID";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationConnectorByGUID");
        IntegrationConnectorElementResponse response = new IntegrationConnectorElementResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getIntegrationConnectorByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationConnectorByGUID");
            response.setElement(handler.getIntegrationConnectorByGUID(userId, guid, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getIntegrationConnectorByGUID")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationConnectorByGUID", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationConnectorElementResponse getIntegrationConnectorByName(String serverName, String serviceURLMarker, String userId, String name) {
        String methodName = "getIntegrationConnectorByName";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationConnectorByName");
        IntegrationConnectorElementResponse response = new IntegrationConnectorElementResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getIntegrationConnectorByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationConnectorByName");
            response.setElement(handler.getIntegrationConnectorByName(userId, name, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getIntegrationConnectorByName")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationConnectorByName", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public IntegrationConnectorElementsResponse getAllIntegrationConnectors(String serverName, String serviceURLMarker, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllIntegrationConnectors";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getAllIntegrationConnectors");
        IntegrationConnectorElementsResponse response = new IntegrationConnectorElementsResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getAllIntegrationConnectors");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllIntegrationConnectors");
            response.setElements(handler.getAllIntegrationConnectors(userId, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getAllIntegrationConnectors")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getAllIntegrationConnectors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public GUIDListResponse getIntegrationConnectorRegistrations(String serverName, String serviceURLMarker, String userId, String integrationConnectorGUID) {
        String methodName = "getIntegrationConnectorRegistrations";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getIntegrationConnectorRegistrations");
        GUIDListResponse response = new GUIDListResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getIntegrationConnectorRegistrations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getIntegrationConnectorRegistrations");
            response.setGUIDs(handler.getIntegrationConnectorRegistrations(userId, integrationConnectorGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getIntegrationConnectorRegistrations")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getIntegrationConnectorRegistrations", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse updateIntegrationConnector(String serverName, String serviceURLMarker, String userId, String guid, boolean isMergeUpdate, IntegrationConnectorProperties requestBody) {
        String methodName = "updateIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "updateIntegrationConnector");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "updateIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateIntegrationConnector");
            if (requestBody != null) {
                handler.updateIntegrationConnector(userId, guid, isMergeUpdate, requestBody.getQualifiedName(), requestBody.getVersionIdentifier(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getConnection(), requestBody.getAdditionalProperties(), null, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "updateIntegrationConnector"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateIntegrationConnector", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "updateIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse deleteIntegrationConnector(String serverName, String serviceURLMarker, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "deleteIntegrationConnector");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "deleteIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteIntegrationConnector");
            if (requestBody != null) {
                handler.deleteIntegrationConnector(userId, guid, requestBody.getQualifiedName(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "deleteIntegrationConnector"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "deleteIntegrationConnector", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "deleteIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse registerIntegrationConnectorWithGroup(String serverName, String serviceURLMarker, String userId, String integrationGroupGUID, String integrationConnectorGUID, RegisteredIntegrationConnectorProperties requestBody) {
        String methodName = "registerIntegrationConnectorWithEngine";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "registerIntegrationConnectorWithEngine");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "registerIntegrationConnectorWithEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "registerIntegrationConnectorWithEngine");
            if (requestBody != null) {
                handler.registerIntegrationConnectorWithGroup(userId, integrationGroupGUID, integrationConnectorGUID, requestBody.getConnectorName(), requestBody.getConnectorUserId(), requestBody.getMetadataSourceQualifiedName(), requestBody.getStartDate(), requestBody.getRefreshTimeInterval(), requestBody.getStopDate(), requestBody.getPermittedSynchronization(), instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "registerIntegrationConnectorWithEngine"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "registerIntegrationConnectorWithEngine", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "registerIntegrationConnectorWithEngine", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredIntegrationConnectorResponse getRegisteredIntegrationConnector(String serverName, String serviceURLMarker, String userId, String integrationGroupGUID, String integrationConnectorGUID) {
        String methodName = "getRegisteredIntegrationConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredIntegrationConnector");
        RegisteredIntegrationConnectorResponse response = new RegisteredIntegrationConnectorResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getRegisteredIntegrationConnector");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredIntegrationConnector");
            response.setRegisteredIntegrationConnector(handler.getRegisteredIntegrationConnector(userId, integrationGroupGUID, integrationConnectorGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRegisteredIntegrationConnector")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredIntegrationConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public RegisteredIntegrationConnectorsResponse getRegisteredIntegrationConnectors(String serverName, String serviceURLMarker, String userId, String integrationGroupGUID, int startingFrom, int maximumResults) {
        String methodName = "getRegisteredIntegrationConnectors";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getRegisteredIntegrationConnectors");
        RegisteredIntegrationConnectorsResponse response = new RegisteredIntegrationConnectorsResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getRegisteredIntegrationConnectors");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredIntegrationConnectors");
            response.setElements(handler.getRegisteredIntegrationConnectors(userId, integrationGroupGUID, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getRegisteredIntegrationConnectors")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getRegisteredIntegrationConnectors", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse unregisterIntegrationConnectorFromGroup(String serverName, String serviceURLMarker, String userId, String integrationGroupGUID, String integrationConnectorGUID, NullRequestBody requestBody) {
        String methodName = "unregisterIntegrationConnectorFromGroup";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "unregisterIntegrationConnectorFromGroup");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "unregisterIntegrationConnectorFromGroup");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterIntegrationConnectorFromGroup");
            handler.unregisterIntegrationConnectorFromGroup(userId, integrationGroupGUID, integrationConnectorGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "unregisterIntegrationConnectorFromGroup"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "unregisterIntegrationConnectorFromGroup", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse addCatalogTarget(String serverName, String serviceURLMarker, String userId, String integrationConnectorGUID, String metadataElementGUID, CatalogTargetProperties requestBody) {
        String methodName = "addCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "addCatalogTarget");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "addCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addCatalogTarget");
            if (requestBody != null) {
                handler.addCatalogTarget(userId, integrationConnectorGUID, metadataElementGUID, requestBody, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "addCatalogTarget"));
            } else {
                this.restExceptionHandler.handleNoRequestBody(userId, "addCatalogTarget", serverName);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "addCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CatalogTargetResponse getCatalogTarget(String serverName, String serviceURLMarker, String userId, String integrationConnectorGUID, String metadataElementGUID) {
        String methodName = "getCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCatalogTarget");
        CatalogTargetResponse response = new CatalogTargetResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCatalogTarget");
            response.setElement(handler.getCatalogTarget(userId, integrationConnectorGUID, metadataElementGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getCatalogTarget")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public CatalogTargetsResponse getCatalogTargets(String serverName, String serviceURLMarker, String userId, String integrationConnectorGUID, int startingFrom, int maximumResults) {
        String methodName = "getCatalogTargets";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getCatalogTargets");
        CatalogTargetsResponse response = new CatalogTargetsResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "getCatalogTargets");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getCatalogTargets");
            response.setElements(handler.getCatalogTargets(userId, integrationConnectorGUID, startingFrom, maximumResults, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "getCatalogTargets")));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "getCatalogTargets", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public VoidResponse removeCatalogTarget(String serverName, String serviceURLMarker, String userId, String integrationConnectorGUID, String metadataElementGUID, NullRequestBody requestBody) {
        String methodName = "removeCatalogTarget";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "removeCatalogTarget");
        VoidResponse response = new VoidResponse();
        AuditLog auditLog = null;
        try {
            IntegrationGroupConfigurationHandler handler = instanceHandler.getIntegrationGroupConfigurationHandler(userId, serverName, "removeCatalogTarget");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "removeCatalogTarget");
            handler.removeCatalogTarget(userId, integrationConnectorGUID, metadataElementGUID, instanceHandler.getSupportedZones(userId, serverName, serviceURLMarker, "removeCatalogTarget"));
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "removeCatalogTarget", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

