/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.handlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationReport;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationReportProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworkservices.oif.builder.IntegrationReportBuilder;
import org.odpi.openmetadata.frameworkservices.oif.converters.IntegrationReportConverter;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class OpenIntegrationHandler {
    private final ReferenceableHandler<IntegrationReport> integrationReportHandler;
    private final InvalidParameterHandler invalidParameterHandler;

    public OpenIntegrationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.invalidParameterHandler = invalidParameterHandler;
        this.integrationReportHandler = new ReferenceableHandler(new IntegrationReportConverter(repositoryHelper, serviceName, serverName), IntegrationReport.class, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public void publishIntegrationReport(String userId, String elementGUID, List<String> serviceSupportedZones, IntegrationReportProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "publishIntegrationReport";
        String guidParameterName = "elementGUID";
        String reportGUIDParameterName = "reportGUID";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "publishIntegrationReport");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "publishIntegrationReport");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "publishIntegrationReport");
        EntityDetail entity = this.integrationReportHandler.getEntityFromRepository(userId, elementGUID, null, OpenMetadataType.OPEN_METADATA_ROOT.typeName, null, null, false, false, serviceSupportedZones, new Date(), "publishIntegrationReport");
        if (entity != null) {
            IntegrationReportBuilder builder = new IntegrationReportBuilder(properties.getServerName(), properties.getConnectorId(), properties.getConnectorName(), properties.getRefreshStartDate(), properties.getRefreshCompletionDate(), properties.getCreatedElements(), properties.getUpdatedElements(), properties.getDeletedElements(), properties.getAdditionalProperties(), "b8703d3f-8668-4e6a-bf26-27db1607220d", "IntegrationReport", this.integrationReportHandler.getRepositoryHelper(), this.integrationReportHandler.getServiceName(), this.integrationReportHandler.getServerName());
            builder.setAnchors(userId, entity.getGUID(), entity.getType().getTypeDefName(), this.integrationReportHandler.getDomainName((EntitySummary)entity), "publishIntegrationReport");
            String reportGUID = this.integrationReportHandler.createBeanInRepository(userId, null, null, "b8703d3f-8668-4e6a-bf26-27db1607220d", "IntegrationReport", (OpenMetadataAPIGenericBuilder)builder, new Date(), "publishIntegrationReport");
            if (reportGUID != null) {
                this.integrationReportHandler.linkElementToElement(userId, null, null, entity.getGUID(), "elementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, reportGUID, "reportGUID", "IntegrationReport", true, true, this.integrationReportHandler.getSupportedZones(), "83d12156-f8f3-4b4b-b31b-18c140df9aa3", "RelatedIntegrationReport", null, null, null, null, "publishIntegrationReport");
            }
        }
    }

    public IntegrationReport getIntegrationReport(String userId, String reportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationReport";
        String guidParameterName = "reportGUID";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationReport");
        this.invalidParameterHandler.validateGUID(reportGUID, "reportGUID", "getIntegrationReport");
        return (IntegrationReport)this.integrationReportHandler.getBeanFromRepository(userId, reportGUID, "reportGUID", "IntegrationReport", true, true, this.integrationReportHandler.getSupportedZones(), null, "getIntegrationReport");
    }

    public List<IntegrationReport> getIntegrationReportsForElement(String userId, String elementGUID, Date afterCompletionDate, Date beforeStartDate, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationReportsForElement";
        String guidParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationReportsForElement");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getIntegrationReportsForElement");
        int pageSize = this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getIntegrationReportsForElement");
        List integrationReports = this.integrationReportHandler.getAttachedElements(userId, null, null, elementGUID, "elementGUID", OpenMetadataType.OPEN_METADATA_ROOT.typeName, "83d12156-f8f3-4b4b-b31b-18c140df9aa3", "RelatedIntegrationReport", "IntegrationReport", null, null, 2, true, true, this.integrationReportHandler.getSupportedZones(), startingFrom, 0, null, "getIntegrationReportsForElement");
        return this.filterIntegrationReports(integrationReports, afterCompletionDate, beforeStartDate, startingFrom, pageSize);
    }

    public List<IntegrationReport> getIntegrationReports(String userId, Date afterCompletionDate, Date beforeStartDate, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getIntegrationReports";
        this.invalidParameterHandler.validateUserId(userId, "getIntegrationReports");
        int pageSize = this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getIntegrationReports");
        List integrationReports = this.integrationReportHandler.getBeansByType(userId, "b8703d3f-8668-4e6a-bf26-27db1607220d", "IntegrationReport", "connectorId", false, false, this.integrationReportHandler.getSupportedZones(), startingFrom, 0, null, "getIntegrationReports");
        return this.filterIntegrationReports(integrationReports, afterCompletionDate, beforeStartDate, startingFrom, pageSize);
    }

    private List<IntegrationReport> filterIntegrationReports(List<IntegrationReport> retrievedIntegrationReports, Date afterCompletionDate, Date beforeStartDate, int startingFrom, int maximumResults) {
        if (afterCompletionDate == null && beforeStartDate == null) {
            return retrievedIntegrationReports;
        }
        ArrayList<IntegrationReport> results = new ArrayList<IntegrationReport>();
        for (IntegrationReport report : retrievedIntegrationReports) {
            results.add(report);
        }
        return results;
    }
}

