/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.builder;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class IntegrationReportBuilder
extends OpenMetadataAPIGenericBuilder {
    private final String daemonName;
    private final String connectorId;
    private final String connectorName;
    private final Date refreshStartDate;
    private final Date refreshCompletionDate;
    private final List<String> createdElements;
    private final List<String> updatedElements;
    private final List<String> deletedElements;
    private final Map<String, String> additionalProperties;

    public IntegrationReportBuilder(String daemonName, String connectorId, String connectorName, Date refreshStartDate, Date refreshCompletionDate, List<String> createdElements, List<String> updatedElements, List<String> deletedElements, Map<String, String> additionalProperties, String typeGUID, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeGUID, typeName, repositoryHelper, serviceName, serverName);
        this.daemonName = daemonName;
        this.connectorId = connectorId;
        this.connectorName = connectorName;
        this.refreshStartDate = refreshStartDate;
        this.refreshCompletionDate = refreshCompletionDate;
        this.createdElements = createdElements;
        this.updatedElements = updatedElements;
        this.deletedElements = deletedElements;
        this.additionalProperties = additionalProperties;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "serverName", this.daemonName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "connectorId", this.connectorId, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "connectorName", this.connectorName, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "refreshStartDate", this.refreshStartDate, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, "refreshCompletionDate", this.refreshCompletionDate, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "createdElements", this.createdElements, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "updatedElements", this.updatedElements, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, "deletedElements", this.deletedElements, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, this.additionalProperties, methodName);
        return properties;
    }
}

