/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.admin;

import org.odpi.openmetadata.commonservices.multitenant.ffdc.exceptions.NewInstanceException;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworkservices.oif.ffdc.OpenIntegrationAuditCode;
import org.odpi.openmetadata.frameworkservices.oif.server.OpenIntegrationInstance;
import org.odpi.openmetadata.frameworkservices.oif.server.OpenIntegrationInstanceHandler;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class OIFMetadataOperationalServices {
    private final String serverName;
    private final AuditLog auditLog;

    public OIFMetadataOperationalServices(String serverName, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String localServerUserId, int maxPageSize) throws NewInstanceException {
        this.serverName = serverName;
        this.auditLog = auditLog;
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", OpenIntegrationAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        try {
            auditLog.logMessage("initialize", OpenIntegrationAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{serverName}));
            new OpenIntegrationInstance(repositoryConnector, auditLog, localServerUserId, maxPageSize);
        }
        catch (NewInstanceException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", OpenIntegrationAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        this.auditLog.logMessage("shutdown", OpenIntegrationAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
        new OpenIntegrationInstanceHandler().removeServerServiceInstance(this.serverName);
    }
}

