/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationReportProperties;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationReportResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationReportsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.frameworkservices.oif.server.OpenIntegrationRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/open-integration/users/{userId}"})
@Tag(name="Open Integration Service", description="Provides support for integration connectors.", externalDocs=@ExternalDocumentation(description="Open Integration Service", url="https://egeria-project.org/services/oif-metadata-management/"))
public class OpenIntegrationResource {
    private final OpenIntegrationRESTServices restAPI = new OpenIntegrationRESTServices();

    @PostMapping(path={"metadata-sources/by-name"})
    public GUIDResponse getMetadataSourceGUID(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMetadataSourceGUID(serverName, userId, requestBody);
    }

    @PostMapping(path={"/metadata-sources/new"})
    public GUIDResponse createMetadataSource(@PathVariable String serverName, @PathVariable String userId, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.createMetadataSource(serverName, userId, requestBody);
    }

    @GetMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets"})
    public CatalogTargetsResponse getCatalogTargets(@PathVariable String serverName, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getCatalogTargets(serverName, userId, integrationConnectorGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/integration-reports/{anchorGUID}/new"})
    public VoidResponse publishIntegrationReport(@PathVariable String serverName, @PathVariable String userId, @PathVariable String anchorGUID, @RequestBody IntegrationReportProperties properties) {
        return this.restAPI.publishIntegrationReport(serverName, userId, anchorGUID, properties);
    }

    @GetMapping(path={"/integration-reports/{reportGUID}"})
    public IntegrationReportResponse getIntegrationReport(@PathVariable String serverName, @PathVariable String userId, @PathVariable String reportGUID) {
        return this.restAPI.getIntegrationReport(serverName, userId, reportGUID);
    }

    @GetMapping(path={"/integration-reports/for-element/{elementGUID}"})
    public IntegrationReportsResponse getIntegrationReportsForElement(@PathVariable String serverName, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false) Date afterCompletionDate, @RequestParam(required=false) Date beforeStartDate, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getIntegrationReportsForElement(serverName, userId, elementGUID, afterCompletionDate, beforeStartDate, startingFrom, maximumResults);
    }

    @GetMapping(path={"/integration-reports"})
    public IntegrationReportsResponse getIntegrationReports(@PathVariable String serverName, @PathVariable String userId, @RequestParam(required=false) Date afterCompletionDate, @RequestParam(required=false) Date beforeStartDate, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getIntegrationReports(serverName, userId, afterCompletionDate, beforeStartDate, startingFrom, maximumResults);
    }
}

