/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationConnectorProperties;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationGroupProperties;
import org.odpi.openmetadata.frameworks.integration.properties.RegisteredIntegrationConnectorProperties;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationConnectorElementResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationConnectorElementsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationGroupElementResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationGroupElementsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.RegisteredIntegrationConnectorResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.RegisteredIntegrationConnectorsResponse;
import org.odpi.openmetadata.frameworkservices.oif.server.IntegrationConfigRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/governance-configuration-service/users/{userId}"})
@Tag(name="Framework Services: Integration Group Configuration", description="The Integration Group Configuration Service provides support for defining integration groups in open metadata.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
public class IntegrationGroupConfigurationResource {
    private final IntegrationConfigRESTServices restAPI = new IntegrationConfigRESTServices();

    @PostMapping(path={"/integration-groups/new"})
    @Operation(summary="createIntegrationGroup", description="Create a new integration group definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public GUIDResponse createIntegrationGroup(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody IntegrationGroupProperties requestBody) {
        return this.restAPI.createIntegrationGroup(serverName, serviceURLMarker, userId, requestBody);
    }

    @GetMapping(path={"/integration-groups/{guid}"})
    @Operation(summary="getIntegrationGroupByGUID", description="Return the properties from an integration group definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public IntegrationGroupElementResponse getIntegrationGroupByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIntegrationGroupByGUID(serverName, serviceURLMarker, userId, guid);
    }

    @GetMapping(path={"/integration-groups/by-name/{name}"})
    @Operation(summary="getIntegrationGroupByName", description="Return the properties from an integration group definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public IntegrationGroupElementResponse getIntegrationGroupByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getIntegrationGroupByName(serverName, serviceURLMarker, userId, name);
    }

    @GetMapping(path={"/integration-groups"})
    @Operation(summary="getAllIntegrationGroups", description="Return the list of integration group definitions that are stored.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public IntegrationGroupElementsResponse getAllIntegrationGroups(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllIntegrationGroups(serverName, serviceURLMarker, userId, startingFrom, maximumResults);
    }

    @PostMapping(path={"/integration-groups/{guid}/update"})
    @Operation(summary="updateIntegrationGroup", description="Update the properties of an existing integration group definition.  Use the current value to keep a property value the same, or use the new value.  Null means remove the property from the definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse updateIntegrationGroup(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestParam boolean isMergeUpdate, @RequestBody IntegrationGroupProperties requestBody) {
        return this.restAPI.updateIntegrationGroup(serverName, serviceURLMarker, userId, guid, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/integration-groups/{guid}/delete"})
    @Operation(summary="deleteIntegrationGroup", description="Remove the properties of the integration group.  Both the guid and the qualified name is supplied to validate that the correct integration group is being deleted.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse deleteIntegrationGroup(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteIntegrationGroup(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/integration-connectors/new"})
    @Operation(summary="createIntegrationConnector", description="Create an integration connector definition.  The same integration connector can be associated with multiple integration groups.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public GUIDResponse createIntegrationConnector(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody IntegrationConnectorProperties requestBody) {
        return this.restAPI.createIntegrationConnector(serverName, serviceURLMarker, userId, requestBody);
    }

    @GetMapping(path={"/integration-connectors/{guid}"})
    @Operation(summary="getIntegrationConnectorByGUID", description="Return the properties from an integration connector definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public IntegrationConnectorElementResponse getIntegrationConnectorByGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIntegrationConnectorByGUID(serverName, serviceURLMarker, userId, guid);
    }

    @GetMapping(path={"/integration-connectors/by-name/{name}"})
    @Operation(summary="getIntegrationConnectorByName", description="Return the properties from an integration connector definition.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public IntegrationConnectorElementResponse getIntegrationConnectorByName(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String name) {
        return this.restAPI.getIntegrationConnectorByName(serverName, serviceURLMarker, userId, name);
    }

    @GetMapping(path={"/integration-connectors"})
    @Operation(summary="getAllIntegrationConnectors", description="Return the list of integration connectors definitions that are stored.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public IntegrationConnectorElementsResponse getAllIntegrationConnectors(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getAllIntegrationConnectors(serverName, serviceURLMarker, userId, startingFrom, maximumResults);
    }

    @GetMapping(path={"/integration-connectors/{guid}/registrations"})
    @Operation(summary="getIntegrationConnectorRegistrations", description="Return the list of integration groups that a specific integration connector is registered with.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public GUIDListResponse getIntegrationConnectorRegistrations(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid) {
        return this.restAPI.getIntegrationConnectorRegistrations(serverName, serviceURLMarker, userId, guid);
    }

    @PostMapping(path={"/integration-connectors/{guid}/update"})
    @Operation(summary="updateIntegrationConnector", description="Update the properties of an existing integration connector definition. The isMergeUpdate request parameter is used to indicate whether supplied null values mean keep existing value (true) or remove existing value (false).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse updateIntegrationConnector(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestParam boolean isMergeUpdate, @RequestBody IntegrationConnectorProperties requestBody) {
        return this.restAPI.updateIntegrationConnector(serverName, serviceURLMarker, userId, guid, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/integration-connectors/{guid}/delete"})
    @Operation(summary="deleteIntegrationConnector", description="Remove the properties of the integration connector.  Both the guid and the qualified name is supplied to validate that the correct integration connector is being deleted.  The integration connector is also unregistered from its integration groups.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse deleteIntegrationConnector(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String guid, @RequestBody DeleteRequestBody requestBody) {
        return this.restAPI.deleteIntegrationConnector(serverName, serviceURLMarker, userId, guid, requestBody);
    }

    @PostMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors/{integrationConnectorGUID}"})
    @Operation(summary="registerIntegrationConnectorWithGroup", description="Register an integration connector with a specific integration group.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse registerIntegrationConnectorWithGroup(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationGroupGUID, @PathVariable String integrationConnectorGUID, @RequestBody RegisteredIntegrationConnectorProperties requestBody) {
        return this.restAPI.registerIntegrationConnectorWithGroup(serverName, serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID, requestBody);
    }

    @GetMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors/{integrationConnectorGUID}"})
    @Operation(summary="getRegisteredIntegrationConnector", description="Retrieve a specific integration connector registered with an integration group.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public RegisteredIntegrationConnectorResponse getRegisteredIntegrationConnector(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationGroupGUID, @PathVariable String integrationConnectorGUID) {
        return this.restAPI.getRegisteredIntegrationConnector(serverName, serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID);
    }

    @GetMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors"})
    @Operation(summary="getRegisteredIntegrationConnectors", description="Retrieve the details of the integration connectors registered with an integration group.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public RegisteredIntegrationConnectorsResponse getRegisteredIntegrationConnectors(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationGroupGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getRegisteredIntegrationConnectors(serverName, serviceURLMarker, userId, integrationGroupGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/integration-groups/{integrationGroupGUID}/integration-connectors/{integrationConnectorGUID}/delete"})
    @Operation(summary="unregisterIntegrationConnectorFromGroup", description="Unregister an integration connector from the integration group.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-group/"))
    public VoidResponse unregisterIntegrationConnectorFromGroup(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationGroupGUID, @PathVariable String integrationConnectorGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unregisterIntegrationConnectorFromGroup(serverName, serviceURLMarker, userId, integrationGroupGUID, integrationConnectorGUID, requestBody);
    }

    @PostMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets/{metadataElementGUID}"})
    @Operation(summary="addCatalogTarget", description="Add a catalog target to an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse addCatalogTarget(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @PathVariable String metadataElementGUID, @RequestBody CatalogTargetProperties requestBody) {
        return this.restAPI.addCatalogTarget(serverName, serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID, requestBody);
    }

    @GetMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets/{metadataElementGUID}"})
    @Operation(summary="getCatalogTarget", description="Retrieve a specific catalog target associated with an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public CatalogTargetResponse getCatalogTarget(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @PathVariable String metadataElementGUID) {
        return this.restAPI.getCatalogTarget(serverName, serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID);
    }

    @GetMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets"})
    @Operation(summary="getCatalogTargets", description="Retrieve the details of the metadata elements identified as catalog targets with an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public CatalogTargetsResponse getCatalogTargets(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getCatalogTargets(serverName, serviceURLMarker, userId, integrationConnectorGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets/{metadataElementGUID}/delete"})
    @Operation(summary="removeCatalogTarget", description="Unregister a catalog target from the integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-connector/"))
    public VoidResponse removeCatalogTarget(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @PathVariable String metadataElementGUID, @RequestBody NullRequestBody requestBody) {
        return this.restAPI.removeCatalogTarget(serverName, serviceURLMarker, userId, integrationConnectorGUID, metadataElementGUID, requestBody);
    }
}

