/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworkservices.oif.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Date;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworks.integration.properties.IntegrationReportProperties;
import org.odpi.openmetadata.frameworkservices.oif.rest.CatalogTargetsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationReportResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.IntegrationReportsResponse;
import org.odpi.openmetadata.frameworkservices.oif.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.frameworkservices.oif.server.OpenIntegrationRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/framework-services/{serviceURLMarker}/open-integration/users/{userId}"})
@Tag(name="Framework Services: Open Integration Service", description="Provides support for the context used by integration connectors.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/oif-metadata-management/"))
public class OpenIntegrationResource {
    private final OpenIntegrationRESTServices restAPI = new OpenIntegrationRESTServices();

    @PostMapping(path={"metadata-sources/by-name"})
    @Operation(summary="getMetadataSourceGUID", description="Retrieve the unique identifier of the software server capability representing a metadata source.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/metadata-collection/"))
    public GUIDResponse getMetadataSourceGUID(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getMetadataSourceGUID(serverName, serviceURLMarker, userId, requestBody);
    }

    @PostMapping(path={"/metadata-sources/new"})
    @Operation(summary="createMetadataSource", description="Create a new metadata element to represent a software capability.  This describes the metadata source.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/metadata-collection/"))
    public GUIDResponse createMetadataSource(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestBody MetadataSourceRequestBody requestBody) {
        return this.restAPI.createMetadataSource(serverName, serviceURLMarker, userId, requestBody);
    }

    @GetMapping(path={"/integration-connectors/{integrationConnectorGUID}/catalog-targets"})
    @Operation(summary="getCatalogTargets", description="Retrieve the identifiers of the metadata elements identified as catalog targets with an integration connector.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/catalog-target/"))
    public CatalogTargetsResponse getCatalogTargets(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String integrationConnectorGUID, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getCatalogTargets(serverName, serviceURLMarker, userId, integrationConnectorGUID, startingFrom, maximumResults);
    }

    @PostMapping(path={"/elements/{elementGUID}/integration-reports"})
    @Operation(summary="publishIntegrationReport", description="Create a new integration report for an element (identified by anchorGUID).", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-report/"))
    public VoidResponse publishIntegrationReport(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @RequestBody IntegrationReportProperties properties) {
        return this.restAPI.publishIntegrationReport(serverName, serviceURLMarker, userId, elementGUID, properties);
    }

    @GetMapping(path={"/integration-reports/{reportGUID}"})
    @Operation(summary="getIntegrationReportByGUID", description="Retrieve a specific integration report by unique identifier.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-report/"))
    public IntegrationReportResponse getIntegrationReport(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String reportGUID) {
        return this.restAPI.getIntegrationReport(serverName, serviceURLMarker, userId, reportGUID);
    }

    @GetMapping(path={"/integration-reports/for-element/{elementGUID}"})
    @Operation(summary="getIntegrationReportsForElement", description="Retrieve the integration reports attached to an element.  The list can be filtered by start and completion date of the report along with the paging options if there are many integration reports.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-report/"))
    public IntegrationReportsResponse getIntegrationReportsForElement(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @PathVariable String elementGUID, @RequestParam(required=false) Date afterCompletionDate, @RequestParam(required=false) Date beforeStartDate, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getIntegrationReportsForElement(serverName, serviceURLMarker, userId, elementGUID, afterCompletionDate, beforeStartDate, startingFrom, maximumResults);
    }

    @GetMapping(path={"/integration-reports"})
    @Operation(summary="getALLIntegrationReports", description="Retrieve the published integration reports.  The list can be filtered by start and completion date of the report along with the paging options if there are many integration reports.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/integration-report/"))
    public IntegrationReportsResponse getIntegrationReports(@PathVariable String serverName, @PathVariable String serviceURLMarker, @PathVariable String userId, @RequestParam(required=false) Date afterCompletionDate, @RequestParam(required=false) Date beforeStartDate, @RequestParam int startingFrom, @RequestParam int maximumResults) {
        return this.restAPI.getIntegrationReports(serverName, serviceURLMarker, userId, afterCompletionDate, beforeStartDate, startingFrom, maximumResults);
    }
}

