/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.rest.repositoryconnector;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.rest.repositoryconnector.OMRSRESTRepositoryConnector;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.clients.LocalRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class OMRSRESTMetadataCollection
extends OMRSMetadataCollection {
    private static final String defaultRepositoryName = "REST-connected Repository ";
    private String errorMessage = null;
    private LocalRepositoryServicesClient omrsClient;

    OMRSRESTMetadataCollection(OMRSRESTRepositoryConnector parentConnector, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, String metadataCollectionId) throws RepositoryErrorException {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, metadataCollectionId, repositoryHelper, repositoryValidator);
        String methodName = "OMRSMetadataCollection constructor";
        ConnectionProperties connection = parentConnector.getConnection();
        String endpointAddress = null;
        String localServerUserId = null;
        String localServerPassword = null;
        if (connection != null) {
            localServerUserId = connection.getUserId();
            localServerPassword = connection.getClearPassword();
            EndpointProperties endpoint = connection.getEndpoint();
            if (endpoint != null) {
                endpointAddress = endpoint.getAddress();
            }
        }
        if (endpointAddress == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.REPOSITORY_URL_NULL;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[0]);
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "OMRSMetadataCollection constructor", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.repositoryName = defaultRepositoryName + endpointAddress;
        try {
            this.omrsClient = new LocalRepositoryServicesClient(repositoryName, endpointAddress, localServerUserId, localServerPassword);
        }
        catch (Throwable error) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_REST_CLIENT;
            this.errorMessage = error.getMessage();
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{repositoryName, this.errorMessage});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "OMRSMetadataCollection constructor", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    private void validateClient(String methodName) throws RepositoryErrorException {
        if (this.omrsClient == null) {
            OMRSErrorCode errorCode = OMRSErrorCode.NO_REST_CLIENT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.repositoryName, this.errorMessage});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private void validateMetadataCollectionId(String remoteMetadataCollectionId, String methodName) throws RepositoryErrorException {
        if (remoteMetadataCollectionId != null) {
            if (!remoteMetadataCollectionId.equals(this.metadataCollectionId)) {
                OMRSErrorCode errorCode = OMRSErrorCode.METADATA_COLLECTION_ID_MISMATCH;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.repositoryName, remoteMetadataCollectionId, this.metadataCollectionId});
                throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
        } else {
            OMRSErrorCode errorCode = OMRSErrorCode.NULL_METADATA_COLLECTION_ID;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.repositoryName, this.metadataCollectionId});
            throw new RepositoryErrorException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    public String getMetadataCollectionId() throws RepositoryErrorException {
        String methodName = "getMetadataCollectionId";
        this.validateClient("getMetadataCollectionId");
        String remoteMetadataCollectionId = this.omrsClient.getMetadataCollectionId();
        this.validateMetadataCollectionId(remoteMetadataCollectionId, "getMetadataCollectionId");
        return remoteMetadataCollectionId;
    }

    public String getMetadataCollectionId(String userId) throws RepositoryErrorException {
        String methodName = "getMetadataCollectionId";
        this.validateClient("getMetadataCollectionId");
        String remoteMetadataCollectionId = this.omrsClient.getMetadataCollectionId(userId);
        this.validateMetadataCollectionId(remoteMetadataCollectionId, "getMetadataCollectionId");
        return remoteMetadataCollectionId;
    }

    public TypeDefGallery getAllTypes(String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        this.validateClient("getAllTypes");
        return this.omrsClient.getAllTypes(userId);
    }

    public TypeDefGallery findTypesByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByName";
        this.validateClient("findTypesByName");
        return this.omrsClient.findTypesByName(userId, name);
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        this.validateClient("findTypeDefsByCategory");
        return this.omrsClient.findTypeDefsByCategory(userId, category);
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        this.validateClient("findAttributeTypeDefsByCategory");
        return this.omrsClient.findAttributeTypeDefsByCategory(userId, category);
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        this.validateClient("findTypeDefsByProperty");
        return this.omrsClient.findTypeDefsByProperty(userId, matchCriteria);
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByExternalID";
        this.validateClient("findTypesByExternalID");
        return this.omrsClient.findTypesByExternalID(userId, standard, organization, identifier);
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        this.validateClient("searchForTypeDefs");
        return this.omrsClient.searchForTypeDefs(userId, searchCriteria);
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        this.validateClient("getTypeDefByGUID");
        return this.omrsClient.getTypeDefByGUID(userId, guid);
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        this.validateClient("getAttributeTypeDefByGUID");
        return this.omrsClient.getAttributeTypeDefByGUID(userId, guid);
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        this.validateClient("getTypeDefByName");
        return this.omrsClient.getTypeDefByName(userId, name);
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        this.validateClient("getAttributeTypeDefByName");
        return this.omrsClient.getAttributeTypeDefByName(userId, name);
    }

    public void addTypeDefGallery(String userId, TypeDefGallery newTypes) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDefGallery";
        this.validateClient("addTypeDefGallery");
        this.omrsClient.addTypeDefGallery(userId, newTypes);
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDef";
        this.validateClient("addTypeDef");
        this.omrsClient.addTypeDef(userId, newTypeDef);
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addAttributeTypeDef";
        this.validateClient("addAttributeTypeDef");
        this.omrsClient.addAttributeTypeDef(userId, newAttributeTypeDef);
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        this.validateClient("verifyTypeDef");
        return this.omrsClient.verifyTypeDef(userId, typeDef);
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyAttributeTypeDef";
        this.validateClient("verifyAttributeTypeDef");
        return this.omrsClient.verifyAttributeTypeDef(userId, attributeTypeDef);
    }

    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateTypeDef";
        this.validateClient("updateTypeDef");
        return this.omrsClient.updateTypeDef(userId, typeDefPatch);
    }

    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteTypeDef";
        this.validateClient("deleteTypeDef");
        this.omrsClient.deleteTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
    }

    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteAttributeTypeDef";
        this.validateClient("deleteAttributeTypeDef");
        this.omrsClient.deleteAttributeTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
    }

    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyTypeDef";
        this.validateClient("reIdentifyTypeDef");
        return this.omrsClient.reIdentifyTypeDef(userId, originalTypeDefGUID, originalTypeDefName, newTypeDefGUID, newTypeDefName);
    }

    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyAttributeTypeDef";
        this.validateClient("reIdentifyAttributeTypeDef");
        return this.omrsClient.reIdentifyAttributeTypeDef(userId, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDefGUID, newAttributeTypeDefName);
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        this.validateClient("isEntityKnown");
        return this.omrsClient.isEntityKnown(userId, guid);
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        this.validateClient("getEntitySummary");
        return this.omrsClient.getEntitySummary(userId, guid);
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        this.validateClient("getEntityDetail");
        return this.omrsClient.getEntityDetail(userId, guid);
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        this.validateClient("getEntityDetail");
        return this.omrsClient.getEntityDetail(userId, guid, asOfTime);
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        this.validateClient("getRelationshipsForEntity");
        return this.omrsClient.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByProperty";
        this.validateClient("findEntitiesByProperty");
        return this.omrsClient.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByClassification";
        this.validateClient("findEntitiesByClassification");
        return this.omrsClient.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        this.validateClient("findEntitiesByPropertyValue");
        return this.omrsClient.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        this.validateClient("isRelationshipKnown");
        return this.omrsClient.isRelationshipKnown(userId, guid);
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        this.validateClient("getRelationship");
        return this.omrsClient.getRelationship(userId, guid);
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        this.validateClient("getRelationship");
        return this.omrsClient.getRelationship(userId, guid, asOfTime);
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByProperty";
        this.validateClient("findRelationshipsByProperty");
        return this.omrsClient.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyValue";
        this.validateClient("findRelationshipsByPropertyValue");
        return this.omrsClient.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getLinkingEntities";
        this.validateClient("getLinkingEntities");
        return this.omrsClient.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        this.validateClient("getEntityNeighborhood");
        return this.omrsClient.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelatedEntities";
        this.validateClient("getRelatedEntities");
        return this.omrsClient.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntity";
        this.validateClient("addEntity");
        return this.omrsClient.addEntity(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus);
    }

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        this.validateClient("addExternalEntity");
        return this.omrsClient.addExternalEntity(userId, entityTypeGUID, externalSourceGUID, externalSourceName, initialProperties, initialClassifications, initialStatus);
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntityProxy";
        this.validateClient("addEntityProxy");
        this.omrsClient.addEntityProxy(userId, entityProxy);
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityStatus";
        this.validateClient("updateEntityStatus");
        return this.omrsClient.updateEntityStatus(userId, entityGUID, newStatus);
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityProperties";
        this.validateClient("updateEntityProperties");
        return this.omrsClient.updateEntityProperties(userId, entityGUID, properties);
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoEntityUpdate";
        this.validateClient("undoEntityUpdate");
        return this.omrsClient.undoEntityUpdate(userId, entityGUID);
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntity";
        this.validateClient("deleteEntity");
        return this.omrsClient.deleteEntity(userId, typeDefGUID, typeDefName, obsoleteEntityGUID);
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntity";
        this.validateClient("purgeEntity");
        this.omrsClient.purgeEntity(userId, typeDefGUID, typeDefName, deletedEntityGUID);
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreEntity";
        this.validateClient("restoreEntity");
        return this.omrsClient.restoreEntity(userId, deletedEntityGUID);
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "classifyEntity";
        this.validateClient("classifyEntity");
        return this.omrsClient.classifyEntity(userId, entityGUID, classificationName, classificationProperties);
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "declassifyEntity";
        this.validateClient("declassifyEntity");
        return this.omrsClient.declassifyEntity(userId, entityGUID, classificationName);
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        this.validateClient("updateEntityClassification");
        return this.omrsClient.updateEntityClassification(userId, entityGUID, classificationName, properties);
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        this.validateClient("addRelationship");
        return this.omrsClient.addRelationship(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
    }

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addExternalRelationship";
        this.validateClient("addExternalRelationship");
        return this.omrsClient.addExternalRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipStatus";
        this.validateClient("updateRelationshipStatus");
        return this.omrsClient.updateRelationshipStatus(userId, relationshipGUID, newStatus);
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipProperties";
        this.validateClient("updateRelationshipProperties");
        return this.omrsClient.updateRelationshipProperties(userId, relationshipGUID, properties);
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoRelationshipUpdate";
        this.validateClient("undoRelationshipUpdate");
        return this.omrsClient.undoRelationshipUpdate(userId, relationshipGUID);
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationship";
        this.validateClient("deleteRelationship");
        return this.omrsClient.deleteRelationship(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID);
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        this.validateClient("purgeRelationship");
        this.omrsClient.purgeRelationship(userId, typeDefGUID, typeDefName, deletedRelationshipGUID);
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreRelationship";
        this.validateClient("restoreRelationship");
        return this.omrsClient.restoreRelationship(userId, deletedRelationshipGUID);
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyEntity";
        this.validateClient("reIdentifyEntity");
        return this.omrsClient.reIdentifyEntity(userId, typeDefGUID, typeDefName, entityGUID, newEntityGUID);
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeEntity";
        this.validateClient("reTypeEntity");
        return this.omrsClient.reTypeEntity(userId, entityGUID, currentTypeDefSummary, newTypeDefSummary);
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeEntity";
        this.validateClient("reHomeEntity");
        return this.omrsClient.reHomeEntity(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyRelationship";
        this.validateClient("reIdentifyRelationship");
        return this.omrsClient.reIdentifyRelationship(userId, typeDefGUID, typeDefName, relationshipGUID, newRelationshipGUID);
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeRelationship";
        this.validateClient("reTypeRelationship");
        return this.omrsClient.reTypeRelationship(userId, relationshipGUID, currentTypeDefSummary, newTypeDefSummary);
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeRelationship";
        this.validateClient("reHomeRelationship");
        return this.omrsClient.reHomeRelationship(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveEntityReferenceCopy";
        this.validateClient("saveEntityReferenceCopy");
        this.omrsClient.saveEntityReferenceCopy(userId, entity);
    }

    public void deleteEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntityReferenceCopy";
        this.validateClient("deleteEntityReferenceCopy");
        this.omrsClient.deleteEntityReferenceCopy(userId, entity);
    }

    public void purgeEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        this.validateClient("purgeEntityReferenceCopy");
        this.omrsClient.purgeEntityReferenceCopy(userId, entity);
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        this.validateClient("purgeEntityReferenceCopy");
        this.omrsClient.purgeEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "refreshEntityReferenceCopy";
        this.validateClient("refreshEntityReferenceCopy");
        this.omrsClient.refreshEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveRelationshipReferenceCopy";
        this.validateClient("saveRelationshipReferenceCopy");
        this.omrsClient.saveRelationshipReferenceCopy(userId, relationship);
    }

    public void deleteRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationshipReferenceCopy";
        this.validateClient("deleteRelationshipReferenceCopy");
        this.omrsClient.deleteRelationshipReferenceCopy(userId, relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        this.validateClient("purgeRelationshipReferenceCopy");
        this.omrsClient.purgeRelationshipReferenceCopy(userId, relationship);
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        this.validateClient("purgeRelationshipReferenceCopy");
        this.omrsClient.purgeRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "refreshRelationshipReferenceCopy";
        this.validateClient("refreshRelationshipReferenceCopy");
        this.omrsClient.refreshRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
    }

    public void saveInstanceReferenceCopies(String userId, InstanceGraph instances) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, EntityConflictException, RelationshipConflictException, InvalidEntityException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveInstanceReferenceCopies";
        this.validateClient("saveInstanceReferenceCopies");
        this.omrsClient.saveInstanceReferenceCopies(userId, instances);
    }
}

