/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.repositoryservices.rest.repositoryconnector;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.adapters.repositoryservices.rest.repositoryconnector.OMRSRESTRepositoryConnector;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.repositoryservices.clients.LocalRepositoryServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.HistorySequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceGraph;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchClassifications;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.search.SearchProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefGallery;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefSummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSAuditCode;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.EntityProxyOnlyException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.FunctionNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.HomeRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidEntityException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidRelationshipException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidTypeDefException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PagingErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PatchErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.PropertyErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotDeletedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RelationshipNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.StatusNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefConflictException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefInUseException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotKnownException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeDefNotSupportedException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException;

public class OMRSRESTMetadataCollection
extends OMRSMetadataCollection {
    private static final String defaultRepositoryName = "REST-connected Repository ";
    private final LocalRepositoryServicesClient omrsClient;
    private final AuditLog auditLog;
    private final List<String> unsupportedFunctionList = new ArrayList<String>();
    private String errorMessage = null;
    private String remoteMetadataCollectionId = null;

    OMRSRESTMetadataCollection(OMRSRESTRepositoryConnector parentConnector, String serverName, String repositoryName, OMRSRepositoryHelper repositoryHelper, OMRSRepositoryValidator repositoryValidator, AuditLog auditLog, String metadataCollectionId) throws RepositoryErrorException {
        super((OMRSRepositoryConnector)parentConnector, repositoryName, metadataCollectionId, repositoryHelper, repositoryValidator);
        String methodName = "OMRSMetadataCollection constructor";
        this.auditLog = auditLog;
        ConnectionProperties connection = parentConnector.getConnection();
        String endpointAddress = null;
        String localServerUserId = null;
        String localServerPassword = null;
        if (connection != null) {
            localServerUserId = connection.getUserId();
            localServerPassword = connection.getClearPassword();
            EndpointProperties endpoint = connection.getEndpoint();
            if (endpoint != null) {
                endpointAddress = endpoint.getAddress();
            }
        }
        if (endpointAddress == null) {
            throw new RepositoryErrorException(OMRSErrorCode.REPOSITORY_URL_NULL.getMessageDefinition(), ((Object)((Object)this)).getClass().getName(), "OMRSMetadataCollection constructor");
        }
        this.repositoryName = defaultRepositoryName + endpointAddress;
        try {
            this.omrsClient = new LocalRepositoryServicesClient(serverName, endpointAddress, localServerUserId, localServerPassword);
        }
        catch (Exception error) {
            this.errorMessage = error.getMessage();
            throw new RepositoryErrorException(OMRSErrorCode.NO_REST_CLIENT.getMessageDefinition(new String[]{repositoryName, this.errorMessage}), ((Object)((Object)this)).getClass().getName(), "OMRSMetadataCollection constructor", (Throwable)error);
        }
    }

    private void validateClient(String methodName) throws RepositoryErrorException {
        if (this.omrsClient == null) {
            throw new RepositoryErrorException(OMRSErrorCode.NO_REST_CLIENT.getMessageDefinition(new String[]{this.repositoryName, this.errorMessage}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
    }

    private synchronized boolean isfunctionSupported(String methodName) {
        return !this.unsupportedFunctionList.contains(methodName);
    }

    private synchronized void markFunctionUnsupported(String methodName) {
        String localMethodName = "markFunctionUnsupported";
        if (!this.unsupportedFunctionList.contains(methodName)) {
            if (this.auditLog != null) {
                this.auditLog.logMessage("markFunctionUnsupported", OMRSAuditCode.UNSUPPORTED_REMOTE_FUNCTION.getMessageDefinition(new String[]{this.repositoryName, this.metadataCollectionId, methodName}));
            }
            this.unsupportedFunctionList.add(methodName);
        }
    }

    private void validateMetadataCollectionId(String receivedMetadataCollectionId, String methodName) throws RepositoryErrorException {
        if (receivedMetadataCollectionId != null) {
            if (!receivedMetadataCollectionId.equals(this.metadataCollectionId)) {
                throw new RepositoryErrorException(OMRSErrorCode.METADATA_COLLECTION_ID_MISMATCH.getMessageDefinition(new String[]{this.repositoryName, receivedMetadataCollectionId, this.metadataCollectionId}), ((Object)((Object)this)).getClass().getName(), methodName);
            }
        } else {
            throw new RepositoryErrorException(OMRSErrorCode.NULL_METADATA_COLLECTION_ID.getMessageDefinition(new String[]{this.repositoryName, this.metadataCollectionId}), ((Object)((Object)this)).getClass().getName(), methodName);
        }
    }

    public String getMetadataCollectionId() throws RepositoryErrorException {
        if (this.remoteMetadataCollectionId == null) {
            String methodName = "getMetadataCollectionId (deprecated)";
            this.validateClient("getMetadataCollectionId (deprecated)");
            this.remoteMetadataCollectionId = this.omrsClient.getMetadataCollectionId();
            this.validateMetadataCollectionId(this.remoteMetadataCollectionId, "getMetadataCollectionId (deprecated)");
        }
        return this.remoteMetadataCollectionId;
    }

    public String getMetadataCollectionId(String userId) throws RepositoryErrorException {
        String methodName = "getMetadataCollectionId";
        if (this.remoteMetadataCollectionId == null) {
            this.validateClient("getMetadataCollectionId");
            this.remoteMetadataCollectionId = this.omrsClient.getMetadataCollectionId(userId);
            this.validateMetadataCollectionId(this.remoteMetadataCollectionId, "getMetadataCollectionId");
        }
        return this.remoteMetadataCollectionId;
    }

    public TypeDefGallery getAllTypes(String userId) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "getAllTypes";
        this.validateClient("getAllTypes");
        return this.omrsClient.getAllTypes(userId);
    }

    public TypeDefGallery findTypesByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByName";
        this.validateClient("findTypesByName");
        return this.omrsClient.findTypesByName(userId, name);
    }

    public List<TypeDef> findTypeDefsByCategory(String userId, TypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByCategory";
        this.validateClient("findTypeDefsByCategory");
        return this.omrsClient.findTypeDefsByCategory(userId, category);
    }

    public List<AttributeTypeDef> findAttributeTypeDefsByCategory(String userId, AttributeTypeDefCategory category) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findAttributeTypeDefsByCategory";
        this.validateClient("findAttributeTypeDefsByCategory");
        return this.omrsClient.findAttributeTypeDefsByCategory(userId, category);
    }

    public List<TypeDef> findTypeDefsByProperty(String userId, TypeDefProperties matchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypeDefsByProperty";
        this.validateClient("findTypeDefsByProperty");
        return this.omrsClient.findTypeDefsByProperty(userId, matchCriteria);
    }

    public List<TypeDef> findTypesByExternalID(String userId, String standard, String organization, String identifier) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "findTypesByExternalID";
        this.validateClient("findTypesByExternalID");
        return this.omrsClient.findTypesByExternalID(userId, standard, organization, identifier);
    }

    public List<TypeDef> searchForTypeDefs(String userId, String searchCriteria) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "searchForTypeDefs";
        this.validateClient("searchForTypeDefs");
        return this.omrsClient.searchForTypeDefs(userId, searchCriteria);
    }

    public TypeDef getTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByGUID";
        this.validateClient("getTypeDefByGUID");
        return this.omrsClient.getTypeDefByGUID(userId, guid);
    }

    public AttributeTypeDef getAttributeTypeDefByGUID(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByGUID";
        this.validateClient("getAttributeTypeDefByGUID");
        return this.omrsClient.getAttributeTypeDefByGUID(userId, guid);
    }

    public TypeDef getTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getTypeDefByName";
        this.validateClient("getTypeDefByName");
        return this.omrsClient.getTypeDefByName(userId, name);
    }

    public AttributeTypeDef getAttributeTypeDefByName(String userId, String name) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, UserNotAuthorizedException {
        String methodName = "getAttributeTypeDefByName";
        this.validateClient("getAttributeTypeDefByName");
        return this.omrsClient.getAttributeTypeDefByName(userId, name);
    }

    public void addTypeDefGallery(String userId, TypeDefGallery newTypes) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDefGallery";
        this.validateClient("addTypeDefGallery");
        this.omrsClient.addTypeDefGallery(userId, newTypes);
    }

    public void addTypeDef(String userId, TypeDef newTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addTypeDef";
        this.validateClient("addTypeDef");
        this.omrsClient.addTypeDef(userId, newTypeDef);
    }

    public void addAttributeTypeDef(String userId, AttributeTypeDef newAttributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefKnownException, TypeDefConflictException, InvalidTypeDefException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addAttributeTypeDef";
        this.validateClient("addAttributeTypeDef");
        this.omrsClient.addAttributeTypeDef(userId, newAttributeTypeDef);
    }

    public boolean verifyTypeDef(String userId, TypeDef typeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyTypeDef";
        this.validateClient("verifyTypeDef");
        return this.omrsClient.verifyTypeDef(userId, typeDef);
    }

    public boolean verifyAttributeTypeDef(String userId, AttributeTypeDef attributeTypeDef) throws InvalidParameterException, RepositoryErrorException, TypeDefNotSupportedException, TypeDefConflictException, InvalidTypeDefException, UserNotAuthorizedException {
        String methodName = "verifyAttributeTypeDef";
        this.validateClient("verifyAttributeTypeDef");
        return this.omrsClient.verifyAttributeTypeDef(userId, attributeTypeDef);
    }

    public TypeDef updateTypeDef(String userId, TypeDefPatch typeDefPatch) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, PatchErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateTypeDef";
        this.validateClient("updateTypeDef");
        return this.omrsClient.updateTypeDef(userId, typeDefPatch);
    }

    public void deleteTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteTypeDef";
        this.validateClient("deleteTypeDef");
        this.omrsClient.deleteTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
    }

    public void deleteAttributeTypeDef(String userId, String obsoleteTypeDefGUID, String obsoleteTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, TypeDefInUseException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteAttributeTypeDef";
        this.validateClient("deleteAttributeTypeDef");
        this.omrsClient.deleteAttributeTypeDef(userId, obsoleteTypeDefGUID, obsoleteTypeDefName);
    }

    public TypeDef reIdentifyTypeDef(String userId, String originalTypeDefGUID, String originalTypeDefName, String newTypeDefGUID, String newTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyTypeDef";
        this.validateClient("reIdentifyTypeDef");
        return this.omrsClient.reIdentifyTypeDef(userId, originalTypeDefGUID, originalTypeDefName, newTypeDefGUID, newTypeDefName);
    }

    public AttributeTypeDef reIdentifyAttributeTypeDef(String userId, String originalAttributeTypeDefGUID, String originalAttributeTypeDefName, String newAttributeTypeDefGUID, String newAttributeTypeDefName) throws InvalidParameterException, RepositoryErrorException, TypeDefNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyAttributeTypeDef";
        this.validateClient("reIdentifyAttributeTypeDef");
        return this.omrsClient.reIdentifyAttributeTypeDef(userId, originalAttributeTypeDefGUID, originalAttributeTypeDefName, newAttributeTypeDefGUID, newAttributeTypeDefName);
    }

    public EntityDetail isEntityKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isEntityKnown";
        this.validateClient("isEntityKnown");
        return this.omrsClient.isEntityKnown(userId, guid);
    }

    public EntitySummary getEntitySummary(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException {
        String methodName = "getEntitySummary";
        this.validateClient("getEntitySummary");
        return this.omrsClient.getEntitySummary(userId, guid);
    }

    public EntityDetail getEntityDetail(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        this.validateClient("getEntityDetail");
        return this.omrsClient.getEntityDetail(userId, guid);
    }

    public EntityDetail getEntityDetail(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetail";
        this.validateClient("getEntityDetail");
        return this.omrsClient.getEntityDetail(userId, guid, asOfTime);
    }

    public List<EntityDetail> getEntityDetailHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityProxyOnlyException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityDetailHistory";
        this.validateClient("getEntityDetailHistory");
        return this.omrsClient.getEntityDetailHistory(userId, guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder);
    }

    public List<Relationship> getRelationshipsForEntity(String userId, String entityGUID, String relationshipTypeGUID, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipsForEntity";
        this.validateClient("getRelationshipsForEntity");
        return this.omrsClient.getRelationshipsForEntity(userId, entityGUID, relationshipTypeGUID, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntities(String userId, String entityTypeGUID, List<String> entitySubtypeGUIDs, SearchProperties matchProperties, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, SearchClassifications matchClassifications, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntities";
        this.validateClient("findEntities");
        return this.omrsClient.findEntities(userId, entityTypeGUID, entitySubtypeGUIDs, matchProperties, fromEntityElement, limitResultsByStatus, matchClassifications, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByProperty(String userId, String entityTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByProperty";
        this.validateClient("findEntitiesByProperty");
        return this.omrsClient.findEntitiesByProperty(userId, entityTypeGUID, matchProperties, matchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByClassification(String userId, String entityTypeGUID, String classificationName, InstanceProperties matchClassificationProperties, MatchCriteria matchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, ClassificationErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByClassification";
        this.validateClient("findEntitiesByClassification");
        return this.omrsClient.findEntitiesByClassification(userId, entityTypeGUID, classificationName, matchClassificationProperties, matchCriteria, fromEntityElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<EntityDetail> findEntitiesByPropertyValue(String userId, String entityTypeGUID, String searchCriteria, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findEntitiesByPropertyValue";
        this.validateClient("findEntitiesByPropertyValue");
        return this.omrsClient.findEntitiesByPropertyValue(userId, entityTypeGUID, searchCriteria, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public Relationship isRelationshipKnown(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, UserNotAuthorizedException {
        String methodName = "isRelationshipKnown";
        this.validateClient("isRelationshipKnown");
        return this.omrsClient.isRelationshipKnown(userId, guid);
    }

    public Relationship getRelationship(String userId, String guid) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        this.validateClient("getRelationship");
        return this.omrsClient.getRelationship(userId, guid);
    }

    public Relationship getRelationship(String userId, String guid, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationship";
        this.validateClient("getRelationship");
        return this.omrsClient.getRelationship(userId, guid, asOfTime);
    }

    public List<Relationship> getRelationshipHistory(String userId, String guid, Date fromTime, Date toTime, int startFromElement, int pageSize, HistorySequencingOrder sequencingOrder) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelationshipHistory";
        this.validateClient("getRelationshipHistory");
        return this.omrsClient.getRelationshipHistory(userId, guid, fromTime, toTime, startFromElement, pageSize, sequencingOrder);
    }

    public List<Relationship> findRelationships(String userId, String relationshipTypeGUID, List<String> relationshipSubtypeGUIDs, SearchProperties matchProperties, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationships";
        this.validateClient("findRelationships");
        return this.omrsClient.findRelationships(userId, relationshipTypeGUID, relationshipSubtypeGUIDs, matchProperties, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<Relationship> findRelationshipsByProperty(String userId, String relationshipTypeGUID, InstanceProperties matchProperties, MatchCriteria matchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByProperty";
        this.validateClient("findRelationshipsByProperty");
        return this.omrsClient.findRelationshipsByProperty(userId, relationshipTypeGUID, matchProperties, matchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public List<Relationship> findRelationshipsByPropertyValue(String userId, String relationshipTypeGUID, String searchCriteria, int fromRelationshipElement, List<InstanceStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, TypeErrorException, RepositoryErrorException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "findRelationshipsByPropertyValue";
        this.validateClient("findRelationshipsByPropertyValue");
        return this.omrsClient.findRelationshipsByPropertyValue(userId, relationshipTypeGUID, searchCriteria, fromRelationshipElement, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public InstanceGraph getLinkingEntities(String userId, String startEntityGUID, String endEntityGUID, List<InstanceStatus> limitResultsByStatus, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getLinkingEntities";
        this.validateClient("getLinkingEntities");
        return this.omrsClient.getLinkingEntities(userId, startEntityGUID, endEntityGUID, limitResultsByStatus, asOfTime);
    }

    public InstanceGraph getEntityNeighborhood(String userId, String entityGUID, List<String> entityTypeGUIDs, List<String> relationshipTypeGUIDs, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, int level) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getEntityNeighborhood";
        this.validateClient("getEntityNeighborhood");
        return this.omrsClient.getEntityNeighborhood(userId, entityGUID, entityTypeGUIDs, relationshipTypeGUIDs, limitResultsByStatus, limitResultsByClassification, asOfTime, level);
    }

    public List<EntityDetail> getRelatedEntities(String userId, String startEntityGUID, List<String> entityTypeGUIDs, int fromEntityElement, List<InstanceStatus> limitResultsByStatus, List<String> limitResultsByClassification, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, int pageSize) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, PagingErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "getRelatedEntities";
        this.validateClient("getRelatedEntities");
        return this.omrsClient.getRelatedEntities(userId, startEntityGUID, entityTypeGUIDs, fromEntityElement, limitResultsByStatus, limitResultsByClassification, asOfTime, sequencingProperty, sequencingOrder, pageSize);
    }

    public EntityDetail addEntity(String userId, String entityTypeGUID, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntity";
        if (this.isfunctionSupported("addEntity")) {
            this.validateClient("addEntity");
            try {
                return this.omrsClient.addEntity(userId, entityTypeGUID, initialProperties, initialClassifications, initialStatus);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("addEntity");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("addEntity");
        return null;
    }

    public EntityDetail addExternalEntity(String userId, String entityTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, List<Classification> initialClassifications, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addExternalEntity";
        if (this.isfunctionSupported("addExternalEntity")) {
            this.validateClient("addExternalEntity");
            try {
                return this.omrsClient.addExternalEntity(userId, entityTypeGUID, externalSourceGUID, externalSourceName, initialProperties, initialClassifications, initialStatus);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("addExternalEntity");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("addExternalEntity");
        return null;
    }

    public void addEntityProxy(String userId, EntityProxy entityProxy) throws InvalidParameterException, RepositoryErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addEntityProxy";
        if (this.isfunctionSupported("addEntityProxy")) {
            this.validateClient("addEntityProxy");
            try {
                this.omrsClient.addEntityProxy(userId, entityProxy);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("addEntityProxy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("addEntityProxy");
        }
    }

    public EntityDetail updateEntityStatus(String userId, String entityGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityStatus";
        if (this.isfunctionSupported("updateEntityStatus")) {
            this.validateClient("updateEntityStatus");
            try {
                return this.omrsClient.updateEntityStatus(userId, entityGUID, newStatus);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("updateEntityStatus");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("updateEntityStatus");
        return null;
    }

    public EntityDetail updateEntityProperties(String userId, String entityGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityProperties";
        if (this.isfunctionSupported("updateEntityProperties")) {
            this.validateClient("updateEntityProperties");
            try {
                return this.omrsClient.updateEntityProperties(userId, entityGUID, properties);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("updateEntityProperties");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("updateEntityProperties");
        return null;
    }

    public EntityDetail undoEntityUpdate(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoEntityUpdate";
        if (this.isfunctionSupported("undoEntityUpdate")) {
            this.validateClient("undoEntityUpdate");
            try {
                return this.omrsClient.undoEntityUpdate(userId, entityGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("undoEntityUpdate");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("undoEntityUpdate");
        return null;
    }

    public EntityDetail deleteEntity(String userId, String typeDefGUID, String typeDefName, String obsoleteEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntity";
        if (this.isfunctionSupported("deleteEntity")) {
            this.validateClient("deleteEntity");
            try {
                return this.omrsClient.deleteEntity(userId, typeDefGUID, typeDefName, obsoleteEntityGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("deleteEntity");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("deleteEntity");
        return null;
    }

    public void purgeEntity(String userId, String typeDefGUID, String typeDefName, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntity";
        if (this.isfunctionSupported("purgeEntity")) {
            this.validateClient("purgeEntity");
            try {
                this.omrsClient.purgeEntity(userId, typeDefGUID, typeDefName, deletedEntityGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("purgeEntity");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("purgeEntity");
        }
    }

    public EntityDetail restoreEntity(String userId, String deletedEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, EntityNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreEntity";
        if (this.isfunctionSupported("restoreEntity")) {
            this.validateClient("restoreEntity");
            try {
                return this.omrsClient.restoreEntity(userId, deletedEntityGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("restoreEntity");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("restoreEntity");
        return null;
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "classifyEntity";
        if (this.isfunctionSupported("classifyEntity")) {
            this.validateClient("classifyEntity");
            try {
                return this.omrsClient.classifyEntity(userId, entityGUID, classificationName, classificationProperties);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("classifyEntity");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("classifyEntity");
        return null;
    }

    public Classification classifyEntity(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntityProxy";
        if (this.isfunctionSupported("classifyEntityProxy")) {
            this.validateClient("classifyEntityProxy");
            try {
                return this.omrsClient.classifyEntity(userId, entityProxy, classificationName, classificationProperties);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("classifyEntityProxy");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("classifyEntityProxy");
        return null;
    }

    public EntityDetail classifyEntity(String userId, String entityGUID, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntity (detailed)";
        if (this.isfunctionSupported("classifyEntity (detailed)")) {
            this.validateClient("classifyEntity (detailed)");
            try {
                return this.omrsClient.classifyEntity(userId, entityGUID, classificationName, externalSourceGUID, externalSourceName, classificationOrigin, classificationOriginGUID, classificationProperties);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("classifyEntity (detailed)");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("classifyEntity (detailed)");
        return null;
    }

    public Classification classifyEntity(String userId, EntityProxy entityProxy, String classificationName, String externalSourceGUID, String externalSourceName, ClassificationOrigin classificationOrigin, String classificationOriginGUID, InstanceProperties classificationProperties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "classifyEntityProxy (detailed)";
        if (this.isfunctionSupported("classifyEntityProxy (detailed)")) {
            this.validateClient("classifyEntityProxy (detailed)");
            try {
                return this.omrsClient.classifyEntity(userId, entityProxy, classificationName, externalSourceGUID, externalSourceName, classificationOrigin, classificationOriginGUID, classificationProperties);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("classifyEntityProxy (detailed)");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("classifyEntityProxy (detailed)");
        return null;
    }

    public EntityDetail declassifyEntity(String userId, String entityGUID, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "declassifyEntity";
        if (this.isfunctionSupported("declassifyEntity")) {
            this.validateClient("declassifyEntity");
            try {
                return this.omrsClient.declassifyEntity(userId, entityGUID, classificationName);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("declassifyEntity");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("declassifyEntity");
        return null;
    }

    public Classification declassifyEntity(String userId, EntityProxy entityProxy, String classificationName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "declassifyEntityProxy";
        if (this.isfunctionSupported("declassifyEntityProxy")) {
            this.validateClient("declassifyEntityProxy");
            try {
                return this.omrsClient.declassifyEntity(userId, entityProxy, classificationName);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("declassifyEntityProxy");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("declassifyEntityProxy");
        return null;
    }

    public EntityDetail updateEntityClassification(String userId, String entityGUID, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateEntityClassification";
        if (this.isfunctionSupported("updateEntityClassification")) {
            this.validateClient("updateEntityClassification");
            try {
                return this.omrsClient.updateEntityClassification(userId, entityGUID, classificationName, properties);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("updateEntityClassification");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("updateEntityClassification");
        return null;
    }

    public Classification updateEntityClassification(String userId, EntityProxy entityProxy, String classificationName, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, ClassificationErrorException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "updateEntityProxyClassification";
        if (this.isfunctionSupported("updateEntityProxyClassification")) {
            this.validateClient("updateEntityProxyClassification");
            try {
                return this.omrsClient.updateEntityClassification(userId, entityProxy, classificationName, properties);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("updateEntityProxyClassification");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("updateEntityProxyClassification");
        return null;
    }

    public Relationship addRelationship(String userId, String relationshipTypeGUID, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "addRelationship";
        if (this.isfunctionSupported("addRelationship")) {
            this.validateClient("addRelationship");
            try {
                return this.omrsClient.addRelationship(userId, relationshipTypeGUID, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("addRelationship");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("addRelationship");
        return null;
    }

    public Relationship addExternalRelationship(String userId, String relationshipTypeGUID, String externalSourceGUID, String externalSourceName, InstanceProperties initialProperties, String entityOneGUID, String entityTwoGUID, InstanceStatus initialStatus) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, EntityNotKnownException, StatusNotSupportedException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "addExternalRelationship";
        if (this.isfunctionSupported("addExternalRelationship")) {
            this.validateClient("addExternalRelationship");
            try {
                return this.omrsClient.addExternalRelationship(userId, relationshipTypeGUID, externalSourceGUID, externalSourceName, initialProperties, entityOneGUID, entityTwoGUID, initialStatus);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("addExternalRelationship");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("addExternalRelationship");
        return null;
    }

    public Relationship updateRelationshipStatus(String userId, String relationshipGUID, InstanceStatus newStatus) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, StatusNotSupportedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipStatus";
        if (this.isfunctionSupported("updateRelationshipStatus")) {
            this.validateClient("updateRelationshipStatus");
            try {
                return this.omrsClient.updateRelationshipStatus(userId, relationshipGUID, newStatus);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("updateRelationshipStatus");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("updateRelationshipStatus");
        return null;
    }

    public Relationship updateRelationshipProperties(String userId, String relationshipGUID, InstanceProperties properties) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, PropertyErrorException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "updateRelationshipProperties";
        if (this.isfunctionSupported("updateRelationshipProperties")) {
            this.validateClient("updateRelationshipProperties");
            try {
                return this.omrsClient.updateRelationshipProperties(userId, relationshipGUID, properties);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("updateRelationshipProperties");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("updateRelationshipProperties");
        return null;
    }

    public Relationship undoRelationshipUpdate(String userId, String relationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "undoRelationshipUpdate";
        if (this.isfunctionSupported("undoRelationshipUpdate")) {
            this.validateClient("undoRelationshipUpdate");
            try {
                return this.omrsClient.undoRelationshipUpdate(userId, relationshipGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("undoRelationshipUpdate");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("undoRelationshipUpdate");
        return null;
    }

    public Relationship deleteRelationship(String userId, String typeDefGUID, String typeDefName, String obsoleteRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationship";
        if (this.isfunctionSupported("deleteRelationship")) {
            this.validateClient("deleteRelationship");
            try {
                return this.omrsClient.deleteRelationship(userId, typeDefGUID, typeDefName, obsoleteRelationshipGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("deleteRelationship");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("deleteRelationship");
        return null;
    }

    public void purgeRelationship(String userId, String typeDefGUID, String typeDefName, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationship";
        if (this.isfunctionSupported("purgeRelationship")) {
            this.validateClient("purgeRelationship");
            try {
                this.omrsClient.purgeRelationship(userId, typeDefGUID, typeDefName, deletedRelationshipGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("purgeRelationship");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("purgeRelationship");
        }
    }

    public Relationship restoreRelationship(String userId, String deletedRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, RelationshipNotDeletedException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "restoreRelationship";
        if (this.isfunctionSupported("restoreRelationship")) {
            this.validateClient("restoreRelationship");
            try {
                return this.omrsClient.restoreRelationship(userId, deletedRelationshipGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("restoreRelationship");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("restoreRelationship");
        return null;
    }

    public EntityDetail reIdentifyEntity(String userId, String typeDefGUID, String typeDefName, String entityGUID, String newEntityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyEntity";
        if (this.isfunctionSupported("reIdentifyEntity")) {
            this.validateClient("reIdentifyEntity");
            try {
                return this.omrsClient.reIdentifyEntity(userId, typeDefGUID, typeDefName, entityGUID, newEntityGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("reIdentifyEntity");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("reIdentifyEntity");
        return null;
    }

    public EntityDetail reTypeEntity(String userId, String entityGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, ClassificationErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeEntity";
        if (this.isfunctionSupported("reTypeEntity")) {
            this.validateClient("reTypeEntity");
            try {
                return this.omrsClient.reTypeEntity(userId, entityGUID, currentTypeDefSummary, newTypeDefSummary);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("reTypeEntity");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("reTypeEntity");
        return null;
    }

    public EntityDetail reHomeEntity(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeEntity";
        if (this.isfunctionSupported("reHomeEntity")) {
            this.validateClient("reHomeEntity");
            try {
                return this.omrsClient.reHomeEntity(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("reHomeEntity");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("reHomeEntity");
        return null;
    }

    public Relationship reIdentifyRelationship(String userId, String typeDefGUID, String typeDefName, String relationshipGUID, String newRelationshipGUID) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reIdentifyRelationship";
        if (this.isfunctionSupported("reIdentifyRelationship")) {
            this.validateClient("reIdentifyRelationship");
            try {
                return this.omrsClient.reIdentifyRelationship(userId, typeDefGUID, typeDefName, relationshipGUID, newRelationshipGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("reIdentifyRelationship");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("reIdentifyRelationship");
        return null;
    }

    public Relationship reTypeRelationship(String userId, String relationshipGUID, TypeDefSummary currentTypeDefSummary, TypeDefSummary newTypeDefSummary) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reTypeRelationship";
        if (this.isfunctionSupported("reTypeRelationship")) {
            this.validateClient("reTypeRelationship");
            try {
                return this.omrsClient.reTypeRelationship(userId, relationshipGUID, currentTypeDefSummary, newTypeDefSummary);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("reTypeRelationship");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("reTypeRelationship");
        return null;
    }

    public Relationship reHomeRelationship(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId, String newHomeMetadataCollectionId, String newHomeMetadataCollectionName) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "reHomeRelationship";
        if (this.isfunctionSupported("reHomeRelationship")) {
            this.validateClient("reHomeRelationship");
            try {
                return this.omrsClient.reHomeRelationship(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId, newHomeMetadataCollectionId, newHomeMetadataCollectionName);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("reHomeRelationship");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("reHomeRelationship");
        return null;
    }

    public void saveEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveEntityReferenceCopy";
        if (this.isfunctionSupported("saveEntityReferenceCopy")) {
            this.validateClient("saveEntityReferenceCopy");
            try {
                this.omrsClient.saveEntityReferenceCopy(userId, entity);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("saveEntityReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("saveEntityReferenceCopy");
        }
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications";
        if (this.isfunctionSupported("getHomeClassifications")) {
            this.validateClient("getHomeClassifications");
            try {
                return this.omrsClient.getHomeClassifications(userId, entityGUID);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("getHomeClassifications");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("getHomeClassifications");
        return null;
    }

    public List<Classification> getHomeClassifications(String userId, String entityGUID, Date asOfTime) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "getHomeClassifications (with history)";
        if (this.isfunctionSupported("getHomeClassifications (with history)")) {
            this.validateClient("getHomeClassifications (with history)");
            try {
                return this.omrsClient.getHomeClassifications(userId, entityGUID, asOfTime);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("getHomeClassifications (with history)");
                throw error;
            }
        }
        this.reportUnsupportedOptionalFunction("getHomeClassifications (with history)");
        return null;
    }

    public void deleteEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteEntityReferenceCopy";
        if (this.isfunctionSupported("deleteEntityReferenceCopy")) {
            this.validateClient("deleteEntityReferenceCopy");
            try {
                this.omrsClient.deleteEntityReferenceCopy(userId, entity);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("deleteEntityReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("deleteEntityReferenceCopy");
        }
    }

    public void purgeEntityReferenceCopy(String userId, EntityDetail entity) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, PropertyErrorException, HomeEntityException, EntityConflictException, InvalidEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeDeleteEntityReferenceCopy";
        if (this.isfunctionSupported("purgeDeleteEntityReferenceCopy")) {
            this.validateClient("purgeDeleteEntityReferenceCopy");
            try {
                this.omrsClient.purgeEntityReferenceCopy(userId, entity);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("purgeDeleteEntityReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("purgeDeleteEntityReferenceCopy");
        }
    }

    public void purgeEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeEntityReferenceCopy";
        if (this.isfunctionSupported("purgeEntityReferenceCopy")) {
            this.validateClient("purgeEntityReferenceCopy");
            try {
                this.omrsClient.purgeEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("purgeEntityReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("purgeEntityReferenceCopy");
        }
    }

    public void refreshEntityReferenceCopy(String userId, String entityGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, EntityNotKnownException, HomeEntityException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "refreshEntityReferenceCopy";
        if (this.isfunctionSupported("refreshEntityReferenceCopy")) {
            this.validateClient("refreshEntityReferenceCopy");
            try {
                this.omrsClient.refreshEntityReferenceCopy(userId, entityGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("refreshEntityReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("refreshEntityReferenceCopy");
        }
    }

    public void saveClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "saveClassificationReferenceCopy";
        if (this.isfunctionSupported("saveClassificationReferenceCopy")) {
            this.validateClient("saveClassificationReferenceCopy");
            try {
                this.omrsClient.saveClassificationReferenceCopy(userId, entity, classification);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("saveClassificationReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("saveClassificationReferenceCopy");
        }
    }

    public void saveClassificationReferenceCopy(String userId, EntityProxy entity, Classification classification) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityConflictException, InvalidEntityException, PropertyErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "saveClassificationReferenceCopy(proxy)";
        if (this.isfunctionSupported("saveClassificationReferenceCopy(proxy)")) {
            this.validateClient("saveClassificationReferenceCopy(proxy)");
            try {
                this.omrsClient.saveClassificationReferenceCopy(userId, entity, classification);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("saveClassificationReferenceCopy(proxy)");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("saveClassificationReferenceCopy(proxy)");
        }
    }

    public void purgeClassificationReferenceCopy(String userId, EntityDetail entity, Classification classification) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityConflictException, InvalidEntityException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "purgeClassificationReferenceCopy";
        if (this.isfunctionSupported("purgeClassificationReferenceCopy")) {
            this.validateClient("purgeClassificationReferenceCopy");
            try {
                this.omrsClient.purgeClassificationReferenceCopy(userId, entity, classification);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("purgeClassificationReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("purgeClassificationReferenceCopy");
        }
    }

    public void purgeClassificationReferenceCopy(String userId, EntityProxy entity, Classification classification) throws InvalidParameterException, TypeErrorException, PropertyErrorException, EntityConflictException, InvalidEntityException, RepositoryErrorException, UserNotAuthorizedException, FunctionNotSupportedException {
        String methodName = "purgeClassificationReferenceCopy (proxy)";
        if (this.isfunctionSupported("purgeClassificationReferenceCopy (proxy)")) {
            this.validateClient("purgeClassificationReferenceCopy (proxy)");
            try {
                this.omrsClient.purgeClassificationReferenceCopy(userId, entity, classification);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("purgeClassificationReferenceCopy (proxy)");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("purgeClassificationReferenceCopy (proxy)");
        }
    }

    public void saveRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveRelationshipReferenceCopy";
        if (this.isfunctionSupported("saveRelationshipReferenceCopy")) {
            this.validateClient("saveRelationshipReferenceCopy");
            try {
                this.omrsClient.saveRelationshipReferenceCopy(userId, relationship);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("saveRelationshipReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("saveRelationshipReferenceCopy");
        }
    }

    public void deleteRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "deleteRelationshipReferenceCopy";
        if (this.isfunctionSupported("deleteRelationshipReferenceCopy")) {
            this.validateClient("deleteRelationshipReferenceCopy");
            try {
                this.omrsClient.deleteRelationshipReferenceCopy(userId, relationship);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("deleteRelationshipReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("deleteRelationshipReferenceCopy");
        }
    }

    public void purgeRelationshipReferenceCopy(String userId, Relationship relationship) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, HomeRelationshipException, RelationshipConflictException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeDeleteRelationshipReferenceCopy";
        if (this.isfunctionSupported("purgeDeleteRelationshipReferenceCopy")) {
            this.validateClient("purgeDeleteRelationshipReferenceCopy");
            try {
                this.omrsClient.purgeRelationshipReferenceCopy(userId, relationship);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("purgeDeleteRelationshipReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("purgeDeleteRelationshipReferenceCopy");
        }
    }

    public void purgeRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "purgeRelationshipReferenceCopy";
        if (this.isfunctionSupported("purgeRelationshipReferenceCopy")) {
            this.validateClient("purgeRelationshipReferenceCopy");
            try {
                this.omrsClient.purgeRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("purgeRelationshipReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("purgeRelationshipReferenceCopy");
        }
    }

    public void refreshRelationshipReferenceCopy(String userId, String relationshipGUID, String typeDefGUID, String typeDefName, String homeMetadataCollectionId) throws InvalidParameterException, RepositoryErrorException, RelationshipNotKnownException, HomeRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "refreshRelationshipReferenceCopy";
        if (this.isfunctionSupported("refreshRelationshipReferenceCopy")) {
            this.validateClient("refreshRelationshipReferenceCopy");
            try {
                this.omrsClient.refreshRelationshipReferenceCopy(userId, relationshipGUID, typeDefGUID, typeDefName, homeMetadataCollectionId);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("refreshRelationshipReferenceCopy");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("refreshRelationshipReferenceCopy");
        }
    }

    public void saveInstanceReferenceCopies(String userId, InstanceGraph instances) throws InvalidParameterException, RepositoryErrorException, TypeErrorException, EntityNotKnownException, PropertyErrorException, EntityConflictException, RelationshipConflictException, InvalidEntityException, InvalidRelationshipException, FunctionNotSupportedException, UserNotAuthorizedException {
        String methodName = "saveInstanceReferenceCopies";
        if (this.isfunctionSupported("saveInstanceReferenceCopies")) {
            this.validateClient("saveInstanceReferenceCopies");
            try {
                this.omrsClient.saveInstanceReferenceCopies(userId, instances);
            }
            catch (FunctionNotSupportedException error) {
                this.markFunctionUnsupported("saveInstanceReferenceCopies");
                throw error;
            }
        } else {
            this.reportUnsupportedOptionalFunction("saveInstanceReferenceCopies");
        }
    }
}

