/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors.datastoreconnectors;

import java.util.Date;
import org.odpi.openmetadata.adapters.connectors.datastore.avrofile.AvroFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.datafolder.DataFolderProvider;
import org.odpi.openmetadata.archiveutilities.openconnectors.base.OpenConnectorArchiveBuilder;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;

public class DataStoreConnectorsArchiveBuilder
extends OpenConnectorArchiveBuilder {
    private static final String archiveGUID = "acdc5637-92a7-4926-b47b-a3d407546f89";
    private static final String archiveRootName = "DataStoreConnectors";
    private static final String archiveName = "Data Store Open Connector Types";
    private static final String archiveLicense = "Apache 2.0";
    private static final String archiveDescription = "Connector type definitions for data store connectors that follow the Open Connector Framework (OCF).";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "ODPi Egeria";
    private static final Date creationDate = new Date(1570383395115L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";

    public DataStoreConnectorsArchiveBuilder() {
        super(archiveGUID, archiveName, archiveDescription, archiveType, archiveRootName, originatorName, archiveLicense, creationDate, 1L, versionName);
    }

    @Override
    protected OpenMetadataArchive getOpenMetadataArchive() {
        AvroFileStoreProvider avroFileStoreProvider = new AvroFileStoreProvider();
        ConnectorType connectorType = avroFileStoreProvider.getConnectorType();
        super.addConnectorType(connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getConnectorProviderClassName(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        BasicFileStoreProvider basicFileStoreProvider = new BasicFileStoreProvider();
        connectorType = basicFileStoreProvider.getConnectorType();
        super.addConnectorType(connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getConnectorProviderClassName(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        CSVFileStoreProvider csvFileStoreProvider = new CSVFileStoreProvider();
        connectorType = csvFileStoreProvider.getConnectorType();
        super.addConnectorType(connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getConnectorProviderClassName(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        DataFolderProvider dataFolderProvider = new DataFolderProvider();
        connectorType = dataFolderProvider.getConnectorType();
        super.addConnectorType(connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getConnectorProviderClassName(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        return super.getOpenMetadataArchive();
    }
}

