/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors.base;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveGUIDMap;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;

public class OpenConnectorArchiveBuilder {
    private static final String guidMapFileNamePostFix = "GUIDMap.json";
    private static final String CONNECTION_TYPE_NAME = "Connection";
    private static final String CONNECTOR_TYPE_TYPE_NAME = "ConnectorType";
    private static final String ENDPOINT_TYPE_NAME = "Endpoint";
    private static final String CONNECTION_CONNECTOR_TYPE_TYPE_NAME = "ConnectionConnectorType";
    private static final String CONNECTION_ENDPOINT_TYPE_NAME = "ConnectionEndpoint";
    private static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    private static final String ADDITIONAL_PROPERTIES_PROPERTY = "additionalProperties";
    private static final String DISPLAY_NAME_PROPERTY = "displayName";
    private static final String DESCRIPTION_PROPERTY = "description";
    private static final String SECURED_PROPERTIES_PROPERTY = "securedProperties";
    private static final String CONFIGURATION_PROPERTIES_PROPERTY = "configurationProperties";
    private static final String USER_ID_PROPERTY = "userId";
    private static final String CLEAR_PASSWORD_PROPERTY = "clearPassword";
    private static final String ENCRYPTED_PASSWORD_PROPERTY = "encryptedPassword";
    private static final String CONNECTOR_PROVIDER_PROPERTY = "connectorProviderClassName";
    private static final String RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY = "recognizedAdditionalProperties";
    private static final String RECOGNIZED_SECURED_PROPERTIES_PROPERTY = "recognizedSecuredProperties";
    private static final String RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY = "recognizedConfigurationProperties";
    private static final String NETWORK_ADDRESS_PROPERTY = "networkAddress";
    private static final String PROTOCOL_PROPERTY = "protocol";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;
    private OMRSArchiveGUIDMap idToGUIDMap;
    private String archiveRootName;
    private String originatorName;
    private String versionName;

    protected OpenConnectorArchiveBuilder(String archiveGUID, String archiveName, String archiveDescription, OpenMetadataArchiveType archiveType, String archiveRootName, String originatorName, String originatorLicense, Date creationDate, long versionNumber, String versionName) {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, originatorLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, versionNumber, versionName);
        this.idToGUIDMap = new OMRSArchiveGUIDMap(archiveRootName + guidMapFileNamePostFix);
        this.archiveRootName = archiveRootName;
        this.originatorName = originatorName;
        this.versionName = versionName;
    }

    protected OpenMetadataArchive getOpenMetadataArchive() {
        System.out.println("GUIDs map size: " + this.idToGUIDMap.getSize());
        this.idToGUIDMap.saveGUIDs();
        return this.archiveBuilder.getOpenMetadataArchive();
    }

    protected void logBadArchiveContent(String methodName) {
        this.archiveBuilder.logBadArchiveContent(methodName);
    }

    protected String addConnection(String qualifiedName, String displayName, String description, String userId, String clearPassword, String encryptedPassword, Map<String, String> securedProperties, Map<String, Object> configurationProperties, Map<String, String> additionalProperties, String connectorTypeGUID, String endpointGUID) {
        EntityProxy end2;
        EntityProxy end1;
        String methodName = "addConnection";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, USER_ID_PROPERTY, userId, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CLEAR_PASSWORD_PROPERTY, clearPassword, "addConnection");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, ENCRYPTED_PASSWORD_PROPERTY, encryptedPassword, "addConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, SECURED_PROPERTIES_PROPERTY, securedProperties, "addConnection");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnection");
        properties = this.archiveHelper.addMapPropertyToInstance(this.archiveRootName, properties, CONFIGURATION_PROPERTIES_PROPERTY, configurationProperties, "addConnection");
        EntityDetail connectionEntity = this.archiveHelper.getEntityDetail(CONNECTION_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectionEntity);
        if (connectorTypeGUID != null) {
            EntityDetail connectorTypeEntity = this.archiveBuilder.getEntity(connectorTypeGUID);
            end1 = this.archiveHelper.getEntityProxy(connectionEntity);
            end2 = this.archiveHelper.getEntityProxy(connectorTypeEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTION_CONNECTOR_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_connectorType_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        if (endpointGUID != null) {
            EntityDetail endpointEntity = this.archiveBuilder.getEntity(connectorTypeGUID);
            end1 = this.archiveHelper.getEntityProxy(endpointEntity);
            end2 = this.archiveHelper.getEntityProxy(connectionEntity);
            this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(CONNECTION_ENDPOINT_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName + "_endpoint_relationship"), null, InstanceStatus.ACTIVE, end1, end2));
        }
        return connectionEntity.getGUID();
    }

    protected String addConnectorType(String connectorTypeGUID, String qualifiedName, String displayName, String description, String connectorProviderClassName, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, List<String> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        this.idToGUIDMap.setGUID(qualifiedName, connectorTypeGUID);
        return this.addConnectorType(qualifiedName, displayName, description, connectorProviderClassName, recognizedSecuredProperties, recognizedConfigurationProperties, recognizedAdditionalProperties, additionalProperties);
    }

    protected String addConnectorType(String qualifiedName, String displayName, String description, String connectorProviderClassName, List<String> recognizedSecuredProperties, List<String> recognizedConfigurationProperties, List<String> recognizedAdditionalProperties, Map<String, String> additionalProperties) {
        String methodName = "addConnectorType";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addConnectorType");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, CONNECTOR_PROVIDER_PROPERTY, connectorProviderClassName, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_SECURED_PROPERTIES_PROPERTY, recognizedSecuredProperties, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_ADDITIONAL_PROPERTIES_PROPERTY, recognizedAdditionalProperties, "addConnectorType");
        properties = this.archiveHelper.addStringArrayPropertyToInstance(this.archiveRootName, properties, RECOGNIZED_CONFIGURATION_PROPERTIES_PROPERTY, recognizedConfigurationProperties, "addConnectorType");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addConnectorType");
        EntityDetail connectorTypeEntity = this.archiveHelper.getEntityDetail(CONNECTOR_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectorTypeEntity);
        return connectorTypeEntity.getGUID();
    }

    protected String addEndpoint(String qualifiedName, String displayName, String description, String networkAddress, String protocol, Map<String, String> additionalProperties) {
        String methodName = "addEndpoint";
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, QUALIFIED_NAME_PROPERTY, qualifiedName, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DISPLAY_NAME_PROPERTY, displayName, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, DESCRIPTION_PROPERTY, description, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, NETWORK_ADDRESS_PROPERTY, networkAddress, "addEndpoint");
        properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, properties, PROTOCOL_PROPERTY, protocol, "addEndpoint");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, ADDITIONAL_PROPERTIES_PROPERTY, additionalProperties, "addEndpoint");
        EntityDetail connectorTypeEntity = this.archiveHelper.getEntityDetail(CONNECTOR_TYPE_TYPE_NAME, this.idToGUIDMap.getGUID(qualifiedName), properties, InstanceStatus.ACTIVE, null);
        this.archiveBuilder.addEntity(connectorTypeEntity);
        return connectorTypeEntity.getGUID();
    }
}

