/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors.datastoreconnectors;

import java.util.Date;
import org.odpi.openmetadata.adapters.connectors.datastore.avrofile.AvroFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.datafolder.DataFolderProvider;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicProvider;
import org.odpi.openmetadata.archiveutilities.openconnectors.base.OpenConnectorArchiveBuilder;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;

public class DataStoreConnectorsArchiveBuilder
extends OpenConnectorArchiveBuilder {
    private static final String archiveGUID = "acdc5637-92a7-4926-b47b-a3d407546f89";
    private static final String archiveRootName = "DataStoreConnectorTypes";
    private static final String archiveName = "Data Store Open Connector Types";
    private static final String archiveLicense = "Apache 2.0";
    private static final String archiveDescription = "Standard connector categories and connector type definitions for data store connectors that follow the Open Connector Framework (OCF).";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "Egeria";
    private static final Date creationDate = new Date(1570383395115L);
    private static final String connectorTypeDirectoryQualifiedName = "OpenMetadataConnectorTypeDirectory_acdc5637-92a7-4926-b47b-a3d407546f89";
    private static final String connectorTypeDirectoryDisplayName = "Open Metadata Connector Type Directory";
    private static final String connectorTypeDirectoryDescription = "Open Metadata standard connector categories and connector types.";
    private static final String fileConnectorCategoryQualifiedName = "OpenMetadataFileConnectorCategory_acdc5637-92a7-4926-b47b-a3d407546f89";
    private static final String fileConnectorCategoryDisplayName = "Open Metadata File Connector Category";
    private static final String fileConnectorCategoryDescription = "Open Metadata connector category for connectors that work with files.";
    private static final String kafkaConnectorCategoryQualifiedName = "OpenMetadataKafkaConnectorCategory_acdc5637-92a7-4926-b47b-a3d407546f89";
    private static final String kafkaConnectorCategoryDisplayName = "Open Metadata Apache Kafka Connector Category Directory";
    private static final String kafkaConnectorCategoryDescription = "Open Metadata connector category for connectors to Apache Kafka.";
    private static final String kafkaConnectorCategoryTargetSource = "Apache Software Foundation (ASF)";
    private static final String kafkaConnectorCategoryTargetName = "Apache Kafka.";
    private static final String jsonFileAssetTypeName = "JSONFile";
    private static final String jsonFileFormat = "json";
    private static final String mediaFileAssetTypeName = "MediaFile";
    private static final String documentAssetTypeName = "Document";
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";

    public DataStoreConnectorsArchiveBuilder() {
        super(archiveGUID, archiveName, archiveDescription, archiveType, archiveRootName, originatorName, archiveLicense, creationDate, 1L, versionName);
    }

    @Override
    protected OpenMetadataArchive getOpenMetadataArchive() {
        String connectorDirectoryTypeGUID = super.addConnectorTypeDirectory(connectorTypeDirectoryQualifiedName, connectorTypeDirectoryDisplayName, connectorTypeDirectoryDescription, null);
        String fileConnectorCategoryGUID = super.addConnectorCategory(connectorDirectoryTypeGUID, fileConnectorCategoryQualifiedName, fileConnectorCategoryDisplayName, fileConnectorCategoryDescription, null, null, null, null, null, null);
        String kafkaConnectorCategoryGUID = super.addConnectorCategory(connectorDirectoryTypeGUID, kafkaConnectorCategoryQualifiedName, kafkaConnectorCategoryDisplayName, kafkaConnectorCategoryDescription, kafkaConnectorCategoryTargetSource, kafkaConnectorCategoryTargetName, null, null, null, null);
        AvroFileStoreProvider avroFileStoreProvider = new AvroFileStoreProvider();
        ConnectorType connectorType = avroFileStoreProvider.getConnectorType();
        super.addConnectorType(fileConnectorCategoryGUID, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        CSVFileStoreProvider csvFileStoreProvider = new CSVFileStoreProvider();
        connectorType = csvFileStoreProvider.getConnectorType();
        super.addConnectorType(fileConnectorCategoryGUID, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        DataFolderProvider dataFolderProvider = new DataFolderProvider();
        connectorType = dataFolderProvider.getConnectorType();
        super.addConnectorType(fileConnectorCategoryGUID, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        BasicFileStoreProvider basicFileStoreProvider = new BasicFileStoreProvider();
        connectorType = basicFileStoreProvider.getConnectorType();
        super.addConnectorType(fileConnectorCategoryGUID, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        super.addConnectorType(fileConnectorCategoryGUID, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), jsonFileAssetTypeName, jsonFileFormat, connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        super.addConnectorType(fileConnectorCategoryGUID, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), mediaFileAssetTypeName, null, connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        super.addConnectorType(fileConnectorCategoryGUID, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), documentAssetTypeName, null, connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        KafkaOpenMetadataTopicProvider kafkaOpenMetadataTopicProvider = new KafkaOpenMetadataTopicProvider();
        connectorType = kafkaOpenMetadataTopicProvider.getConnectorType();
        super.addConnectorType(kafkaConnectorCategoryGUID, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
        return super.getOpenMetadataArchive();
    }
}

