/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.control.AtlasPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.integration.ApacheAtlasIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.resource.ApacheAtlasRESTProvider;
import org.odpi.openmetadata.adapters.connectors.apacheatlas.survey.SurveyApacheAtlasProvider;
import org.odpi.openmetadata.adapters.connectors.apachekafka.control.KafkaPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.apachekafka.integration.KafkaTopicIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.apachekafka.resource.ApacheKafkaAdminProvider;
import org.odpi.openmetadata.adapters.connectors.apachekafka.survey.SurveyApacheKafkaServerProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.basicfile.BasicFolderProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreProvider;
import org.odpi.openmetadata.adapters.connectors.datastore.datafolder.DataFolderProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.OriginSeekerGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.QualifiedNamePeerDuplicateGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.remediation.ZonePublisherGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.DaysOfWeekGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.EvaluateAnnotationsGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.WriteAuditLogMessageGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship.WriteAuditLogRequestParameter;
import org.odpi.openmetadata.adapters.connectors.governanceactions.verification.VerifyAssetGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.governanceactions.watchdog.GenericFolderWatchdogGovernanceActionProvider;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DataFilesMonitorIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.DataFolderMonitorIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.controls.FilesPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.integration.csvlineageimporter.CSVLineageImporterProvider;
import org.odpi.openmetadata.adapters.connectors.integration.egeria.EgeriaCataloguerIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.jdbc.JDBCIntegrationConnectorProvider;
import org.odpi.openmetadata.adapters.connectors.integration.kafka.KafkaMonitorIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.kafkaaudit.DistributeAuditEventsFromKafkaProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openapis.OpenAPIMonitorIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.APIBasedOpenLineageLogStoreProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.FileBasedOpenLineageLogStoreProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.GovernanceActionOpenLineageIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.OpenLineageCataloguerIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.integration.openlineage.OpenLineageEventReceiverIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.postgres.catalog.PostgresServerIntegrationProvider;
import org.odpi.openmetadata.adapters.connectors.postgres.controls.PostgresPlaceholderProperty;
import org.odpi.openmetadata.adapters.connectors.postgres.survey.PostgresDatabaseSurveyActionProvider;
import org.odpi.openmetadata.adapters.connectors.postgres.survey.PostgresServerSurveyActionProvider;
import org.odpi.openmetadata.adapters.connectors.resource.jdbc.JDBCResourceConnectorProvider;
import org.odpi.openmetadata.adapters.connectors.secretsstore.envar.EnvVarSecretsStoreProvider;
import org.odpi.openmetadata.adapters.connectors.surveyaction.surveycsv.CSVSurveyServiceProvider;
import org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfile.FileSurveyServiceProvider;
import org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfolder.FolderRequestParameter;
import org.odpi.openmetadata.adapters.connectors.surveyaction.surveyfolder.FolderSurveyServiceProvider;
import org.odpi.openmetadata.adapters.eventbus.topic.kafka.KafkaOpenMetadataTopicProvider;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.CommonServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.GovernanceServicesDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.IntegrationServiceDescription;
import org.odpi.openmetadata.adminservices.configuration.registration.ServerTypeClassification;
import org.odpi.openmetadata.adminservices.configuration.registration.ViewServiceDescription;
import org.odpi.openmetadata.archiveutilities.openconnectors.control.FileSystemPlaceholderProperty;
import org.odpi.openmetadata.archiveutilities.openconnectors.control.HostPlaceholderProperty;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceServiceProviderBase;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.PlaceholderPropertyType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ReplacementAttributeType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestParameterType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestTypeType;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnectorProvider;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ByteOrdering;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CollectionMemberStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConfidenceLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConfidentialityLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ContactMethodType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CriticalityLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataClassAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.EngineActionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermActivityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ImpactSeverity;
import org.odpi.openmetadata.frameworks.openmetadata.enums.IncidentReportStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.enums.RetentionBasis;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoStatus;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.CollectionType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.FileExtension;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.FileName;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.FileType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ProjectHealth;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ProjectPhase;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ProjectStatus;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUse;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.ResourceUseProperties;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.SpecificationPropertyType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceProvider;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStepType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.samples.archiveutilities.GovernanceArchiveHelper;

public class OpenConnectorArchiveWriter
extends OMRSArchiveWriter {
    private static final String archiveFileName = "CoreContentPack.omarchive";
    private static final String archiveGUID = "09450b83-20ff-4a8b-a8fb-f9b527bbcba6";
    private static final String archiveName = "CoreContentPack";
    private static final String archiveLicense = "Apache-2.0";
    private static final String archiveDescription = "Connector Types and Categories for connectors from the Egeria project along with metadata valid values for the types of technology supported by these connectors.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "Egeria Project";
    private static final Date creationDate = new Date();
    private static final String connectorTypeDirectoryQualifiedName = "OpenMetadataConnectorTypeDirectory_09450b83-20ff-4a8b-a8fb-f9b527bbcba6";
    private static final String connectorTypeDirectoryDisplayName = "Open Metadata Connector Type Directory";
    private static final String connectorTypeDirectoryDescription = "Open Metadata standard connector categories and connector types.";
    private static final String fileConnectorCategoryQualifiedName = "OpenMetadataFileConnectorCategory_09450b83-20ff-4a8b-a8fb-f9b527bbcba6";
    private static final String fileConnectorCategoryDisplayName = "Open Metadata File Connector Category";
    private static final String fileConnectorCategoryDescription = "Open Metadata connector category for connectors that work with files.";
    private static final String kafkaConnectorCategoryQualifiedName = "OpenMetadataKafkaConnectorCategory_09450b83-20ff-4a8b-a8fb-f9b527bbcba6";
    private static final String kafkaConnectorCategoryDisplayName = "Open Metadata Apache Kafka Connector Category";
    private static final String kafkaConnectorCategoryDescription = "Open Metadata connector category for connectors to Apache Kafka.";
    private static final String kafkaConnectorCategoryTargetSource = "Apache Software Foundation (ASF)";
    private static final String kafkaConnectorCategoryTargetName = "Apache Kafka";
    private static final String relationalConnectorCategoryQualifiedName = "OpenMetadataJDBCConnectorCategory_09450b83-20ff-4a8b-a8fb-f9b527bbcba6";
    private static final String relationalConnectorCategoryDisplayName = "Open Metadata JDBC Connector Category";
    private static final String relationalConnectorCategoryDescription = "Open Metadata connector category for connectors to relational databases.";
    private static final String relationalConnectorCategoryTargetSource = "Java Database Connector (JDBC)";
    private static final String relationalConnectorCategoryTargetName = "Relational Database";
    private static final long versionNumber = creationDate.getTime();
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final GovernanceArchiveHelper archiveHelper;
    private final Map<String, String> parentValidValueQNameToGUIDMap = new HashMap<String, String>();
    private final Map<String, String> deployedImplementationTypeGUIDs = new HashMap<String, String>();
    private final Map<String, String> openMetadataTypeGUIDs = new HashMap<String, String>();

    public OpenConnectorArchiveWriter() {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new GovernanceArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, archiveName, archiveName, originatorName, creationDate, versionNumber, versionName);
    }

    /*
     * WARNING - void declaration
     */
    public OpenMetadataArchive getOpenMetadataArchive() {
        String guid;
        String guid2;
        void var9_15;
        String connectorDirectoryTypeGUID = this.archiveHelper.addConnectorTypeDirectory(connectorTypeDirectoryQualifiedName, connectorTypeDirectoryDisplayName, connectorTypeDirectoryDescription, null);
        String fileConnectorCategoryGUID = this.archiveHelper.addConnectorCategory(connectorDirectoryTypeGUID, fileConnectorCategoryQualifiedName, fileConnectorCategoryDisplayName, fileConnectorCategoryDescription, null, null, null, null, null, null);
        String kafkaConnectorCategoryGUID = this.archiveHelper.addConnectorCategory(connectorDirectoryTypeGUID, kafkaConnectorCategoryQualifiedName, kafkaConnectorCategoryDisplayName, kafkaConnectorCategoryDescription, kafkaConnectorCategoryTargetSource, kafkaConnectorCategoryTargetName, null, null, null, null);
        String relationalConnectorCategoryGUID = this.archiveHelper.addConnectorCategory(connectorDirectoryTypeGUID, relationalConnectorCategoryQualifiedName, relationalConnectorCategoryDisplayName, relationalConnectorCategoryDescription, relationalConnectorCategoryTargetSource, relationalConnectorCategoryTargetName, null, null, null, null);
        String resourceUseParentSetGUID = this.getParentSet(null, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, OpenMetadataProperty.RESOURCE_USE.name, null);
        for (ResourceUse resourceUse : ResourceUse.values()) {
            HashMap<String, String> additionalProperties = null;
            if (resourceUse.getResourceUseProperties() != null) {
                additionalProperties = new HashMap<String, String>();
                for (ResourceUseProperties resourceUseProperties : resourceUse.getResourceUseProperties()) {
                    additionalProperties.put(resourceUseProperties.getName(), resourceUseProperties.getDescription());
                }
            }
            this.archiveHelper.addValidValue(null, resourceUseParentSetGUID, resourceUseParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, resourceUse.getQualifiedName(), resourceUse.getResourceUse(), resourceUse.getDescription(), resourceUse.getCategory(), "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", resourceUse.getResourceUse(), false, false, additionalProperties);
        }
        for (ResourceUse resourceUse : ResourceUseProperties.values()) {
            this.getParentSet(null, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, OpenMetadataProperty.RESOURCE_USE_PROPERTIES.name, resourceUse.getName());
        }
        String projectPhaseParentSetGUID = this.getParentSet(null, OpenMetadataType.PROJECT.typeName, OpenMetadataProperty.PROJECT_PHASE.name, null);
        ProjectPhase[] projectPhaseArray = ProjectPhase.values();
        int n = projectPhaseArray.length;
        boolean bl = false;
        while (var9_15 < n) {
            ProjectPhase projectStatus = projectPhaseArray[var9_15];
            this.archiveHelper.addValidValue(null, projectPhaseParentSetGUID, projectPhaseParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, projectStatus.getQualifiedName(), projectStatus.getName(), projectStatus.getDescription(), projectStatus.getCategory(), "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", projectStatus.getName(), false, false, null);
            ++var9_15;
        }
        String projectHealthParentSetGUID = this.getParentSet(null, OpenMetadataType.PROJECT.typeName, OpenMetadataProperty.PROJECT_HEALTH.name, null);
        for (ProjectHealth projectHealth : ProjectHealth.values()) {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put("colour", projectHealth.getColour());
            this.archiveHelper.addValidValue(null, projectHealthParentSetGUID, projectHealthParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, projectHealth.getQualifiedName(), projectHealth.getName(), projectHealth.getDescription(), projectHealth.getCategory(), "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", projectHealth.getName(), false, false, additionalProperties);
        }
        String projectStatusParentSetGUID = this.getParentSet(null, OpenMetadataType.PROJECT.typeName, "projectStatus", null);
        for (ProjectStatus projectStatus : ProjectStatus.values()) {
            this.archiveHelper.addValidValue(null, projectStatusParentSetGUID, projectStatusParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, projectStatus.getQualifiedName(), projectStatus.getName(), projectStatus.getDescription(), projectStatus.getCategory(), "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", projectStatus.getName(), false, false, null);
        }
        String string = this.getParentSet(null, OpenMetadataType.COLLECTION.typeName, OpenMetadataProperty.COLLECTION_TYPE.name, null);
        for (CollectionType collectionType : CollectionType.values()) {
            this.archiveHelper.addValidValue(null, string, string, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, collectionType.getQualifiedName(), collectionType.getName(), collectionType.getDescription(), collectionType.getCategory(), "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", collectionType.getName(), false, false, null);
        }
        for (CollectionType collectionType : OpenMetadataType.values()) {
            String guid3 = this.addOpenMetadataType((OpenMetadataType)collectionType);
            if (guid3 == null) continue;
            this.openMetadataTypeGUIDs.put(collectionType.typeName, guid3);
        }
        this.addOpenMetadataEnumValidNames(OpenMetadataType.OPERATING_PLATFORM.typeName, OpenMetadataProperty.BYTE_ORDERING.name, ByteOrdering.getOpenTypeName(), new ArrayList<ByteOrdering>(Arrays.asList(ByteOrdering.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.EXTERNAL_ID.typeName, OpenMetadataProperty.KEY_PATTERN.name, KeyPattern.getOpenTypeName(), new ArrayList<KeyPattern>(Arrays.asList(KeyPattern.values())));
        this.addOpenMetadataEnumValidNames("PrimaryKey", OpenMetadataProperty.KEY_PATTERN.name, KeyPattern.getOpenTypeName(), new ArrayList<KeyPattern>(Arrays.asList(KeyPattern.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, OpenMetadataProperty.MEMBERSHIP_STATUS.name, CollectionMemberStatus.getOpenTypeName(), new ArrayList<CollectionMemberStatus>(Arrays.asList(CollectionMemberStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.COMMENT.typeName, OpenMetadataProperty.COMMENT_TYPE.name, CommentType.getOpenTypeName(), new ArrayList<CommentType>(Arrays.asList(CommentType.values())));
        this.addOpenMetadataEnumValidIdentifiers(OpenMetadataType.CONFIDENCE_CLASSIFICATION.typeName, OpenMetadataProperty.CONFIDENCE_LEVEL_IDENTIFIER.name, new ArrayList<ConfidenceLevel>(Arrays.asList(ConfidenceLevel.values())));
        this.addOpenMetadataEnumValidIdentifiers(OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, OpenMetadataProperty.CONFIDENTIALITY_LEVEL_IDENTIFIER.name, new ArrayList<ConfidentialityLevel>(Arrays.asList(ConfidentialityLevel.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.CONTACT_DETAILS.typeName, OpenMetadataProperty.CONTACT_METHOD_TYPE.name, ContactMethodType.getOpenTypeName(), new ArrayList<ContactMethodType>(Arrays.asList(ContactMethodType.values())));
        this.addOpenMetadataEnumValidIdentifiers(OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, OpenMetadataProperty.CRITICALITY_LEVEL_IDENTIFIER.name, new ArrayList<CriticalityLevel>(Arrays.asList(CriticalityLevel.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.DATA_CLASS_ASSIGNMENT.typeName, OpenMetadataProperty.DATA_CLASS_ASSIGNMENT_STATUS.name, DataClassAssignmentStatus.getOpenTypeName(), new ArrayList<DataClassAssignmentStatus>(Arrays.asList(DataClassAssignmentStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, OpenMetadataProperty.SORT_ORDER.name, DataItemSortOrder.getOpenTypeName(), new ArrayList<DataItemSortOrder>(Arrays.asList(DataItemSortOrder.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.DATA_FIELD.typeName, OpenMetadataProperty.DATA_FIELD_SORT_ORDER.name, DataItemSortOrder.getOpenTypeName(), new ArrayList<DataItemSortOrder>(Arrays.asList(DataItemSortOrder.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.ENGINE_ACTION.typeName, OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeName(), new ArrayList<EngineActionStatus>(Arrays.asList(EngineActionStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.TARGET_FOR_ACTION.typeName, OpenMetadataProperty.ACTION_STATUS.name, EngineActionStatus.getOpenTypeName(), new ArrayList<EngineActionStatus>(Arrays.asList(EngineActionStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeName, OpenMetadataProperty.ACTIVITY_TYPE.name, GlossaryTermActivityType.getOpenTypeName(), new ArrayList<GlossaryTermActivityType>(Arrays.asList(GlossaryTermActivityType.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.SEMANTIC_ASSIGNMENT.typeName, OpenMetadataProperty.TERM_ASSIGNMENT_STATUS.name, GlossaryTermAssignmentStatus.getOpenTypeName(), new ArrayList<GlossaryTermAssignmentStatus>(Arrays.asList(GlossaryTermAssignmentStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.TERM_CATEGORIZATION.typeName, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeName(), new ArrayList<GlossaryTermRelationshipStatus>(Arrays.asList(GlossaryTermRelationshipStatus.values())));
        this.addOpenMetadataEnumValidNames("RelatedTerm", OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeName(), new ArrayList<GlossaryTermRelationshipStatus>(Arrays.asList(GlossaryTermRelationshipStatus.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.USED_IN_CONTEXT.typeName, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, GlossaryTermRelationshipStatus.getOpenTypeName(), new ArrayList<GlossaryTermRelationshipStatus>(Arrays.asList(GlossaryTermRelationshipStatus.values())));
        this.addOpenMetadataEnumValidIdentifiers(null, OpenMetadataProperty.STATUS_IDENTIFIER.name, new ArrayList<GovernanceClassificationStatus>(Arrays.asList(GovernanceClassificationStatus.values())));
        this.addOpenMetadataEnumValidIdentifiers(null, OpenMetadataProperty.SEVERITY_IDENTIFIER.name, new ArrayList<ImpactSeverity>(Arrays.asList(ImpactSeverity.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.INCIDENT_REPORT.typeName, OpenMetadataProperty.INCIDENT_STATUS.name, IncidentReportStatus.getOpenTypeName(), new ArrayList<IncidentReportStatus>(Arrays.asList(IncidentReportStatus.values())));
        this.addOpenMetadataEnumValidIdentifiers(OpenMetadataType.RETENTION_CLASSIFICATION.typeName, OpenMetadataProperty.RETENTION_BASIS_IDENTIFIER.name, new ArrayList<RetentionBasis>(Arrays.asList(RetentionBasis.values())));
        this.addOpenMetadataEnumValidNames(OpenMetadataType.TO_DO.typeName, OpenMetadataProperty.TO_DO_STATUS.name, ToDoStatus.getOpenTypeName(), new ArrayList<ToDoStatus>(Arrays.asList(ToDoStatus.values())));
        this.addOpenMetadataEnumValidNames("Rating", "stars", StarRating.getOpenTypeName(), new ArrayList<StarRating>(Arrays.asList(StarRating.values())));
        for (CollectionType collectionType : DeployedImplementationType.values()) {
            String guid3 = this.addDeployedImplementationType(collectionType.getDeployedImplementationType(), collectionType.getAssociatedTypeName(), collectionType.getQualifiedName(), collectionType.getCategory(), collectionType.getDescription(), collectionType.getWikiLink());
            this.deployedImplementationTypeGUIDs.put(collectionType.getDeployedImplementationType(), guid3);
        }
        HashMap<String, String> serverTypeGUIDs = new HashMap<String, String>();
        HashMap<String, String> serviceGUIDs = new HashMap<String, String>();
        for (ServerTypeClassification serverTypeClassification : ServerTypeClassification.values()) {
            String guid22 = this.addDeployedImplementationType(serverTypeClassification.getServerTypeName(), OpenMetadataType.SOFTWARE_SERVER.typeName, serverTypeClassification.getServerTypeDescription(), serverTypeClassification.getServerTypeWiki());
            serverTypeGUIDs.put(serverTypeClassification.getServerTypeName(), guid22);
        }
        for (ServerTypeClassification serverTypeClassification : CommonServicesDescription.values()) {
            guid2 = this.addDeployedImplementationType(serverTypeClassification.getServiceName(), "SoftwareService", serverTypeClassification.getServiceDescription(), serverTypeClassification.getServiceWiki());
            serviceGUIDs.put(serverTypeClassification.getServiceName(), guid2);
        }
        for (ServerTypeClassification serverTypeClassification : GovernanceServicesDescription.values()) {
            guid2 = this.addDeployedImplementationType(serverTypeClassification.getServiceName(), "SoftwareService", serverTypeClassification.getServiceDescription(), serverTypeClassification.getServiceWiki());
            serviceGUIDs.put(serverTypeClassification.getServiceName(), guid2);
        }
        String serverTypeGUID = (String)serverTypeGUIDs.get(ServerTypeClassification.METADATA_ACCESS_SERVER.getServerTypeName());
        String string2 = (String)serverTypeGUIDs.get(ServerTypeClassification.METADATA_ACCESS_STORE.getServerTypeName());
        for (AccessServiceDescription accessServiceDescription : AccessServiceDescription.values()) {
            guid = this.addDeployedImplementationType(accessServiceDescription.getAccessServiceFullName(), "SoftwareService", accessServiceDescription.getAccessServiceDescription(), accessServiceDescription.getAccessServiceWiki());
            serviceGUIDs.put(accessServiceDescription.getAccessServiceFullName(), guid);
            this.archiveHelper.addResourceListRelationshipByGUID(serverTypeGUID, guid, ResourceUse.HOSTED_SERVICE.getResourceUse(), ResourceUse.HOSTED_SERVICE.getDescription());
            this.archiveHelper.addResourceListRelationshipByGUID(string2, guid, ResourceUse.HOSTED_SERVICE.getResourceUse(), ResourceUse.HOSTED_SERVICE.getDescription());
        }
        serverTypeGUID = (String)serverTypeGUIDs.get(ServerTypeClassification.VIEW_SERVER.getServerTypeName());
        for (AccessServiceDescription accessServiceDescription : ViewServiceDescription.values()) {
            guid = this.addDeployedImplementationType(accessServiceDescription.getViewServiceFullName(), "SoftwareService", accessServiceDescription.getViewServiceDescription(), accessServiceDescription.getViewServiceWiki());
            this.archiveHelper.addResourceListRelationshipByGUID(serverTypeGUID, guid, ResourceUse.HOSTED_SERVICE.getResourceUse(), ResourceUse.HOSTED_SERVICE.getDescription());
            this.archiveHelper.addResourceListRelationshipByGUID(guid, (String)serviceGUIDs.get(accessServiceDescription.getViewServicePartnerService()), ResourceUse.CALLED_SERVICE.getResourceUse(), ResourceUse.CALLED_SERVICE.getDescription());
        }
        serverTypeGUID = (String)serverTypeGUIDs.get(ServerTypeClassification.ENGINE_HOST.getServerTypeName());
        for (AccessServiceDescription accessServiceDescription : EngineServiceDescription.values()) {
            guid = this.addDeployedImplementationType(accessServiceDescription.getEngineServiceFullName(), "SoftwareService", accessServiceDescription.getEngineServiceDescription(), accessServiceDescription.getEngineServiceWiki());
            this.archiveHelper.addResourceListRelationshipByGUID(serverTypeGUID, guid, ResourceUse.HOSTED_SERVICE.getResourceUse(), ResourceUse.HOSTED_SERVICE.getDescription());
            this.archiveHelper.addResourceListRelationshipByGUID(guid, (String)serviceGUIDs.get(accessServiceDescription.getEngineServicePartnerService()), ResourceUse.CALLED_SERVICE.getResourceUse(), ResourceUse.CALLED_SERVICE.getDescription());
            String governanceEngineGUID = this.deployedImplementationTypeGUIDs.get(accessServiceDescription.getHostedGovernanceEngineDeployedImplementationType());
            String governanceServiceGUID = this.deployedImplementationTypeGUIDs.get(accessServiceDescription.getHostedGovernanceServiceDeployedImplementationType());
            if (governanceEngineGUID == null) continue;
            this.archiveHelper.addResourceListRelationshipByGUID(guid, governanceEngineGUID, ResourceUse.HOSTED_GOVERNANCE_ENGINE.getResourceUse(), ResourceUse.HOSTED_GOVERNANCE_ENGINE.getDescription());
            if (governanceServiceGUID == null) continue;
            this.archiveHelper.addResourceListRelationshipByGUID(governanceEngineGUID, governanceServiceGUID, ResourceUse.HOSTED_CONNECTOR.getResourceUse(), ResourceUse.HOSTED_CONNECTOR.getDescription());
        }
        for (AccessServiceDescription accessServiceDescription : IntegrationServiceDescription.values()) {
            guid = this.addDeployedImplementationType(accessServiceDescription.getIntegrationServiceFullName(), "SoftwareService", accessServiceDescription.getIntegrationServiceDescription(), accessServiceDescription.getIntegrationServiceWiki());
            this.archiveHelper.addResourceListRelationshipByGUID(serverTypeGUID, guid, ResourceUse.HOSTED_SERVICE.getResourceUse(), ResourceUse.HOSTED_SERVICE.getDescription());
            this.archiveHelper.addResourceListRelationshipByGUID(guid, (String)serviceGUIDs.get(accessServiceDescription.getIntegrationServicePartnerOMAS().getAccessServiceFullName()), ResourceUse.CALLED_SERVICE.getResourceUse(), ResourceUse.CALLED_SERVICE.getDescription());
            String connectorTypeGUID = this.deployedImplementationTypeGUIDs.get(accessServiceDescription.getConnectorDeployedImplementationType());
            if (connectorTypeGUID == null) continue;
            this.archiveHelper.addResourceListRelationshipByGUID(guid, connectorTypeGUID, ResourceUse.HOSTED_CONNECTOR.getResourceUse(), ResourceUse.HOSTED_CONNECTOR.getDescription());
        }
        for (AccessServiceDescription accessServiceDescription : FileType.values()) {
            this.addFileType(accessServiceDescription.getFileTypeName(), accessServiceDescription.getEncoding(), accessServiceDescription.getAssetSubTypeName(), accessServiceDescription.getDeployedImplementationType(), accessServiceDescription.getDescription());
        }
        for (AccessServiceDescription accessServiceDescription : FileName.values()) {
            this.addFileName(accessServiceDescription.getFileName(), accessServiceDescription.getFileType(), accessServiceDescription.getFileType().getDeployedImplementationType());
        }
        for (AccessServiceDescription accessServiceDescription : FileExtension.values()) {
            this.addFileExtension(accessServiceDescription.getFileExtension(), accessServiceDescription.getFileTypes());
        }
        for (AccessServiceDescription accessServiceDescription : SpecificationPropertyType.values()) {
            this.addAttributeName(accessServiceDescription.getPropertyType(), accessServiceDescription.getDescription());
        }
        this.archiveHelper.addConnectorType(fileConnectorCategoryGUID, (ConnectorProvider)new CSVFileStoreProvider());
        this.archiveHelper.addConnectorType(fileConnectorCategoryGUID, (ConnectorProvider)new DataFolderProvider());
        this.archiveHelper.addConnectorType(fileConnectorCategoryGUID, (ConnectorProvider)new BasicFileStoreProvider());
        this.archiveHelper.addConnectorType(fileConnectorCategoryGUID, (ConnectorProvider)new BasicFolderProvider());
        this.archiveHelper.addConnectorType(relationalConnectorCategoryGUID, (ConnectorProvider)new JDBCResourceConnectorProvider());
        this.archiveHelper.addConnectorType(kafkaConnectorCategoryGUID, (ConnectorProvider)new KafkaOpenMetadataTopicProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new ApacheAtlasRESTProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new ApacheAtlasIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new EgeriaCataloguerIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new CSVLineageImporterProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new DataFilesMonitorIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new DataFolderMonitorIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new JDBCIntegrationConnectorProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new DistributeAuditEventsFromKafkaProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new KafkaMonitorIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new OpenAPIMonitorIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new APIBasedOpenLineageLogStoreProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new FileBasedOpenLineageLogStoreProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new GovernanceActionOpenLineageIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new OpenLineageCataloguerIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new OpenLineageEventReceiverIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new EnvVarSecretsStoreProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new PostgresServerIntegrationProvider());
        this.archiveHelper.addConnectorType(null, (ConnectorProvider)new ApacheKafkaAdminProvider());
        this.archiveHelper.addConnectorType(null, (IntegrationConnectorProvider)new KafkaTopicIntegrationProvider());
        String integrationGroupGUID = this.archiveHelper.addIntegrationGroup("Egeria:IntegrationGroup:DefaultIntegrationGroup", "DefaultIntegrationGroup", "Dynamic integration group to use with an Integration Daemon configuration.", null, null, archiveFileName, null, null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("waitForDirectory", "true");
        String filesIntegrationConnectorGUID = this.archiveHelper.addIntegrationConnector(DataFilesMonitorIntegrationProvider.class.getName(), hashMap, "Egeria:IntegrationGroup:DefaultIntegrationGroup:DataFilesMonitorIntegrationConnector", "DataFilesMonitorIntegrationConnector", "Catalogs files found under the starting directory (folder).", "sample-data", null);
        this.archiveHelper.addRegisteredIntegrationConnector(integrationGroupGUID, "FilesCataloguer", "filecatnpa", null, 60L, filesIntegrationConnectorGUID);
        String string3 = this.archiveHelper.getGUID(DeployedImplementationType.FILE_FOLDER.getQualifiedName());
        this.archiveHelper.addResourceListRelationshipByGUID(string3, filesIntegrationConnectorGUID, ResourceUse.CATALOG_RESOURCE.getResourceUse(), ResourceUse.CATALOG_RESOURCE.getDescription());
        String databaseIntegrationConnectorGUID = this.archiveHelper.addIntegrationConnector(JDBCIntegrationConnectorProvider.class.getName(), null, "Egeria:IntegrationGroup:DefaultIntegrationGroup:JDBCIntegrationConnector", "JDBCIntegrationConnector", "Catalogs JDBC database schemas, tables and columns.", null, null);
        String string4 = this.archiveHelper.getGUID(DeployedImplementationType.JDBC_RELATIONAL_DATABASE.getQualifiedName());
        this.archiveHelper.addResourceListRelationshipByGUID(string4, databaseIntegrationConnectorGUID, ResourceUse.CATALOG_RESOURCE.getResourceUse(), ResourceUse.CATALOG_RESOURCE.getDescription());
        String string5 = this.archiveHelper.getGUID(DeployedImplementationType.POSTGRESQL_DATABASE.getQualifiedName());
        this.archiveHelper.addResourceListRelationshipByGUID(string5, databaseIntegrationConnectorGUID, ResourceUse.CATALOG_RESOURCE.getResourceUse(), ResourceUse.CATALOG_RESOURCE.getDescription());
        this.archiveHelper.addRegisteredIntegrationConnector(integrationGroupGUID, "JDBCDatabaseCataloguer", "dbcatnpa", null, 60L, databaseIntegrationConnectorGUID);
        String postgresIntegrationConnectorGUID = this.archiveHelper.addIntegrationConnector(PostgresServerIntegrationProvider.class.getName(), null, "Egeria:IntegrationGroup:DefaultIntegrationGroup:PostgreSQLServerIntegrationConnector", "PostgreSQLServerIntegrationConnector", "Catalogs PostgreSQL Databases in a PostgreSQL Server.", null, null);
        String string6 = this.archiveHelper.getGUID(DeployedImplementationType.POSTGRESQL_SERVER.getQualifiedName());
        this.archiveHelper.addResourceListRelationshipByGUID(string6, postgresIntegrationConnectorGUID, ResourceUse.CATALOG_RESOURCE.getResourceUse(), ResourceUse.CATALOG_RESOURCE.getDescription());
        this.archiveHelper.addRegisteredIntegrationConnector(integrationGroupGUID, "PostgreSQLServerCataloguer", "postgrescatnpa", null, 60L, postgresIntegrationConnectorGUID);
        String kafkaIntegrationConnectorGUID = this.archiveHelper.addIntegrationConnector(KafkaTopicIntegrationProvider.class.getName(), null, "Egeria:IntegrationGroup:DefaultIntegrationGroup:KafkaTopicIntegrationConnector", "KafkaTopicIntegrationConnector", "Catalogs Apache Kafka Topics.", null, null);
        String string7 = this.archiveHelper.getGUID(DeployedImplementationType.APACHE_KAFKA_SERVER.getQualifiedName());
        this.archiveHelper.addResourceListRelationshipByGUID(string7, kafkaIntegrationConnectorGUID, ResourceUse.CATALOG_RESOURCE.getResourceUse(), ResourceUse.CATALOG_RESOURCE.getDescription());
        this.archiveHelper.addRegisteredIntegrationConnector(integrationGroupGUID, "ApacheKafkaCataloguer", "kafkacatnpa", null, 60L, kafkaIntegrationConnectorGUID);
        String apiIntegrationConnectorGUID = this.archiveHelper.addIntegrationConnector(OpenAPIMonitorIntegrationProvider.class.getName(), null, "Egeria:IntegrationGroup:DefaultIntegrationGroup:OpenAPIIntegrationConnector", "OpenAPIIntegrationConnector", "Catalogs REST APIs through the Open API Specification.", null, null);
        this.archiveHelper.addRegisteredIntegrationConnector(integrationGroupGUID, "OpenAPICataloguer", "apicatnpa", null, 60L, apiIntegrationConnectorGUID);
        GovernanceActionDescription fileProvisionerDescription = this.getFileProvisioningGovernanceActionService();
        GovernanceActionDescription watchDogServiceDescription = this.getWatchdogGovernanceActionService();
        GovernanceActionDescription originSeekerDescription = this.getOriginSeekerGovernanceActionService();
        GovernanceActionDescription qualifiedNameDeDupDescription = this.getQualifiedNameDeDupGovernanceActionService();
        GovernanceActionDescription zonePublisherDescription = this.getZonePublisherGovernanceActionService();
        GovernanceActionDescription evaluateAnnotationsDescription = this.getEvaluateAnnotationsGovernanceActionService();
        GovernanceActionDescription writeAuditLogDescription = this.getWriteAuditLogGovernanceActionService();
        GovernanceActionDescription dayOfWeekDescription = this.getDayOfWeekGovernanceActionService();
        GovernanceActionDescription verifyAssetDescription = this.getVerifyAssetGovernanceActionService();
        GovernanceActionDescription csvSurveyDescription = this.getCSVFileSurveyService();
        GovernanceActionDescription fileSurveyDescription = this.getDataFileSurveyService();
        GovernanceActionDescription folderSurveyDescription = this.getFolderSurveyService();
        GovernanceActionDescription atlasSurveyDescription = this.getAtlasSurveyService();
        GovernanceActionDescription postgresServerSurveyDescription = this.getPostgresServerSurveyService();
        GovernanceActionDescription postgresDatabaseSurveyDescription = this.getPostgresDatabaseSurveyService();
        GovernanceActionDescription kafkaServerSurveyDescription = this.getKafkaServerSurveyService();
        String fileProvisioningEngineName = "FileProvisioning";
        String fileProvisioningEngineGUID = this.getFileProvisioningEngine(fileProvisioningEngineName);
        this.addCopyFileRequestType(fileProvisioningEngineGUID, fileProvisioningEngineName, fileProvisionerDescription);
        this.addMoveFileRequestType(fileProvisioningEngineGUID, fileProvisioningEngineName, fileProvisionerDescription);
        this.addDeleteFileRequestType(fileProvisioningEngineGUID, fileProvisioningEngineName, fileProvisionerDescription);
        String assetOnboardingEngineName = "AssetOnboarding";
        String assetOnboardingEngineGUID = this.getAssetOnboardingEngine(assetOnboardingEngineName);
        this.addWatchNestedInFolderRequestType(assetOnboardingEngineGUID, assetOnboardingEngineName, watchDogServiceDescription);
        this.addSeekOriginRequestType(assetOnboardingEngineGUID, assetOnboardingEngineName, originSeekerDescription);
        this.addSetZoneMembershipRequestType(assetOnboardingEngineGUID, assetOnboardingEngineName, zonePublisherDescription);
        this.addVerifyAssetRequestType(assetOnboardingEngineGUID, assetOnboardingEngineName, verifyAssetDescription);
        String stewardshipEngineName = "Stewardship";
        String stewardshipEngineGUID = this.getStewardshipEngine(stewardshipEngineName);
        this.addEvaluateAnnotationsRequestType(stewardshipEngineGUID, stewardshipEngineName, evaluateAnnotationsDescription);
        this.addWriteAuditLogRequestType(stewardshipEngineGUID, stewardshipEngineName, writeAuditLogDescription);
        this.addDayOfWeekRequestType(stewardshipEngineGUID, stewardshipEngineName, dayOfWeekDescription);
        this.addQualifiedNameDeDupRequestType(stewardshipEngineGUID, stewardshipEngineName, qualifiedNameDeDupDescription);
        this.createDailyGovernanceActionProcess(stewardshipEngineGUID);
        String assetSurveyEngineName = "AssetSurvey";
        String assetSurveyEngineGUID = this.getAssetSurveyEngine(assetSurveyEngineName);
        this.addCSVFileRequestType(assetSurveyEngineGUID, assetSurveyEngineName, csvSurveyDescription);
        this.addDataFileRequestType(assetSurveyEngineGUID, assetSurveyEngineName, fileSurveyDescription);
        this.addFolderRequestType(assetSurveyEngineGUID, assetSurveyEngineName, folderSurveyDescription);
        this.addAtlasRequestType(assetSurveyEngineGUID, assetSurveyEngineName, atlasSurveyDescription);
        this.addPostgresServerRequestType(assetSurveyEngineGUID, assetSurveyEngineName, postgresServerSurveyDescription);
        this.addPostgresDatabaseRequestType(assetSurveyEngineGUID, assetSurveyEngineName, postgresDatabaseSurveyDescription);
        this.addKafkaServerRequestType(assetSurveyEngineGUID, assetSurveyEngineName, kafkaServerSurveyDescription);
        this.addFileTemplates();
        this.addPostgresServerCatalogTemplate();
        this.addPostgresDatabaseCatalogTemplate();
        this.addPostgresDatabaseSchemaCatalogTemplate();
        this.addAtlasServerCatalogTemplate();
        this.addKafkaServerCatalogTemplate();
        this.addKafkaTopicCatalogTemplate();
        this.addMacBookProCatalogTemplate();
        this.addFileSystemTemplate();
        this.addUNIXFileSystemTemplate();
        this.archiveHelper.saveUsedGUIDs();
        return this.archiveBuilder.getOpenMetadataArchive();
    }

    private void addOpenMetadataEnumValidNames(String enumConsumingTypeName, String enumConsumingProperty, String enumTypeName, List<OpenMetadataEnum> openMetadataEnums) {
        String parentSetGUID = this.getParentSet(null, enumConsumingTypeName, enumConsumingProperty, null);
        for (OpenMetadataEnum enumValue : openMetadataEnums) {
            String enumPreferredValue = enumValue.getName().toUpperCase();
            this.archiveHelper.addValidValue(enumValue.getDescriptionGUID(), parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataValidValues.constructValidValueQualifiedName((String)enumConsumingTypeName, (String)enumConsumingProperty, null, (String)enumPreferredValue), enumValue.getName(), enumValue.getDescription(), OpenMetadataValidValues.constructValidValueCategory((String)enumConsumingTypeName, (String)enumConsumingProperty, null), "Used to control valid values in open metadata.", enumTypeName, "Open Metadata Ecosystem", enumPreferredValue, false, false, null);
        }
    }

    private void addOpenMetadataEnumValidIdentifiers(String enumConsumingTypeName, String enumConsumingProperty, List<OpenMetadataEnum> openMetadataEnums) {
        String parentSetGUID = this.getParentSet(null, enumConsumingTypeName, enumConsumingProperty, null);
        for (OpenMetadataEnum enumValue : openMetadataEnums) {
            String enumPreferredValue = Integer.toString(enumValue.getOrdinal());
            this.archiveHelper.addValidValue(enumValue.getDescriptionGUID(), parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataValidValues.constructValidValueQualifiedName((String)enumConsumingTypeName, (String)enumConsumingProperty, null, (String)enumPreferredValue), enumValue.getName(), enumValue.getDescription(), OpenMetadataValidValues.constructValidValueCategory((String)enumConsumingTypeName, (String)enumConsumingProperty, null), "Used to control valid values in open metadata.", "int", "Open Metadata Ecosystem", enumPreferredValue, false, false, null);
        }
    }

    private void addFileTemplates() {
        String basicFileConnectorTypeGUID = new BasicFileStoreProvider().getConnectorType().getGUID();
        this.createFolderCatalogTemplate(DeployedImplementationType.FILE_FOLDER, new BasicFolderProvider().getConnectorType().getGUID());
        this.createFolderCatalogTemplate(DeployedImplementationType.DATA_FOLDER, new DataFolderProvider().getConnectorType().getGUID());
        this.createDataFileCatalogTemplate(DeployedImplementationType.FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.CSV_FILE, new CSVFileStoreProvider().getConnectorType().getGUID(), null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.AVRO_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.JSON_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.PARQUET_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.SPREADSHEET_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.XML_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.DOCUMENT, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.AUDIO_DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.VIDEO_DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.THREE_D_IMAGE_DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.RASTER_DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.VECTOR_DATA_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.ARCHIVE_FILE, basicFileConnectorTypeGUID, null);
        this.createDataFileCatalogTemplate(DeployedImplementationType.KEYSTORE_FILE, basicFileConnectorTypeGUID, null);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.PROGRAM_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.SOURCE_CODE_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.BUILD_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.EXECUTABLE_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.SCRIPT_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.PROPERTIES_FILE, basicFileConnectorTypeGUID);
        this.createSoftwareFileCatalogTemplate(DeployedImplementationType.YAML_FILE, basicFileConnectorTypeGUID);
    }

    private void createDataFileCatalogTemplate(DeployedImplementationType deployedImplementationType, String connectorTypeGUID, Map<String, Object> configurationProperties) {
        String methodName = "createDataFileCatalogTemplate";
        String qualifiedName = FilesPlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder() + ":" + deployedImplementationType.getDeployedImplementationType() + ":" + FilesPlaceholderProperty.PATH_NAME.getPlaceholder();
        String versionIdentifier = "V1.0";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, FilesPlaceholderProperty.DEPLOYED_IMPLEMENTATION_TYPE.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, FilesPlaceholderProperty.PATH_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_TYPE.name, FilesPlaceholderProperty.FILE_TYPE.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_EXTENSION.name, FilesPlaceholderProperty.FILE_EXTENSION.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_NAME.name, FilesPlaceholderProperty.FILE_NAME.getPlaceholder());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create an asset of type " + deployedImplementationType.getAssociatedTypeName() + " with an associated Connection.", "V1.0", null, "createDataFileCatalogTemplate"));
        classifications.add(this.archiveHelper.getDataStoreEncodingClassification(FilesPlaceholderProperty.FILE_ENCODING.getPlaceholder(), null, null, null));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, FilesPlaceholderProperty.FILE_NAME.getPlaceholder(), versionIdentifier, null, null, extendedProperties, classifications);
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", FilesPlaceholderProperty.PATH_NAME.getPlaceholder() + " endpoint", null, FilesPlaceholderProperty.PATH_NAME.getPlaceholder(), null, null);
        String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", FilesPlaceholderProperty.PATH_NAME.getPlaceholder() + " connection", null, null, null, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, FilesPlaceholderProperty.getDataFilesPlaceholderPropertyTypes());
    }

    private void createFolderCatalogTemplate(DeployedImplementationType deployedImplementationType, String connectorTypeGUID) {
        String methodName = "createFolderCatalogTemplate";
        String qualifiedName = FilesPlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder() + ":" + deployedImplementationType.getDeployedImplementationType() + ":" + FilesPlaceholderProperty.PATH_NAME.getPlaceholder();
        String versionIdentifier = "V1.0";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, FilesPlaceholderProperty.DEPLOYED_IMPLEMENTATION_TYPE.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, FilesPlaceholderProperty.PATH_NAME.getPlaceholder());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create an asset of type " + deployedImplementationType.getAssociatedTypeName() + " with an associated Connection.", "V1.0", null, "createFolderCatalogTemplate"));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, FilesPlaceholderProperty.FOLDER_NAME.getPlaceholder(), versionIdentifier, null, null, extendedProperties, classifications);
        if (connectorTypeGUID != null) {
            String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", FilesPlaceholderProperty.PATH_NAME + " endpoint", null, FilesPlaceholderProperty.PATH_NAME.getPlaceholder(), null, null);
            String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", FilesPlaceholderProperty.PATH_NAME.getPlaceholder() + " connection", null, null, null, null, null, null, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        }
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, FilesPlaceholderProperty.getFolderPlaceholderPropertyTypes());
    }

    private void createDataSetCatalogTemplate(DeployedImplementationType deployedImplementationType, String connectorTypeGUID) {
        String methodName = "createDataSetCatalogTemplate";
        String qualifiedName = FilesPlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder() + ":" + deployedImplementationType.getDeployedImplementationType() + ":" + FilesPlaceholderProperty.DATA_SET_NAME.getPlaceholder();
        String versionIdentifier = "V1.0";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, FilesPlaceholderProperty.DEPLOYED_IMPLEMENTATION_TYPE.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FORMULA.name, FilesPlaceholderProperty.FORMULA.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FORMULA_TYPE.name, FilesPlaceholderProperty.FORMULA_TYPE.getPlaceholder());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create an asset of type " + deployedImplementationType.getAssociatedTypeName() + " with an associated Connection.", "V1.0", null, "createDataSetCatalogTemplate"));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, FilesPlaceholderProperty.DATA_SET_NAME.getPlaceholder(), versionIdentifier, null, null, extendedProperties, classifications);
        if (connectorTypeGUID != null) {
            String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", FilesPlaceholderProperty.DATA_SET_NAME.getPlaceholder() + " connection", null, null, null, null, null, null, null, connectorTypeGUID, null, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        }
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, FilesPlaceholderProperty.getDataSetPlaceholderPropertyTypes());
    }

    private void createSoftwareFileCatalogTemplate(DeployedImplementationType deployedImplementationType, String connectorTypeGUID) {
        String methodName = "createSoftwareFileCatalogTemplate";
        String qualifiedName = FilesPlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder() + ":" + deployedImplementationType.getDeployedImplementationType() + ":" + FilesPlaceholderProperty.PATH_NAME.getPlaceholder();
        String versionIdentifier = "V1.0";
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, FilesPlaceholderProperty.DEPLOYED_IMPLEMENTATION_TYPE.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.PATH_NAME.name, FilesPlaceholderProperty.PATH_NAME.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_TYPE.name, FilesPlaceholderProperty.FILE_TYPE.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_EXTENSION.name, FilesPlaceholderProperty.FILE_EXTENSION.getPlaceholder());
        extendedProperties.put(OpenMetadataProperty.FILE_NAME.name, FilesPlaceholderProperty.FILE_NAME.getPlaceholder());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create an asset of type " + deployedImplementationType.getAssociatedTypeName() + " with an associated Connection.", "V1.0", null, "createSoftwareFileCatalogTemplate"));
        classifications.add(this.archiveHelper.getDataStoreEncodingClassification(FilesPlaceholderProperty.FILE_ENCODING.getPlaceholder(), FilesPlaceholderProperty.PROGRAMMING_LANGUAGE.getPlaceholder(), null, null));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, FilesPlaceholderProperty.FILE_NAME.getPlaceholder(), versionIdentifier, FilesPlaceholderProperty.DESCRIPTION.getPlaceholder(), null, extendedProperties, classifications);
        if (connectorTypeGUID != null) {
            String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", FilesPlaceholderProperty.PATH_NAME.getPlaceholder() + " endpoint", null, FilesPlaceholderProperty.PATH_NAME.getPlaceholder(), null, null);
            String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", FilesPlaceholderProperty.PATH_NAME.getPlaceholder() + " connection", null, null, null, null, null, null, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        }
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, FilesPlaceholderProperty.getSoftwareFilesPlaceholderPropertyTypes());
    }

    private void createSoftwareServerCatalogTemplate(DeployedImplementationType deployedImplementationType, DeployedImplementationType softwareCapabilityType, String softwareCapabilityName, Classification softwareCapabilityClassification, String serverName, String userId, String password, String connectorTypeGUID, String networkAddress, Map<String, Object> configurationProperties, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        String methodName = "createSoftwareServerCatalogTemplate";
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + serverName;
        String versionIdentifier = "V1.0";
        String description = deployedImplementationType.getDescription();
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create a " + deployedImplementationType.getDeployedImplementationType() + " SoftwareServer with an associated SoftwareCapability and Connection.", "V1.0", null, "createSoftwareServerCatalogTemplate"));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, serverName, versionIdentifier, description, null, extendedProperties, classifications);
        this.archiveHelper.addSoftwareCapability(softwareCapabilityType.getAssociatedTypeName(), qualifiedName + ":" + softwareCapabilityName, softwareCapabilityName, null, softwareCapabilityType.getDeployedImplementationType(), null, null, null, null, null, softwareCapabilityClassification, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addSupportedSoftwareCapabilityRelationship(qualifiedName + ":" + softwareCapabilityName, qualifiedName, null, null, null, null, 1);
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", serverName + " endpoint", null, networkAddress, null, null);
        String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", serverName + " connection", null, userId, password, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addReplacementAttributes(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, replacementAttributeTypes);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, placeholderPropertyTypes);
    }

    private void addPostgresServerCatalogTemplate() {
        JDBCResourceConnectorProvider provider = new JDBCResourceConnectorProvider();
        List placeholderPropertyTypes = PostgresPlaceholderProperty.getPostgresServerPlaceholderPropertyTypes();
        this.createSoftwareServerCatalogTemplate(DeployedImplementationType.POSTGRESQL_SERVER, DeployedImplementationType.POSTGRESQL_DATABASE_MANAGER, "DBMS", null, PostgresPlaceholderProperty.SERVER_NAME.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_USER_ID.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_PASSWORD.getPlaceholder(), provider.getConnectorType().getGUID(), "jdbc:postgresql://" + PostgresPlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PostgresPlaceholderProperty.PORT_NUMBER.getPlaceholder() + "/postgres", null, null, placeholderPropertyTypes);
    }

    private void addAtlasServerCatalogTemplate() {
        ApacheAtlasRESTProvider provider = new ApacheAtlasRESTProvider();
        List placeholderPropertyTypes = AtlasPlaceholderProperty.getPlaceholderPropertyTypes();
        this.createSoftwareServerCatalogTemplate(DeployedImplementationType.APACHE_ATLAS_SERVER, DeployedImplementationType.ASSET_CATALOG, "MetadataCatalog", null, AtlasPlaceholderProperty.SERVER_NAME.getPlaceholder(), AtlasPlaceholderProperty.CONNECTION_USER_ID.getPlaceholder(), AtlasPlaceholderProperty.CONNECTION_PASSWORD.getPlaceholder(), provider.getConnectorType().getGUID(), "http://" + AtlasPlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + AtlasPlaceholderProperty.PORT_NUMBER.getPlaceholder(), null, null, placeholderPropertyTypes);
    }

    private void addKafkaServerCatalogTemplate() {
        ApacheKafkaAdminProvider provider = new ApacheKafkaAdminProvider();
        List placeholderPropertyTypes = KafkaPlaceholderProperty.getKafkaServerPlaceholderPropertyTypes();
        this.createSoftwareServerCatalogTemplate(DeployedImplementationType.APACHE_KAFKA_SERVER, DeployedImplementationType.APACHE_KAFKA_EVENT_BROKER, OpenMetadataType.EVENT_BROKER.typeName, null, KafkaPlaceholderProperty.SERVER_NAME.getPlaceholder(), null, null, provider.getConnectorType().getGUID(), "http://" + KafkaPlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + KafkaPlaceholderProperty.PORT_NUMBER.getPlaceholder(), null, null, placeholderPropertyTypes);
    }

    private void createHostCatalogTemplate(DeployedImplementationType deployedImplementationType, DeployedImplementationType softwareCapabilityType, String softwareCapabilityName, Classification softwareCapabilityClassification) {
        String methodName = "createHostCatalogTemplate";
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + HostPlaceholderProperty.HOST_IDENTIFIER.getPlaceholder();
        String description = deployedImplementationType.getDescription();
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", "Create a " + deployedImplementationType.getDeployedImplementationType() + " Host with an associated SoftwareCapability.", "V1.0", null, "createHostCatalogTemplate"));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, HostPlaceholderProperty.HOST_NAME.getPlaceholder(), HostPlaceholderProperty.VERSION_IDENTIFIER.getPlaceholder(), description, null, extendedProperties, classifications);
        if (softwareCapabilityType != null) {
            this.archiveHelper.addSoftwareCapability(softwareCapabilityType.getAssociatedTypeName(), qualifiedName + ":" + softwareCapabilityName, softwareCapabilityName, null, softwareCapabilityType.getDeployedImplementationType(), null, null, null, null, null, softwareCapabilityClassification, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
            this.archiveHelper.addSupportedSoftwareCapabilityRelationship(qualifiedName + ":" + softwareCapabilityName, qualifiedName, null, null, null, null, 1);
        }
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, HostPlaceholderProperty.getPlaceholderPropertyTypes());
    }

    private void addMacBookProCatalogTemplate() {
        String methodName = "addMacBookProCatalogTemplate";
        Classification classification = this.archiveHelper.getFileSystemClassification("APFS", "Enabled", "addMacBookProCatalogTemplate");
        this.createHostCatalogTemplate(DeployedImplementationType.MACBOOK_PRO, DeployedImplementationType.UNIX_FILE_SYSTEM, "Local File System", classification);
    }

    private void createSoftwareCapabilityCatalogTemplate(DeployedImplementationType deployedImplementationType, String softwareCapabilityName, Classification softwareCapabilityClassification, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        String qualifiedName = deployedImplementationType.getDeployedImplementationType() + ":" + softwareCapabilityName;
        String versionIdentifier = "V1.0";
        String description = deployedImplementationType.getDescription();
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        String capabilityGUID = this.archiveHelper.addSoftwareCapability(deployedImplementationType.getAssociatedTypeName(), qualifiedName + ":" + softwareCapabilityName, softwareCapabilityName, description, deployedImplementationType.getDeployedImplementationType(), versionIdentifier, null, null, null, extendedProperties, softwareCapabilityClassification, null, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, capabilityGUID);
        this.archiveHelper.addReplacementAttributes(capabilityGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName, replacementAttributeTypes);
        this.archiveHelper.addPlaceholderProperties(capabilityGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.SOFTWARE_CAPABILITY.typeName, placeholderPropertyTypes);
    }

    private void addFileSystemTemplate() {
        String methodName = "addFileSystemTemplate";
        Classification fileSystemClassification = this.archiveHelper.getFileSystemClassification(FileSystemPlaceholderProperty.FORMAT.getPlaceholder(), FileSystemPlaceholderProperty.ENCRYPTION.getPlaceholder(), "addFileSystemTemplate");
        this.createSoftwareCapabilityCatalogTemplate(DeployedImplementationType.FILE_SYSTEM, FileSystemPlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder(), fileSystemClassification, null, FileSystemPlaceholderProperty.getPlaceholderPropertyTypes());
    }

    private void addUNIXFileSystemTemplate() {
        String methodName = "addUNIXFileSystemTemplate";
        Classification fileSystemClassification = this.archiveHelper.getFileSystemClassification(FileSystemPlaceholderProperty.FORMAT.getPlaceholder(), FileSystemPlaceholderProperty.ENCRYPTION.getPlaceholder(), "addUNIXFileSystemTemplate");
        this.createSoftwareCapabilityCatalogTemplate(DeployedImplementationType.UNIX_FILE_SYSTEM, FileSystemPlaceholderProperty.FILE_SYSTEM_NAME.getPlaceholder(), fileSystemClassification, null, FileSystemPlaceholderProperty.getPlaceholderPropertyTypes());
    }

    private void createServerAssetCatalogTemplate(DeployedImplementationType deployedImplementationType, String assetName, String serverName, String userId, String password, String connectorTypeGUID, String networkAddress, Map<String, Object> configurationProperties, List<ReplacementAttributeType> replacementAttributeTypes, List<PlaceholderPropertyType> placeholderPropertyTypes) {
        String methodName = "createServerAssetCatalogTemplate";
        String qualifiedName = serverName == null ? deployedImplementationType.getDeployedImplementationType() + ":" + assetName : deployedImplementationType.getDeployedImplementationType() + ":" + serverName + ":" + assetName;
        String versionIdentifier = "V1.0";
        String description = deployedImplementationType.getDescription();
        HashMap<String, String> extendedProperties = new HashMap<String, String>();
        ArrayList<Classification> classifications = new ArrayList<Classification>();
        extendedProperties.put(OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, deployedImplementationType.getDeployedImplementationType());
        classifications.add(this.archiveHelper.getTemplateClassification(deployedImplementationType.getDeployedImplementationType() + " template", null, "V1.0", null, "createServerAssetCatalogTemplate"));
        String assetGUID = this.archiveHelper.addAsset(deployedImplementationType.getAssociatedTypeName(), qualifiedName, assetName, versionIdentifier, description, null, extendedProperties, classifications);
        String endpointGUID = this.archiveHelper.addEndpoint(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, qualifiedName + ":Endpoint", assetName + " endpoint", null, networkAddress, null, null);
        String connectionGUID = this.archiveHelper.addConnection(qualifiedName + ":Connection", assetName + " connection", null, userId, password, null, null, configurationProperties, null, connectorTypeGUID, endpointGUID, assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName);
        this.archiveHelper.addConnectionForAsset(assetGUID, null, connectionGUID);
        String deployedImplementationTypeGUID = this.archiveHelper.getGUID(deployedImplementationType.getQualifiedName());
        this.archiveHelper.addCatalogTemplateRelationship(deployedImplementationTypeGUID, assetGUID);
        this.archiveHelper.addReplacementAttributes(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, replacementAttributeTypes);
        this.archiveHelper.addPlaceholderProperties(assetGUID, deployedImplementationType.getAssociatedTypeName(), OpenMetadataType.ASSET.typeName, placeholderPropertyTypes);
    }

    private void addPostgresDatabaseCatalogTemplate() {
        JDBCResourceConnectorProvider provider = new JDBCResourceConnectorProvider();
        List placeholderPropertyTypes = PostgresPlaceholderProperty.getPostgresDatabasePlaceholderPropertyTypes();
        this.createServerAssetCatalogTemplate(DeployedImplementationType.POSTGRESQL_DATABASE, PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder(), PostgresPlaceholderProperty.SERVER_NAME.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_USER_ID.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_PASSWORD.getPlaceholder(), provider.getConnectorType().getGUID(), "jdbc:postgresql://" + PostgresPlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PostgresPlaceholderProperty.PORT_NUMBER.getPlaceholder() + "/" + PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder(), null, null, placeholderPropertyTypes);
    }

    private void addPostgresDatabaseSchemaCatalogTemplate() {
        JDBCResourceConnectorProvider provider = new JDBCResourceConnectorProvider();
        List placeholderPropertyTypes = PostgresPlaceholderProperty.getPostgresSchemaPlaceholderPropertyTypes();
        this.createServerAssetCatalogTemplate(DeployedImplementationType.POSTGRESQL_DATABASE_SCHEMA, PostgresPlaceholderProperty.SCHEMA_NAME.getPlaceholder(), PostgresPlaceholderProperty.SERVER_NAME.getPlaceholder() + "." + PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_USER_ID.getPlaceholder(), PostgresPlaceholderProperty.DATABASE_PASSWORD.getPlaceholder(), provider.getConnectorType().getGUID(), "jdbc:postgresql://" + PostgresPlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + PostgresPlaceholderProperty.PORT_NUMBER.getPlaceholder() + "/" + PostgresPlaceholderProperty.DATABASE_NAME.getPlaceholder() + "?currentSchema=" + PostgresPlaceholderProperty.SCHEMA_NAME.getPlaceholder(), null, null, placeholderPropertyTypes);
    }

    private void addKafkaTopicCatalogTemplate() {
        KafkaOpenMetadataTopicProvider provider = new KafkaOpenMetadataTopicProvider();
        List placeholderPropertyTypes = KafkaPlaceholderProperty.getKafkaTopicPlaceholderPropertyTypes();
        HashMap<String, Object> configurationProperties = new HashMap<String, Object>();
        HashMap<String, CallSite> bootstrapServersProperties = new HashMap<String, CallSite>();
        bootstrapServersProperties.put("bootstrap.servers", (CallSite)((Object)(KafkaPlaceholderProperty.HOST_IDENTIFIER.getPlaceholder() + ":" + KafkaPlaceholderProperty.PORT_NUMBER.getPlaceholder())));
        configurationProperties.put(KafkaPlaceholderProperty.EVENT_DIRECTION.getName(), "inOut");
        configurationProperties.put("producer", bootstrapServersProperties);
        configurationProperties.put("consumer", bootstrapServersProperties);
        this.createServerAssetCatalogTemplate(DeployedImplementationType.APACHE_KAFKA_TOPIC, DeployedImplementationType.APACHE_KAFKA_TOPIC.getAssociatedTypeName(), PostgresPlaceholderProperty.SERVER_NAME.getPlaceholder() + "." + KafkaPlaceholderProperty.TOPIC_NAME.getPlaceholder() + ":inOut", null, null, provider.getConnectorType().getGUID(), KafkaPlaceholderProperty.TOPIC_NAME.getPlaceholder(), configurationProperties, null, placeholderPropertyTypes);
    }

    private String addDeployedImplementationType(String deployedImplementationType, String associatedTypeName, String description, String wikiLink) {
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null, (String)deployedImplementationType);
        String category = OpenMetadataValidValues.constructValidValueCategory((String)associatedTypeName, (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null);
        return this.addDeployedImplementationType(deployedImplementationType, associatedTypeName, qualifiedName, category, description, wikiLink);
    }

    private String addOpenMetadataType(OpenMetadataType openMetadataType) {
        String parentSetGUID = this.getParentSet(null, null, OpenMetadataProperty.TYPE_NAME.name, null);
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName(null, (String)OpenMetadataProperty.TYPE_NAME.name, null, (String)openMetadataType.typeName);
        String category = OpenMetadataValidValues.constructValidValueCategory(null, (String)OpenMetadataProperty.TYPE_NAME.name, null);
        String validValueGUID = this.archiveHelper.addValidValue(openMetadataType.descriptionGUID, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, openMetadataType.typeName, openMetadataType.description, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", openMetadataType.typeName, false, false, null);
        if (openMetadataType.wikiURL != null) {
            String externalReferenceGUID = this.archiveHelper.addExternalReference(null, validValueGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, qualifiedName + "_wikiLink", "More information about open metadata type: " + openMetadataType.typeName, null, null, null, null, 0, null, null, null, null, null, null, openMetadataType.wikiURL, null, null, null, null, null, null, null, null, null, null, null, null);
            this.archiveHelper.addExternalReferenceLink(validValueGUID, externalReferenceGUID, null, null, null);
        }
        return validValueGUID;
    }

    private String addDeployedImplementationType(String deployedImplementationType, String associatedTypeName, String qualifiedName, String category, String description, String wikiLink) {
        String parentSetGUID = this.getParentSet(null, associatedTypeName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null);
        String typeQualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName(null, (String)OpenMetadataProperty.TYPE_NAME.name, null, (String)associatedTypeName);
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put(OpenMetadataProperty.TYPE_NAME.name, associatedTypeName);
        String validValueGUID = this.archiveHelper.addValidValue(null, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, deployedImplementationType, description, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", deployedImplementationType, false, false, additionalProperties);
        if (wikiLink != null) {
            String externalReferenceGUID = this.archiveHelper.addExternalReference(null, validValueGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, qualifiedName + "_wikiLink", "More information about deployedImplementationType: " + deployedImplementationType, null, null, null, null, 0, null, null, null, null, null, null, wikiLink, null, null, null, null, null, null, null, null, null, null, null, null);
            this.archiveHelper.addExternalReferenceLink(validValueGUID, externalReferenceGUID, null, null, null);
        }
        return validValueGUID;
    }

    private void addFileType(String fileTypeName, String encoding, String assetSubTypeName, DeployedImplementationType deployedImplementationType, String description) {
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_TYPE.name, null, (String)fileTypeName);
        String category = OpenMetadataValidValues.constructValidValueCategory((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_TYPE.name, null);
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        if (encoding != null) {
            additionalProperties.put(OpenMetadataProperty.ENCODING.name, encoding);
        }
        if (assetSubTypeName != null) {
            additionalProperties.put("assetSubTypeName", assetSubTypeName);
        }
        if (additionalProperties.isEmpty()) {
            additionalProperties = null;
        }
        String parentSetGUID = this.getParentSet(null, OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_TYPE.name, null);
        this.archiveHelper.addValidValue(null, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, fileTypeName, description, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", fileTypeName, false, false, additionalProperties);
        if (deployedImplementationType != null) {
            String deployedImplementationTypeQName = deployedImplementationType.getQualifiedName();
            this.archiveHelper.addConsistentValidValueRelationship(qualifiedName, deployedImplementationTypeQName);
        }
    }

    private void addFileName(String fileName, FileType fileType, DeployedImplementationType deployedImplementationType) {
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_NAME.name, null, (String)fileName);
        String category = OpenMetadataValidValues.constructValidValueCategory((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_NAME.name, null);
        String parentSetGUID = this.getParentSet(null, OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_NAME.name, null);
        this.archiveHelper.addValidValue(null, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, fileName, null, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", fileName, false, false, null);
        if (deployedImplementationType != null) {
            String deployedImplementationTypeQName = OpenMetadataValidValues.constructValidValueQualifiedName((String)deployedImplementationType.getAssociatedTypeName(), (String)OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, null, (String)deployedImplementationType.getDeployedImplementationType());
            this.archiveHelper.addConsistentValidValueRelationship(qualifiedName, deployedImplementationTypeQName);
        }
        if (fileType != null) {
            String fileTypeQName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_TYPE.name, null, (String)fileType.getFileTypeName());
            this.archiveHelper.addConsistentValidValueRelationship(qualifiedName, fileTypeQName);
        }
    }

    private void addFileExtension(String fileExtension, List<FileType> fileTypes) {
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_EXTENSION.name, null, (String)fileExtension);
        String category = OpenMetadataValidValues.constructValidValueCategory((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_EXTENSION.name, null);
        String parentSetGUID = this.getParentSet(null, OpenMetadataType.DATA_FILE.typeName, OpenMetadataProperty.FILE_EXTENSION.name, null);
        this.archiveHelper.addValidValue(null, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, fileExtension, null, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", fileExtension, false, false, null);
        if (fileTypes != null) {
            for (FileType fileType : fileTypes) {
                String fileTypeQName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.DATA_FILE.typeName, (String)OpenMetadataProperty.FILE_TYPE.name, null, (String)fileType.getFileTypeName());
                this.archiveHelper.addConsistentValidValueRelationship(qualifiedName, fileTypeQName);
            }
        }
    }

    private void addAttributeName(String attributeName, String attributeDescription) {
        String qualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, (String)OpenMetadataProperty.PROPERTY_TYPE.name, null, (String)attributeName);
        String category = OpenMetadataValidValues.constructValidValueCategory((String)OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, (String)OpenMetadataProperty.PROPERTY_TYPE.name, null);
        String parentSetGUID = this.getParentSet(null, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, OpenMetadataProperty.PROPERTY_TYPE.name, null);
        this.archiveHelper.addValidValue(null, parentSetGUID, parentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeGUID, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, qualifiedName, attributeName, attributeDescription, category, "Used to control valid values in open metadata.", "string", "Open Metadata Ecosystem", attributeName, false, false, null);
    }

    private String getParentSet(String requestedGUID, String typeName, String propertyName, String mapName) {
        String parentDescription = "Organizing set for valid metadata values";
        String parentQualifiedName = OpenMetadataValidValues.constructValidValueQualifiedName((String)typeName, (String)propertyName, (String)mapName, null);
        String parentSetGUID = this.parentValidValueQNameToGUIDMap.get(parentQualifiedName);
        if (parentSetGUID == null) {
            String grandParentSetGUID = null;
            String parentDisplayName = parentQualifiedName.substring(26);
            if (mapName != null) {
                grandParentSetGUID = this.getParentSet(null, typeName, propertyName, null);
            } else if (propertyName != null) {
                grandParentSetGUID = this.getParentSet(null, typeName, null, null);
            } else if (typeName != null) {
                grandParentSetGUID = this.getParentSet(null, null, null, null);
            }
            parentSetGUID = this.archiveHelper.addValidValue(requestedGUID, grandParentSetGUID, grandParentSetGUID, OpenMetadataType.VALID_VALUE_SET.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, parentQualifiedName, parentDisplayName, "Organizing set for valid metadata values", OpenMetadataValidValues.constructValidValueCategory((String)typeName, (String)propertyName, (String)mapName), "Used to control valid values in open metadata.", null, "Open Metadata Ecosystem", null, false, false, null);
            this.parentValidValueQNameToGUIDMap.put(parentQualifiedName, parentSetGUID);
            return parentSetGUID;
        }
        return parentSetGUID;
    }

    private String getFileProvisioningEngine(String governanceEngineName) {
        String governanceEngineDisplayName = "File Provisioning Engine";
        String governanceEngineDescription = "Copies, moves or deletes a file on request.";
        return this.archiveHelper.addGovernanceEngine(OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, governanceEngineName, "File Provisioning Engine", "Copies, moves or deletes a file on request.", null, null, null, null, null, null);
    }

    private String getAssetOnboardingEngine(String assetOnboardingEngineName) {
        String assetOnboardingEngineDisplayName = "Asset Onboarding Engine";
        String assetOnboardingEngineDescription = "Monitors, validates and enriches metadata relating to assets as they are catalogued.";
        return this.archiveHelper.addGovernanceEngine(OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, assetOnboardingEngineName, "Asset Onboarding Engine", "Monitors, validates and enriches metadata relating to assets as they are catalogued.", null, null, null, null, null, null);
    }

    private String getStewardshipEngine(String stewardshipEngineName) {
        String stewardshipEngineDisplayName = "Stewardship Engine";
        String stewardshipEngineDescription = "Liaises with stewards to make corrections to open metadata.";
        return this.archiveHelper.addGovernanceEngine(OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, stewardshipEngineName, "Stewardship Engine", "Liaises with stewards to make corrections to open metadata.", null, null, null, null, null, null);
    }

    private String getAssetSurveyEngine(String assetSurveyEngineName) {
        String assetSurveyEngineDisplayName = "Asset Survey Engine";
        String assetSurveyEngineDescription = "Extracts information about a digital resource and attaches it to its asset description.";
        return this.archiveHelper.addGovernanceEngine(OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, assetSurveyEngineName, "Asset Survey Engine", "Extracts information about a digital resource and attaches it to its asset description.", null, null, null, null, null, null);
    }

    private GovernanceActionDescription getFileProvisioningGovernanceActionService() {
        String governanceServiceName = "file-provisioning-governance-action-service";
        String governanceServiceDisplayName = "File {move, copy, delete} Governance Action Service";
        String governanceServiceDescription = "Works with files.  The request type defines which action is taken.  The request parameters define the source file and destination folder, along with lineage options";
        String ftpGovernanceServiceProviderClassName = MoveCopyFileGovernanceActionProvider.class.getName();
        MoveCopyFileGovernanceActionProvider provider = new MoveCopyFileGovernanceActionProvider();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.PROVISION_RESOURCE, (GovernanceServiceProviderBase)provider, "Works with files.  The request type defines which action is taken.  The request parameters define the source file and destination folder, along with lineage options");
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, ftpGovernanceServiceProviderClassName, null, "file-provisioning-governance-action-service", "File {move, copy, delete} Governance Action Service", "Works with files.  The request type defines which action is taken.  The request parameters define the source file and destination folder, along with lineage options", null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getWatchdogGovernanceActionService() {
        String governanceServiceName = "new-files-watchdog-governance-action-service";
        String governanceServiceDisplayName = "New Files Watchdog Governance Action Service";
        String governanceServiceDescription = "Initiates a governance action process when a new file arrives.";
        String governanceServiceProviderClassName = GenericFolderWatchdogGovernanceActionProvider.class.getName();
        GenericFolderWatchdogGovernanceActionProvider provider = new GenericFolderWatchdogGovernanceActionProvider();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.WATCH_DOG, (GovernanceServiceProviderBase)provider, "Initiates a governance action process when a new file arrives.");
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "new-files-watchdog-governance-action-service", "New Files Watchdog Governance Action Service", "Initiates a governance action process when a new file arrives.", null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getGovernanceActionDescription(ResourceUse resourceUse, GovernanceServiceProviderBase provider, String governanceServiceDescription) {
        GovernanceActionDescription governanceActionDescription = new GovernanceActionDescription();
        governanceActionDescription.resourceUse = resourceUse;
        governanceActionDescription.supportedRequestTypes = provider.getSupportedRequestTypes();
        governanceActionDescription.supportedRequestParameters = provider.getSupportedRequestParameters();
        governanceActionDescription.supportedActionTargets = provider.getSupportedActionTargetTypes();
        governanceActionDescription.producedRequestParameters = provider.getProducedRequestParameters();
        governanceActionDescription.producedActionTargets = provider.getProducedActionTargetTypes();
        governanceActionDescription.producedGuards = provider.getProducedGuards();
        if (provider instanceof SurveyActionServiceProvider) {
            SurveyActionServiceProvider surveyActionServiceProvider = (SurveyActionServiceProvider)provider;
            governanceActionDescription.supportedAnalysisSteps = surveyActionServiceProvider.getSupportedAnalysisSteps();
            governanceActionDescription.supportedAnnotationTypes = surveyActionServiceProvider.getProducedAnnotationTypes();
        }
        governanceActionDescription.governanceServiceDescription = governanceServiceDescription;
        return governanceActionDescription;
    }

    private GovernanceActionDescription getZonePublisherGovernanceActionService() {
        String governanceServiceName = "zone-publisher-governance-action-service";
        String governanceServiceDisplayName = "Update Asset's Zone Membership Governance Action Service";
        String governanceServiceProviderClassName = ZonePublisherGovernanceActionProvider.class.getName();
        ZonePublisherGovernanceActionProvider provider = new ZonePublisherGovernanceActionProvider();
        String governanceServiceDescription = provider.getConnectorType().getDescription();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.IMPROVE_METADATA, (GovernanceServiceProviderBase)provider, governanceServiceDescription);
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "zone-publisher-governance-action-service", "Update Asset's Zone Membership Governance Action Service", governanceServiceDescription, null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getQualifiedNameDeDupGovernanceActionService() {
        String governanceServiceName = "qualified-name-deduplication-governance-action-service";
        String governanceServiceDisplayName = "Qualified Name De-duplicator Governance Action Service";
        String governanceServiceDescription = "Detect elements with the same qualified names.";
        String governanceServiceProviderClassName = QualifiedNamePeerDuplicateGovernanceActionProvider.class.getName();
        QualifiedNamePeerDuplicateGovernanceActionProvider provider = new QualifiedNamePeerDuplicateGovernanceActionProvider();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.IMPROVE_METADATA, (GovernanceServiceProviderBase)provider, "Detect elements with the same qualified names.");
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "qualified-name-deduplication-governance-action-service", "Qualified Name De-duplicator Governance Action Service", "Detect elements with the same qualified names.", null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getEvaluateAnnotationsGovernanceActionService() {
        String governanceServiceName = "evaluate-annotations-governance-action-service";
        String governanceServiceDisplayName = "Verify annotations in a Survey Report";
        String governanceServiceProviderClassName = EvaluateAnnotationsGovernanceActionProvider.class.getName();
        EvaluateAnnotationsGovernanceActionProvider provider = new EvaluateAnnotationsGovernanceActionProvider();
        String governanceServiceDescription = provider.getConnectorType().getDescription();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.IMPROVE_METADATA, (GovernanceServiceProviderBase)provider, governanceServiceDescription);
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "evaluate-annotations-governance-action-service", "Verify annotations in a Survey Report", governanceServiceDescription, null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getWriteAuditLogGovernanceActionService() {
        String governanceServiceName = "write-audit-log-governance-action-service";
        String governanceServiceDisplayName = "Write an Audit Log Message";
        String governanceServiceProviderClassName = WriteAuditLogMessageGovernanceActionProvider.class.getName();
        WriteAuditLogMessageGovernanceActionProvider provider = new WriteAuditLogMessageGovernanceActionProvider();
        String governanceServiceDescription = provider.getConnectorType().getDescription();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.INFORM_STEWARD, (GovernanceServiceProviderBase)provider, governanceServiceDescription);
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "write-audit-log-governance-action-service", "Write an Audit Log Message", governanceServiceDescription, null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getDayOfWeekGovernanceActionService() {
        String governanceServiceName = "get-day-of-week-governance-action-service";
        String governanceServiceDisplayName = "Detect the day of the week";
        String governanceServiceProviderClassName = DaysOfWeekGovernanceActionProvider.class.getName();
        DaysOfWeekGovernanceActionProvider provider = new DaysOfWeekGovernanceActionProvider();
        String governanceServiceDescription = provider.getConnectorType().getDescription();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.CHOOSE_PATH, (GovernanceServiceProviderBase)provider, governanceServiceDescription);
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "get-day-of-week-governance-action-service", "Detect the day of the week", governanceServiceDescription, null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getVerifyAssetGovernanceActionService() {
        String governanceServiceName = "verify-asset-governance-action-service";
        String governanceServiceDisplayName = "Verify an Asset Governance Action Service";
        String governanceServiceProviderClassName = VerifyAssetGovernanceActionProvider.class.getName();
        VerifyAssetGovernanceActionProvider provider = new VerifyAssetGovernanceActionProvider();
        String governanceServiceDescription = provider.getConnectorType().getDescription();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.IMPROVE_METADATA, (GovernanceServiceProviderBase)provider, governanceServiceDescription);
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "verify-asset-governance-action-service", "Verify an Asset Governance Action Service", governanceServiceDescription, null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getOriginSeekerGovernanceActionService() {
        String governanceServiceName = "origin-seeker-governance-action-service";
        String governanceServiceDisplayName = "Locate and Set Origin Governance Action Service";
        String governanceServiceDescription = "Navigates back through the lineage relationships to locate the origin classification(s) from the source(s) and sets it on the requested asset if the origin is unique.";
        String governanceServiceProviderClassName = OriginSeekerGovernanceActionProvider.class.getName();
        OriginSeekerGovernanceActionProvider provider = new OriginSeekerGovernanceActionProvider();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.IMPROVE_METADATA, (GovernanceServiceProviderBase)provider, "Navigates back through the lineage relationships to locate the origin classification(s) from the source(s) and sets it on the requested asset if the origin is unique.");
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.GOVERNANCE_ACTION_SERVICE_CONNECTOR, governanceServiceProviderClassName, null, "origin-seeker-governance-action-service", "Locate and Set Origin Governance Action Service", "Navigates back through the lineage relationships to locate the origin classification(s) from the source(s) and sets it on the requested asset if the origin is unique.", null);
        return governanceActionDescription;
    }

    private void addRequestType(String governanceEngineGUID, String governanceEngineName, String governanceEngineTypeName, String governanceRequestType, String serviceRequestType, Map<String, String> requestParameters, GovernanceActionDescription governanceActionDescription) {
        String governanceActionTypeGUID;
        this.archiveHelper.addSupportedGovernanceService(governanceEngineGUID, governanceRequestType, serviceRequestType, requestParameters, governanceActionDescription.governanceServiceGUID);
        if (governanceActionDescription.supportedActionTargets != null && (governanceActionTypeGUID = this.archiveHelper.addGovernanceActionType(null, governanceEngineGUID, governanceEngineTypeName, OpenMetadataType.SOFTWARE_CAPABILITY.typeName, "Egeria:GovernanceActionType:" + governanceEngineName + ":" + governanceRequestType, governanceRequestType + " (" + governanceEngineName + ")", governanceActionDescription.governanceServiceDescription, 0, governanceActionDescription.supportedRequestParameters, governanceActionDescription.supportedActionTargets, governanceActionDescription.supportedAnalysisSteps, governanceActionDescription.supportedAnnotationTypes, governanceActionDescription.producedRequestParameters, governanceActionDescription.producedActionTargets, governanceActionDescription.producedGuards, 0, null, null, null)) != null) {
            this.archiveHelper.addGovernanceActionExecutor(governanceActionTypeGUID, governanceRequestType, requestParameters, null, null, null, null, governanceEngineGUID);
            for (ActionTargetType actionTargetType : governanceActionDescription.supportedActionTargets) {
                String deployedImplementationTypeGUID;
                String openMetadataTypeGUID;
                if (actionTargetType == null) continue;
                if (actionTargetType.getTypeName() != null && (openMetadataTypeGUID = this.openMetadataTypeGUIDs.get(actionTargetType.getTypeName())) != null) {
                    this.archiveHelper.addResourceListRelationshipByGUID(openMetadataTypeGUID, governanceActionTypeGUID, governanceActionDescription.resourceUse.getResourceUse(), governanceActionDescription.governanceServiceDescription, requestParameters, false);
                }
                if (actionTargetType.getDeployedImplementationType() == null || (deployedImplementationTypeGUID = this.deployedImplementationTypeGUIDs.get(actionTargetType.getDeployedImplementationType())) == null) continue;
                this.archiveHelper.addResourceListRelationshipByGUID(deployedImplementationTypeGUID, governanceActionTypeGUID, governanceActionDescription.resourceUse.getResourceUse(), governanceActionDescription.governanceServiceDescription, requestParameters, false);
            }
        }
    }

    private void addWatchNestedInFolderRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "watch-for-new-files-in-folder";
        String serviceRequestType = "watch-nested-in-folder";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "watch-for-new-files-in-folder", "watch-nested-in-folder", null, governanceActionDescription);
    }

    private void addCopyFileRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "copy-file";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "copy-file", null, null, governanceActionDescription);
    }

    private void addMoveFileRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "move-file";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "move-file", null, null, governanceActionDescription);
    }

    private void addDeleteFileRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "delete-file";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "delete-file", null, null, governanceActionDescription);
    }

    private void addSeekOriginRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "seek-origin-of-asset";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "seek-origin-of-asset", null, null, governanceActionDescription);
    }

    private void addSetZoneMembershipRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "set-zone-membership-for-asset";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "set-zone-membership-for-asset", null, null, governanceActionDescription);
    }

    private void addVerifyAssetRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "verify-asset";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "verify-asset", null, null, governanceActionDescription);
    }

    private void addEvaluateAnnotationsRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "evaluate-annotations";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "evaluate-annotations", null, null, governanceActionDescription);
    }

    private void addWriteAuditLogRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "write-to-audit-log";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "write-to-audit-log", null, null, governanceActionDescription);
    }

    private void addDayOfWeekRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "get-day-of-week";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "get-day-of-week", null, null, governanceActionDescription);
    }

    private void addQualifiedNameDeDupRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "qualified-name-de-dup";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.GOVERNANCE_ACTION_ENGINE.typeName, "qualified-name-de-dup", null, null, governanceActionDescription);
    }

    private GovernanceActionDescription getCSVFileSurveyService() {
        String surveyServiceName = "csv-file-survey-service";
        String surveyServiceDisplayName = "CSV File Survey Service";
        String surveyServiceDescription = "Discovers columns within a CSV File.";
        String surveyServiceProviderClassName = CSVSurveyServiceProvider.class.getName();
        CSVSurveyServiceProvider provider = new CSVSurveyServiceProvider();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.SURVEY_RESOURCE, (GovernanceServiceProviderBase)provider, "Discovers columns within a CSV File.");
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, surveyServiceProviderClassName, null, "csv-file-survey-service", "CSV File Survey Service", "Discovers columns within a CSV File.", null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getDataFileSurveyService() {
        String surveyServiceName = "data-file-survey-service";
        String surveyServiceDisplayName = "Data File Survey Service";
        String surveyServiceDescription = "Discovers the name, extension, file type and other characteristics of a file.";
        String surveyServiceProviderClassName = FileSurveyServiceProvider.class.getName();
        FileSurveyServiceProvider provider = new FileSurveyServiceProvider();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.SURVEY_RESOURCE, (GovernanceServiceProviderBase)provider, "Discovers the name, extension, file type and other characteristics of a file.");
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, surveyServiceProviderClassName, null, "data-file-survey-service", "Data File Survey Service", "Discovers the name, extension, file type and other characteristics of a file.", null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getFolderSurveyService() {
        String surveyServiceName = "folder-survey-service";
        String surveyServiceDisplayName = "Folder (directory) Survey Service";
        String surveyServiceDescription = "Discovers the types of files located within a file system directory (and its sub-directories).";
        String surveyServiceProviderClassName = FolderSurveyServiceProvider.class.getName();
        FolderSurveyServiceProvider provider = new FolderSurveyServiceProvider();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.SURVEY_RESOURCE, (GovernanceServiceProviderBase)provider, "Discovers the types of files located within a file system directory (and its sub-directories).");
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, surveyServiceProviderClassName, null, "folder-survey-service", "Folder (directory) Survey Service", "Discovers the types of files located within a file system directory (and its sub-directories).", null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getAtlasSurveyService() {
        String surveyServiceName = "apache-atlas-survey-service";
        String surveyServiceDisplayName = "Apache Atlas Survey Service";
        String surveyServiceProviderClassName = SurveyApacheAtlasProvider.class.getName();
        SurveyApacheAtlasProvider provider = new SurveyApacheAtlasProvider();
        String surveyServiceDescription = provider.getConnectorType().getDescription();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.SURVEY_RESOURCE, (GovernanceServiceProviderBase)provider, surveyServiceDescription);
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, surveyServiceProviderClassName, null, "apache-atlas-survey-service", "Apache Atlas Survey Service", surveyServiceDescription, null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getPostgresServerSurveyService() {
        String surveyServiceName = "postgres-server-survey-service";
        String surveyServiceDisplayName = "PostgreSQL Server Survey Service";
        String surveyServiceProviderClassName = PostgresServerSurveyActionProvider.class.getName();
        PostgresServerSurveyActionProvider provider = new PostgresServerSurveyActionProvider();
        String surveyServiceDescription = provider.getConnectorType().getDescription();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.SURVEY_RESOURCE, (GovernanceServiceProviderBase)provider, surveyServiceDescription);
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, surveyServiceProviderClassName, null, "postgres-server-survey-service", "PostgreSQL Server Survey Service", surveyServiceDescription, null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getPostgresDatabaseSurveyService() {
        String surveyServiceName = "postgres-database-survey-service";
        String surveyServiceDisplayName = "PostgreSQL Database Survey Service";
        String surveyServiceProviderClassName = PostgresDatabaseSurveyActionProvider.class.getName();
        PostgresDatabaseSurveyActionProvider provider = new PostgresDatabaseSurveyActionProvider();
        String surveyServiceDescription = provider.getConnectorType().getDescription();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.SURVEY_RESOURCE, (GovernanceServiceProviderBase)provider, surveyServiceDescription);
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, surveyServiceProviderClassName, null, "postgres-database-survey-service", "PostgreSQL Database Survey Service", surveyServiceDescription, null);
        return governanceActionDescription;
    }

    private GovernanceActionDescription getKafkaServerSurveyService() {
        String surveyServiceName = "kafka-server-survey-service";
        String surveyServiceDisplayName = "Apache Kafka Server Survey Service";
        String surveyServiceProviderClassName = SurveyApacheKafkaServerProvider.class.getName();
        SurveyApacheKafkaServerProvider provider = new SurveyApacheKafkaServerProvider();
        String surveyServiceDescription = provider.getConnectorType().getDescription();
        GovernanceActionDescription governanceActionDescription = this.getGovernanceActionDescription(ResourceUse.SURVEY_RESOURCE, (GovernanceServiceProviderBase)provider, surveyServiceDescription);
        governanceActionDescription.governanceServiceGUID = this.archiveHelper.addGovernanceService(DeployedImplementationType.SURVEY_ACTION_SERVICE_CONNECTOR, surveyServiceProviderClassName, null, "kafka-server-survey-service", "Apache Kafka Server Survey Service", surveyServiceDescription, null);
        return governanceActionDescription;
    }

    private void addCSVFileRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "survey-csv-file";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "survey-csv-file", null, null, governanceActionDescription);
    }

    private void addDataFileRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "survey-data-file";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "survey-data-file", null, null, governanceActionDescription);
    }

    private void addFolderRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String topLevelOnlyRequestType = "survey-folder";
        String topLevelAndFileRequestType = "survey-folder-and-files";
        String allFoldersRequestType = "survey-all-folders";
        String allFoldersAndFilesRequestType = "survey-all-folders-and-files";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "survey-folder", null, null, governanceActionDescription);
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(FolderRequestParameter.ANALYSIS_LEVEL.getName(), "TOP_LEVEL_AND_FILES");
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "survey-folder-and-files", null, requestParameters, governanceActionDescription);
        requestParameters.put(FolderRequestParameter.ANALYSIS_LEVEL.getName(), "ALL_FOLDERS");
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "survey-all-folders", null, requestParameters, governanceActionDescription);
        requestParameters.put(FolderRequestParameter.ANALYSIS_LEVEL.getName(), "ALL_FOLDERS_AND_FILES");
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "survey-all-folders-and-files", null, requestParameters, governanceActionDescription);
    }

    private void addAtlasRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "survey-apache-atlas-server";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "survey-apache-atlas-server", null, null, governanceActionDescription);
    }

    private void addPostgresServerRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "survey-postgres-server";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "survey-postgres-server", null, null, governanceActionDescription);
    }

    private void addPostgresDatabaseRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "survey-postgres-database";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "survey-postgres-database", null, null, governanceActionDescription);
    }

    private void addKafkaServerRequestType(String governanceEngineGUID, String governanceEngineName, GovernanceActionDescription governanceActionDescription) {
        String governanceRequestType = "survey-kafka-server";
        this.addRequestType(governanceEngineGUID, governanceEngineName, OpenMetadataType.SURVEY_ACTION_ENGINE.typeName, "survey-kafka-server", null, null, governanceActionDescription);
    }

    private void createDailyGovernanceActionProcess(String governanceEngineGUID) {
        String step8GUID;
        String step7GUID;
        String step6GUID;
        String step5GUID;
        String step4GUID;
        String step3GUID;
        String step2GUID;
        String processGUID = this.archiveHelper.addGovernanceActionProcess("GovernanceActionProcess", "Egeria:DailyGovernanceActionProcess", "DailyGovernanceActionProcess", null, null, null, 0, null, null, null);
        String step1GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:GetDayOfWeek", "Get the day of the Week", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null);
        if (step1GUID != null) {
            this.archiveHelper.addGovernanceActionExecutor(step1GUID, "get-day-of-week", null, null, null, null, null, governanceEngineGUID);
            this.archiveHelper.addGovernanceActionProcessFlow(processGUID, null, step1GUID);
        }
        if ((step2GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:MondayTask", "Output Monday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Monday is: Wash");
            this.archiveHelper.addGovernanceActionExecutor(step2GUID, "write-to-audit-log", requestParameters, null, null, null, null, governanceEngineGUID);
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, "monday", false, step2GUID);
        }
        if ((step3GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:TuesdayTask", "Output Tuesday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Tuesday is: Iron");
            this.archiveHelper.addGovernanceActionExecutor(step3GUID, "write-to-audit-log", requestParameters, null, null, null, null, governanceEngineGUID);
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, "tuesday", false, step3GUID);
        }
        if ((step4GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:WednesdayTask", "Output Wednesday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Wednesday is: Mend");
            this.archiveHelper.addGovernanceActionExecutor(step4GUID, "write-to-audit-log", requestParameters, null, null, null, null, governanceEngineGUID);
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, "wednesday", false, step4GUID);
        }
        if ((step5GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:ThursdayTask", "Output Thursday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Thursday is: Market");
            this.archiveHelper.addGovernanceActionExecutor(step5GUID, "write-to-audit-log", requestParameters, null, null, null, null, governanceEngineGUID);
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, "thursday", false, step5GUID);
        }
        if ((step6GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:FridayTask", "Output Friday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Friday is: Clean");
            this.archiveHelper.addGovernanceActionExecutor(step6GUID, "write-to-audit-log", requestParameters, null, null, null, null, governanceEngineGUID);
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, "friday", false, step6GUID);
        }
        if ((step7GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:SaturdayTask", "Output Saturday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Saturday is: Bake");
            this.archiveHelper.addGovernanceActionExecutor(step7GUID, "write-to-audit-log", requestParameters, null, null, null, null, governanceEngineGUID);
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, "saturday", false, step7GUID);
        }
        if ((step8GUID = this.archiveHelper.addGovernanceActionProcessStep("GovernanceActionProcessStep", processGUID, "GovernanceActionProcess", OpenMetadataType.ASSET.typeName, "Egeria:DailyGovernanceActionProcess:SundayTask", "Output Sunday's task", null, 0, null, null, null, null, null, null, null, 0, true, null, null, null)) != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(WriteAuditLogRequestParameter.MESSAGE_TEXT.getName(), "Action For Sunday is: Rest");
            this.archiveHelper.addGovernanceActionExecutor(step8GUID, "write-to-audit-log", requestParameters, null, null, null, null, governanceEngineGUID);
            this.archiveHelper.addNextGovernanceActionProcessStep(step1GUID, "sunday", false, step8GUID);
        }
    }

    private void writeOpenMetadataArchive() {
        try {
            System.out.println("Writing to file: CoreContentPack.omarchive");
            super.writeOpenMetadataArchive(archiveFileName, this.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }

    public static void main(String[] args) {
        try {
            OpenConnectorArchiveWriter archiveWriter = new OpenConnectorArchiveWriter();
            archiveWriter.writeOpenMetadataArchive();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error);
            System.exit(-1);
        }
    }

    static class GovernanceActionDescription {
        String governanceServiceGUID = null;
        String governanceServiceDescription = null;
        List<RequestTypeType> supportedRequestTypes = null;
        List<RequestParameterType> supportedRequestParameters = null;
        List<ActionTargetType> supportedActionTargets = null;
        List<AnalysisStepType> supportedAnalysisSteps = null;
        List<AnnotationTypeType> supportedAnnotationTypes = null;
        List<RequestParameterType> producedRequestParameters = null;
        List<ActionTargetType> producedActionTargets = null;
        List<GuardType> producedGuards = null;
        ResourceUse resourceUse = null;

        GovernanceActionDescription() {
        }
    }
}

