/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.openconnectors.control;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.PlaceholderPropertyType;

public enum FileSystemPlaceholderProperty {
    HOST_IDENTIFIER("hostIdentifier", "The host IP address or domain name of the host.", "string", "coconet.com"),
    FILE_SYSTEM_NAME("fileSystemName", "The display name of the file system being catalogued.", "string", "myMachine"),
    VERSION_IDENTIFIER("versionIdentifier", "The version of the file system.", "string", "V1.5"),
    FORMAT("format", "The format standard used in the file system.", "string", "APFS"),
    ENCRYPTION("encryption", "Is encryption enabled on this file system? If known, what type of encryption?", "string", "Not Enabled");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private FileSystemPlaceholderProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return "{{" + this.name + "}}";
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<PlaceholderPropertyType> getPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        for (FileSystemPlaceholderProperty placeholderProperty : FileSystemPlaceholderProperty.values()) {
            placeholderPropertyTypes.add(placeholderProperty.getPlaceholderType());
        }
        return placeholderPropertyTypes;
    }

    public PlaceholderPropertyType getPlaceholderType() {
        PlaceholderPropertyType placeholderPropertyType = new PlaceholderPropertyType();
        placeholderPropertyType.setName(this.name);
        placeholderPropertyType.setDescription(this.description);
        placeholderPropertyType.setDataType(this.dataType);
        placeholderPropertyType.setExample(this.example);
        placeholderPropertyType.setRequired(true);
        return placeholderPropertyType;
    }

    public String toString() {
        return "PlaceholderProperty{ name=" + this.name + "}";
    }
}

