/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.ffdc;

import java.util.Objects;

public abstract class OCFCheckedExceptionBase
extends Exception {
    private int reportedHTTPCode;
    private String reportingClassName;
    private String reportingActionDescription;
    private String reportedErrorMessage;
    private String reportedSystemAction;
    private String reportedUserAction;
    private Throwable reportedCaughtException = null;

    public OCFCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction) {
        super(errorMessage);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
    }

    public OCFCheckedExceptionBase(int httpCode, String className, String actionDescription, String errorMessage, String systemAction, String userAction, Throwable caughtError) {
        super(errorMessage, caughtError);
        this.reportedHTTPCode = httpCode;
        this.reportingClassName = className;
        this.reportingActionDescription = actionDescription;
        this.reportedErrorMessage = errorMessage;
        this.reportedSystemAction = systemAction;
        this.reportedUserAction = userAction;
        this.reportedCaughtException = caughtError;
    }

    public int getReportedHTTPCode() {
        return this.reportedHTTPCode;
    }

    public String getReportingClassName() {
        return this.reportingClassName;
    }

    public String getReportingActionDescription() {
        return this.reportingActionDescription;
    }

    public String getErrorMessage() {
        return this.reportedErrorMessage;
    }

    public String getReportedSystemAction() {
        return this.reportedSystemAction;
    }

    public String getReportedUserAction() {
        return this.reportedUserAction;
    }

    public Throwable getReportedCaughtException() {
        return this.reportedCaughtException;
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof OCFCheckedExceptionBase)) {
            return false;
        }
        OCFCheckedExceptionBase that = (OCFCheckedExceptionBase)objectToCompare;
        return this.getReportedHTTPCode() == that.getReportedHTTPCode() && Objects.equals(this.getReportingClassName(), that.getReportingClassName()) && Objects.equals(this.getReportingActionDescription(), that.getReportingActionDescription()) && Objects.equals(this.reportedErrorMessage, that.reportedErrorMessage) && Objects.equals(this.getReportedSystemAction(), that.getReportedSystemAction()) && Objects.equals(this.getReportedUserAction(), that.getReportedUserAction()) && Objects.equals(this.getReportedCaughtException(), that.getReportedCaughtException());
    }

    public int hashCode() {
        return Objects.hash(this.getReportedHTTPCode(), this.getReportingClassName(), this.getReportingActionDescription(), this.reportedErrorMessage, this.getReportedSystemAction(), this.getReportedUserAction(), this.getReportedCaughtException());
    }

    @Override
    public String toString() {
        return "OCFCheckedExceptionBase{, reportedHTTPCode=" + this.reportedHTTPCode + ", reportingClassName='" + this.reportingClassName + '\'' + ", reportingActionDescription='" + this.reportingActionDescription + '\'' + ", reportedErrorMessage='" + this.reportedErrorMessage + '\'' + ", reportedSystemAction='" + this.reportedSystemAction + '\'' + ", reportedUserAction='" + this.reportedUserAction + '\'' + ", reportedCaughtException=" + this.reportedCaughtException + ", errorMessage='" + this.getErrorMessage() + '\'' + '}';
    }
}

