/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetCommentReplies;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Comment;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.CommentType;

public class AssetComment
extends AssetElementHeader {
    protected Comment commentBean;
    protected AssetCommentReplies commentReplies = null;

    public AssetComment(Comment commentBean, AssetCommentReplies commentReplies) {
        super(commentBean);
        this.commentBean = commentBean == null ? new Comment() : commentBean;
        this.commentReplies = commentReplies == null ? null : commentReplies.cloneIterator(super.getParentAsset());
    }

    public AssetComment(AssetDescriptor parentAsset, Comment commentBean, AssetCommentReplies commentReplies) {
        super(parentAsset, commentBean);
        this.commentBean = commentBean == null ? new Comment() : commentBean;
        this.commentReplies = commentReplies == null ? null : commentReplies.cloneIterator(super.getParentAsset());
    }

    public AssetComment(AssetDescriptor parentAsset, AssetComment templateComment) {
        super(parentAsset, templateComment);
        if (templateComment == null) {
            this.commentBean = new Comment();
        } else {
            this.commentBean = templateComment.getCommentBean();
            AssetCommentReplies templateCommentReplies = templateComment.getCommentReplies();
            if (templateCommentReplies != null) {
                this.commentReplies = templateCommentReplies.cloneIterator(super.getParentAsset());
            }
        }
    }

    protected Comment getCommentBean() {
        return this.commentBean;
    }

    public CommentType getCommentType() {
        return this.commentBean.getCommentType();
    }

    public String getUser() {
        return this.commentBean.getUser();
    }

    public String getCommentText() {
        return this.commentBean.getCommentText();
    }

    public AssetCommentReplies getCommentReplies() {
        if (this.commentReplies == null) {
            return null;
        }
        return this.commentReplies.cloneIterator(super.getParentAsset());
    }

    @Override
    public String toString() {
        return this.commentBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetComment)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetComment that = (AssetComment)objectToCompare;
        return Objects.equals(this.getCommentBean(), that.getCommentBean()) && Objects.equals(this.getCommentReplies(), that.getCommentReplies());
    }
}

