/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.properties.AdditionalProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetElementType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;

public class AssetSummary
extends AssetDescriptor {
    protected AssetSummary() {
    }

    public AssetSummary(Asset assetBean) {
        super(assetBean);
    }

    public AssetSummary(AssetSummary templateAssetSummary) {
        super(templateAssetSummary);
    }

    public AssetElementType getType() {
        ElementType elementType = this.assetBean.getType();
        if (elementType == null) {
            return null;
        }
        return new AssetElementType(elementType);
    }

    public String getGUID() {
        return this.assetBean.getGUID();
    }

    public String getURL() {
        return this.assetBean.getURL();
    }

    public String getQualifiedName() {
        return this.assetBean.getQualifiedName();
    }

    public String getDisplayName() {
        return this.assetBean.getDisplayName();
    }

    public String getShortDescription() {
        return this.assetBean.getShortDescription();
    }

    public String getDescription() {
        return this.assetBean.getDescription();
    }

    public String getOwner() {
        return this.assetBean.getOwner();
    }

    public List<AssetClassification> getAssetClassifications() {
        List<Classification> classifications = this.assetBean.getClassifications();
        if (classifications == null) {
            return null;
        }
        ArrayList<AssetClassification> assetClassifications = new ArrayList<AssetClassification>();
        for (Classification classification : classifications) {
            if (classification == null) continue;
            assetClassifications.add(new AssetClassification((AssetDescriptor)this, classification));
        }
        if (assetClassifications.isEmpty()) {
            return null;
        }
        return assetClassifications;
    }

    public AdditionalProperties getAssetProperties() {
        Map<String, Object> assetProperties = this.assetBean.getAssetProperties();
        if (assetProperties == null) {
            return null;
        }
        return new AdditionalProperties((AssetDescriptor)this, assetProperties);
    }

    public AdditionalProperties getAdditionalProperties() {
        Map<String, Object> additionalProperties = this.assetBean.getAdditionalProperties();
        if (additionalProperties == null) {
            return null;
        }
        if (additionalProperties.isEmpty()) {
            return null;
        }
        return new AdditionalProperties((AssetDescriptor)this, additionalProperties);
    }

    @Override
    public String toString() {
        return this.assetBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetSummary)) {
            return false;
        }
        AssetSummary that = (AssetSummary)objectToCompare;
        return this.assetBean.equals(that.getAssetBean());
    }

    @Override
    public int hashCode() {
        return this.assetBean.hashCode();
    }
}

