/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetAnnotations;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetCertifications;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetConnections;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDetail;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetExternalIdentifiers;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetExternalReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetFeedback;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetLicenses;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetLineage;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetLocations;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetMeanings;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetNoteLogs;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetRelatedMediaReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedAssets;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;

public class AssetUniverse
extends AssetDetail {
    protected AssetMeanings meanings = null;
    protected AssetSchemaElement schema = null;
    protected AssetAnnotations analysis = null;
    protected AssetFeedback feedback = null;
    protected AssetLocations knownLocations = null;
    protected AssetLineage lineage = null;
    protected RelatedAssets relatedAssets = null;

    protected AssetUniverse() {
    }

    public AssetUniverse(Asset assetBean, AssetExternalIdentifiers externalIdentifiers, AssetRelatedMediaReferences relatedMediaReferences, AssetNoteLogs noteLogs, AssetExternalReferences externalReferences, AssetConnections connections, AssetLicenses licenses, AssetCertifications certifications, AssetMeanings meanings, AssetSchemaElement schema, AssetAnnotations analysis, AssetFeedback feedback, AssetLocations knownLocations, AssetLineage lineage, RelatedAssets relatedAssets) {
        super(assetBean, externalIdentifiers, relatedMediaReferences, noteLogs, externalReferences, connections, licenses, certifications);
        this.meanings = meanings;
        this.schema = schema;
        this.analysis = analysis;
        this.feedback = feedback;
        this.knownLocations = knownLocations;
        this.lineage = lineage;
        this.relatedAssets = relatedAssets;
    }

    public AssetUniverse(AssetUniverse templateAssetUniverse) {
        super(templateAssetUniverse);
        if (templateAssetUniverse != null) {
            AssetMeanings templateMeanings = templateAssetUniverse.getMeanings();
            AssetSchemaElement templateSchema = templateAssetUniverse.getSchema();
            AssetAnnotations templateAnalysis = templateAssetUniverse.getAnalysis();
            AssetFeedback templateFeedback = templateAssetUniverse.getFeedback();
            AssetLocations templateLocations = templateAssetUniverse.getKnownLocations();
            AssetLineage templateLineage = templateAssetUniverse.getLineage();
            RelatedAssets templateRelatedAssets = templateAssetUniverse.getRelatedAssets();
            if (templateMeanings != null) {
                this.meanings = templateMeanings.cloneIterator(this);
            }
            if (templateSchema != null) {
                templateSchema.cloneAssetSchemaElement(this);
            }
            if (templateAnalysis != null) {
                this.analysis = templateAnalysis.cloneIterator(this);
            }
            if (templateFeedback != null) {
                this.feedback = new AssetFeedback((AssetDescriptor)this, templateFeedback);
            }
            if (templateLocations != null) {
                this.knownLocations = templateLocations.cloneIterator(this);
            }
            if (templateLineage != null) {
                this.lineage = new AssetLineage((AssetDescriptor)this, templateLineage);
            }
            if (templateRelatedAssets != null) {
                this.relatedAssets = templateRelatedAssets.cloneIterator(this);
            }
        }
    }

    public AssetMeanings getMeanings() {
        if (this.meanings == null) {
            return null;
        }
        return this.meanings.cloneIterator(this);
    }

    public AssetSchemaElement getSchema() {
        if (this.schema == null) {
            return null;
        }
        return this.schema.cloneAssetSchemaElement(this);
    }

    public AssetAnnotations getAnalysis() {
        if (this.analysis == null) {
            return null;
        }
        return this.analysis.cloneIterator(this);
    }

    public AssetFeedback getFeedback() {
        if (this.feedback == null) {
            return null;
        }
        return new AssetFeedback((AssetDescriptor)this, this.feedback);
    }

    public AssetLocations getKnownLocations() {
        if (this.knownLocations == null) {
            return null;
        }
        return this.knownLocations.cloneIterator(this);
    }

    public AssetLineage getLineage() {
        if (this.lineage == null) {
            return null;
        }
        return new AssetLineage((AssetDescriptor)this, this.lineage);
    }

    public RelatedAssets getRelatedAssets() {
        if (this.relatedAssets == null) {
            return null;
        }
        return this.relatedAssets.cloneIterator(this);
    }

    @Override
    public String toString() {
        return "AssetUniverse{assetBean=" + this.assetBean + ", assetMeanings=" + this.meanings + ", schema=" + this.schema + ", analysis=" + this.analysis + ", feedback=" + this.feedback + ", knownLocations=" + this.knownLocations + ", lineage=" + this.lineage + ", relatedAssets=" + this.relatedAssets + ", externalIdentifiers=" + this.externalIdentifiers + ", relatedMediaReferences=" + this.relatedMediaReferences + ", noteLogs=" + this.noteLogs + ", externalReferences=" + this.externalReferences + ", connections=" + this.connections + ", licenses=" + this.licenses + ", certifications=" + this.certifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetUniverse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetUniverse that = (AssetUniverse)objectToCompare;
        return Objects.equals(this.getMeanings(), that.getMeanings()) && Objects.equals(this.getSchema(), that.getSchema()) && Objects.equals(this.getAnalysis(), that.getAnalysis()) && Objects.equals(this.getFeedback(), that.getFeedback()) && Objects.equals(this.getKnownLocations(), that.getKnownLocations()) && Objects.equals(this.getLineage(), that.getLineage()) && Objects.equals(this.getRelatedAssets(), that.getRelatedAssets());
    }
}

