/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.RelatedAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;

public class RelatedAsset
extends AssetReferenceable {
    protected Asset assetBean;
    protected RelatedAssetProperties relatedAssetProperties;

    protected RelatedAsset(Asset assetBean, RelatedAssetProperties relatedAssetProperties) {
        super(assetBean);
        this.assetBean = assetBean == null ? new Asset() : new Asset(assetBean);
        this.relatedAssetProperties = relatedAssetProperties;
    }

    protected RelatedAsset(AssetDescriptor parentAsset, Asset assetBean, RelatedAssetProperties relatedAssetProperties) {
        super(assetBean);
        this.assetBean = assetBean == null ? new Asset() : new Asset(assetBean);
        this.relatedAssetProperties = relatedAssetProperties;
    }

    public RelatedAsset(AssetDescriptor parentAsset, RelatedAsset templateRelatedAsset) {
        super(parentAsset, templateRelatedAsset);
        if (templateRelatedAsset == null) {
            this.assetBean = new Asset();
            this.relatedAssetProperties = null;
        } else {
            this.assetBean = templateRelatedAsset.getAssetBean();
            this.relatedAssetProperties = templateRelatedAsset.relatedAssetProperties;
        }
    }

    protected Asset getAssetBean() {
        return this.assetBean;
    }

    public String getDisplayName() {
        return this.assetBean.getDisplayName();
    }

    public String getShortDescription() {
        return this.assetBean.getShortDescription();
    }

    public String getDescription() {
        return this.assetBean.getDescription();
    }

    public String getOwner() {
        return this.assetBean.getOwner();
    }

    public RelatedAssetProperties getRelatedAssetProperties() throws PropertyServerException {
        if (this.relatedAssetProperties != null) {
            this.relatedAssetProperties.refresh();
        }
        return this.relatedAssetProperties;
    }

    @Override
    public String toString() {
        return this.assetBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof RelatedAsset)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RelatedAsset that = (RelatedAsset)objectToCompare;
        return Objects.equals(this.getAssetBean(), that.getAssetBean());
    }
}

