/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.AnnotationStatus;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Annotation
extends ElementHeader {
    protected String reportName = null;
    protected String reportDescription = null;
    protected Date creationDate = null;
    protected Map<String, Object> analysisParameters = null;
    protected String annotationType = null;
    protected String summary = null;
    protected int confidenceLevel = 0;
    protected String expression = null;
    protected String explanation = null;
    protected String analysisStep = null;
    protected String jsonProperties = null;
    protected AnnotationStatus annotationStatus = null;
    protected Date reviewDate = null;
    protected String steward = null;
    protected String reviewComment = null;
    protected Map<String, Object> additionalProperties = null;

    public Annotation() {
    }

    public Annotation(Annotation templateAnnotation) {
        super(templateAnnotation);
        if (templateAnnotation != null) {
            this.reportName = templateAnnotation.getReportName();
            this.reportDescription = templateAnnotation.getReportDescription();
            this.creationDate = templateAnnotation.getCreationDate();
            this.analysisParameters = templateAnnotation.getAnalysisParameters();
            this.annotationType = templateAnnotation.getAnnotationType();
            this.summary = templateAnnotation.getSummary();
            this.confidenceLevel = templateAnnotation.getConfidenceLevel();
            this.expression = templateAnnotation.getExpression();
            this.explanation = templateAnnotation.getExplanation();
            this.analysisStep = templateAnnotation.getAnalysisStep();
            this.jsonProperties = templateAnnotation.getJsonProperties();
            this.annotationStatus = templateAnnotation.getAnnotationStatus();
            this.reviewDate = templateAnnotation.getReviewDate();
            this.steward = templateAnnotation.getSteward();
            this.reviewComment = templateAnnotation.getReviewComment();
            this.additionalProperties = new HashMap<String, Object>(templateAnnotation.getAdditionalProperties());
        }
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public String getReportDescription() {
        return this.reportDescription;
    }

    public void setReportDescription(String reportDescription) {
        this.reportDescription = reportDescription;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Map<String, Object> getAnalysisParameters() {
        return this.analysisParameters;
    }

    public void setAnalysisParameters(Map<String, Object> analysisParameters) {
        this.analysisParameters = analysisParameters;
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public void setAnnotationType(String annotationType) {
        this.annotationType = annotationType;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public int getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public void setConfidenceLevel(int confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public String getAnalysisStep() {
        return this.analysisStep;
    }

    public void setAnalysisStep(String analysisStep) {
        this.analysisStep = analysisStep;
    }

    public String getJsonProperties() {
        return this.jsonProperties;
    }

    public void setJsonProperties(String jsonProperties) {
        this.jsonProperties = jsonProperties;
    }

    public AnnotationStatus getAnnotationStatus() {
        return this.annotationStatus;
    }

    public void setAnnotationStatus(AnnotationStatus annotationStatus) {
        this.annotationStatus = annotationStatus;
    }

    public Date getReviewDate() {
        return this.reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }

    public String getSteward() {
        return this.steward;
    }

    public void setSteward(String steward) {
        this.steward = steward;
    }

    public String getReviewComment() {
        return this.reviewComment;
    }

    public void setReviewComment(String reviewComment) {
        this.reviewComment = reviewComment;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Override
    public String toString() {
        return "Annotation{reportName='" + this.reportName + '\'' + ", reportDescription='" + this.reportDescription + '\'' + ", creationDate=" + this.creationDate + ", analysisParameters=" + this.analysisParameters + ", annotationType='" + this.annotationType + '\'' + ", summary='" + this.summary + '\'' + ", confidenceLevel=" + this.confidenceLevel + ", expression='" + this.expression + '\'' + ", explanation='" + this.explanation + '\'' + ", analysisStep='" + this.analysisStep + '\'' + ", jsonProperties='" + this.jsonProperties + '\'' + ", annotationStatus=" + this.annotationStatus + ", reviewDate=" + this.reviewDate + ", steward='" + this.steward + '\'' + ", reviewComment='" + this.reviewComment + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof Annotation)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Annotation that = (Annotation)objectToCompare;
        return this.getConfidenceLevel() == that.getConfidenceLevel() && Objects.equals(this.getReportName(), that.getReportName()) && Objects.equals(this.getReportDescription(), that.getReportDescription()) && Objects.equals(this.getCreationDate(), that.getCreationDate()) && Objects.equals(this.getAnalysisParameters(), that.getAnalysisParameters()) && Objects.equals(this.getAnnotationType(), that.getAnnotationType()) && Objects.equals(this.getSummary(), that.getSummary()) && Objects.equals(this.getExpression(), that.getExpression()) && Objects.equals(this.getExplanation(), that.getExplanation()) && Objects.equals(this.getAnalysisStep(), that.getAnalysisStep()) && Objects.equals(this.getJsonProperties(), that.getJsonProperties()) && this.getAnnotationStatus() == that.getAnnotationStatus() && Objects.equals(this.getReviewDate(), that.getReviewDate()) && Objects.equals(this.getSteward(), that.getSteward()) && Objects.equals(this.getReviewComment(), that.getReviewComment()) && Objects.equals(this.getAdditionalProperties(), that.getAdditionalProperties());
    }
}

