/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CommentType implements Serializable
{
    STANDARD_COMMENT(0, "Comment", "General comment about the asset."),
    QUESTION(1, "Question", "Asks a question to the people owning, managing or using the asset."),
    ANSWER(2, "Answer", "Answers a question (posted as a reply to the question)."),
    SUGGESTION(3, "Suggestion", "Provides a suggestion on how to improve the asset or its properties and description."),
    USAGE_EXPERIENCE(4, "Experience", "Describes situations where this asset has been used and related hints and tips.");

    private static final long serialVersionUID = 1L;
    private int commentTypeCode;
    private String commentType;
    private String commentTypeDescription;

    private CommentType(int commentTypeCode, String commentType, String commentTypeDescription) {
        this.commentTypeCode = commentTypeCode;
        this.commentType = commentType;
        this.commentTypeDescription = commentTypeDescription;
    }

    public int getOrdinal() {
        return this.commentTypeCode;
    }

    public String getName() {
        return this.commentType;
    }

    public String getDescription() {
        return this.commentTypeDescription;
    }

    public String toString() {
        return "CommentType{commentTypeCode=" + this.commentTypeCode + ", commentType='" + this.commentType + '\'' + ", commentTypeDescription='" + this.commentTypeDescription + '\'' + '}';
    }
}

