/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ElementOrigin implements Serializable
{
    LOCAL_COHORT(0, "Local to cohort", "The element is being maintained within one of the local cohort members. The metadata collection id is for one of the repositories in the cohort. This metadata collection id identifies the home repository for this element. "),
    EXPORT_ARCHIVE(1, "Export Archive", "The element was created from an export archive. The metadata collection id for the element is the metadata collection id of the originating server. If the originating server later joins the cohort with the same metadata collection Id then these elements will be refreshed from the originating server\u2019s current repository."),
    CONTENT_PACK(2, "Content Pack", "The element comes from an open metadata content pack. The metadata collection id of the elements is set to the GUID of the pack."),
    DEREGISTERED_REPOSITORY(3, "Deregistered Repository", "The element comes from a metadata repository that used to be a member of the one of the local repository's cohorts but it has been deregistered. The metadata collection id remains the same. If the repository rejoins the cohort then these elements can be refreshed from the rejoining repository."),
    CONFIGURATION(4, "Configuration", "The element is part of a service's configuration.  The metadata collection id is null.");

    private static final long serialVersionUID = 1L;
    private int originCode;
    private String originName;
    private String originDescription;

    private ElementOrigin(int originCode, String originName, String originDescription) {
        this.originCode = originCode;
        this.originName = originName;
        this.originDescription = originDescription;
    }

    public int getOrdinal() {
        return this.originCode;
    }

    public String getName() {
        return this.originName;
    }

    public String getDescription() {
        return this.originDescription;
    }

    public String toString() {
        return "ElementOrigin{originCode=" + this.originCode + ", originName='" + this.originName + '\'' + ", originDescription='" + this.originDescription + '\'' + '}';
    }
}

