/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.DerivedSchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DerivedSchemaElement.class, name="DerivedSchemaElement")})
public class PrimitiveSchemaElement
extends SchemaElement {
    protected String dataType = null;
    protected String defaultValue = null;

    public PrimitiveSchemaElement() {
    }

    public PrimitiveSchemaElement(PrimitiveSchemaElement templateSchemaElement) {
        super(templateSchemaElement);
        if (templateSchemaElement != null) {
            this.dataType = templateSchemaElement.getDataType();
            this.defaultValue = templateSchemaElement.getDefaultValue();
        }
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public SchemaElement cloneSchemaElement() {
        return new PrimitiveSchemaElement(this);
    }

    @Override
    public String toString() {
        return "PrimitiveSchemaElement{dataType='" + this.dataType + '\'' + ", defaultValue='" + this.defaultValue + '\'' + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof PrimitiveSchemaElement)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        PrimitiveSchemaElement that = (PrimitiveSchemaElement)objectToCompare;
        return Objects.equals(this.getDataType(), that.getDataType()) && Objects.equals(this.getDefaultValue(), that.getDefaultValue());
    }
}

