/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaAttribute
extends Referenceable {
    protected String attributeName = null;
    protected int elementPosition = 0;
    protected String cardinality = null;
    protected String defaultValueOverride = null;
    protected SchemaElement attributeType = null;

    public SchemaAttribute() {
    }

    public SchemaAttribute(SchemaAttribute template) {
        super(template);
        if (template != null) {
            this.attributeName = template.getAttributeName();
            this.elementPosition = template.getElementPosition();
            this.cardinality = template.getCardinality();
            this.defaultValueOverride = template.getDefaultValueOverride();
            SchemaElement templateAttributeType = template.getAttributeType();
            if (templateAttributeType != null) {
                this.attributeType = templateAttributeType.cloneSchemaElement();
            }
        }
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public int getElementPosition() {
        return this.elementPosition;
    }

    public void setElementPosition(int elementPosition) {
        this.elementPosition = elementPosition;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    public String getDefaultValueOverride() {
        return this.defaultValueOverride;
    }

    public void setDefaultValueOverride(String defaultValueOverride) {
        this.defaultValueOverride = defaultValueOverride;
    }

    public SchemaElement getAttributeType() {
        if (this.attributeType == null) {
            return null;
        }
        return this.attributeType.cloneSchemaElement();
    }

    public void setAttributeType(SchemaElement attributeType) {
        this.attributeType = attributeType;
    }

    @Override
    public String toString() {
        return "SchemaAttribute{attributeName='" + this.attributeName + '\'' + ", elementPosition=" + this.elementPosition + ", cardinality='" + this.cardinality + '\'' + ", defaultValueOverride='" + this.defaultValueOverride + '\'' + ", attributeType=" + this.attributeType + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof SchemaAttribute)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaAttribute that = (SchemaAttribute)objectToCompare;
        return this.getElementPosition() == that.getElementPosition() && Objects.equals(this.getAttributeName(), that.getAttributeName()) && Objects.equals(this.getCardinality(), that.getCardinality()) && Objects.equals(this.getDefaultValueOverride(), that.getDefaultValueOverride()) && Objects.equals(this.getAttributeType(), that.getAttributeType());
    }
}

