/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.MapSchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PrimitiveSchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Schema;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Schema.class, name="Schema"), @JsonSubTypes.Type(value=MapSchemaElement.class, name="MapSchemaElement"), @JsonSubTypes.Type(value=PrimitiveSchemaElement.class, name="PrimitiveSchemaElement")})
public abstract class SchemaElement
extends Referenceable {
    protected String versionNumber = null;
    protected String author = null;
    protected String usage = null;
    protected String encodingStandard = null;
    protected Map<String, Object> schemaProperties = null;

    public SchemaElement() {
    }

    public SchemaElement(SchemaElement templateSchema) {
        super(templateSchema);
        if (templateSchema != null) {
            this.versionNumber = templateSchema.getVersionNumber();
            this.author = templateSchema.getAuthor();
            this.usage = templateSchema.getUsage();
            this.encodingStandard = templateSchema.getEncodingStandard();
            this.schemaProperties = templateSchema.getSchemaProperties();
        }
    }

    public abstract SchemaElement cloneSchemaElement();

    public String getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(String versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getEncodingStandard() {
        return this.encodingStandard;
    }

    public void setEncodingStandard(String encodingStandard) {
        this.encodingStandard = encodingStandard;
    }

    public void setSchemaProperties(Map<String, Object> schemaProperties) {
        this.schemaProperties = schemaProperties;
    }

    public Map<String, Object> getSchemaProperties() {
        if (this.schemaProperties == null) {
            return null;
        }
        if (this.schemaProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Object>(this.schemaProperties);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof SchemaElement)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaElement that = (SchemaElement)objectToCompare;
        return Objects.equals(this.getVersionNumber(), that.getVersionNumber()) && Objects.equals(this.getAuthor(), that.getAuthor()) && Objects.equals(this.getUsage(), that.getUsage()) && Objects.equals(this.getEncodingStandard(), that.getEncodingStandard());
    }

    @Override
    public String toString() {
        return "SchemaElement{versionNumber='" + this.versionNumber + '\'' + ", author='" + this.author + '\'' + ", usage='" + this.usage + '\'' + ", schemaProperties=" + this.schemaProperties + ", encodingStandard='" + this.encodingStandard + '\'' + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }
}

