/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum SchemaType implements Serializable
{
    UNKNOWN(0, "<Unknown>", "The schema type is unknown."),
    STRUCT(1, "Struct", "The schema type is a structure containing a list of properties of potentially different types."),
    ARRAY(2, "Array", "The schema type is a structure containing an ordered list of properties all of the same type."),
    SET(3, "Set", "The schema type is a structure containing an unordered collection of properties, all of the same type.");

    private int schemaTypeCode;
    private String schemaTypeName;
    private String schemaTypeDescription;
    private static final long serialVersionUID = 1L;

    private SchemaType(int schemaTypeCode, String schemaTypeName, String schemaTypeDescription) {
        this.schemaTypeCode = schemaTypeCode;
        this.schemaTypeName = schemaTypeName;
        this.schemaTypeDescription = schemaTypeDescription;
    }

    public int getOrdinal() {
        return this.schemaTypeCode;
    }

    public String getName() {
        return this.schemaTypeName;
    }

    public String getDescription() {
        return this.schemaTypeDescription;
    }

    public String toString() {
        return "SchemaType{schemaTypeCode=" + this.schemaTypeCode + ", schemaTypeName='" + this.schemaTypeName + '\'' + ", schemaTypeDescription='" + this.schemaTypeDescription + '\'' + '}';
    }
}

