/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AdditionalProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Annotation;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.AnnotationStatus;

public class AssetAnnotation
extends AssetElementHeader {
    protected Annotation annotationBean;

    public AssetAnnotation(Annotation annotationBean) {
        super(annotationBean);
        this.annotationBean = annotationBean == null ? new Annotation() : annotationBean;
    }

    public AssetAnnotation(AssetDescriptor parentAsset, Annotation annotationBean) {
        super(parentAsset, annotationBean);
        this.annotationBean = annotationBean == null ? new Annotation() : annotationBean;
    }

    public AssetAnnotation(AssetDescriptor parentAsset, AssetAnnotation templateAnnotation) {
        super(parentAsset, templateAnnotation);
        this.annotationBean = templateAnnotation == null ? new Annotation() : templateAnnotation.getAnnotationBean();
    }

    protected Annotation getAnnotationBean() {
        return this.annotationBean;
    }

    public String getReportName() {
        return this.annotationBean.getReportName();
    }

    public String getReportDescription() {
        return this.annotationBean.getReportDescription();
    }

    public Date getCreationDate() {
        return this.annotationBean.getCreationDate();
    }

    public AdditionalProperties getAnalysisParameters() {
        Map<String, Object> analysisParameters = this.annotationBean.getAnalysisParameters();
        if (analysisParameters == null) {
            return null;
        }
        if (analysisParameters.isEmpty()) {
            return null;
        }
        return new AdditionalProperties(super.getParentAsset(), analysisParameters);
    }

    public String getAnnotationType() {
        return this.annotationBean.getAnnotationType();
    }

    public String getSummary() {
        return this.annotationBean.getSummary();
    }

    public int getConfidenceLevel() {
        return this.annotationBean.getConfidenceLevel();
    }

    public String getExpression() {
        return this.annotationBean.getExpression();
    }

    public String getExplanation() {
        return this.annotationBean.getExplanation();
    }

    public String getAnalysisStep() {
        return this.annotationBean.getAnalysisStep();
    }

    public String getJsonProperties() {
        return this.annotationBean.getJsonProperties();
    }

    public AnnotationStatus getAnnotationStatus() {
        return this.annotationBean.getAnnotationStatus();
    }

    public Date getReviewDate() {
        return this.annotationBean.getReviewDate();
    }

    public String getSteward() {
        return this.annotationBean.getSteward();
    }

    public String getReviewComment() {
        return this.annotationBean.getReviewComment();
    }

    public AdditionalProperties getAdditionalProperties() {
        Map<String, Object> additionalProperties = this.annotationBean.getAdditionalProperties();
        if (additionalProperties == null) {
            return null;
        }
        if (additionalProperties.isEmpty()) {
            return null;
        }
        return new AdditionalProperties(super.getParentAsset(), additionalProperties);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetAnnotation)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetAnnotation that = (AssetAnnotation)objectToCompare;
        return Objects.equals(this.getAnnotationBean(), that.getAnnotationBean());
    }
}

