/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetMeanings;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaAttributes;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaLinks;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Schema;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaElement;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaType;

public class AssetComplexSchemaType
extends AssetSchemaType {
    protected Schema schemaBean;
    protected AssetSchemaAttributes schemaAttributes;
    protected AssetSchemaLinks schemaLinks;

    public AssetComplexSchemaType(Schema schemaBean, AssetMeanings assetMeanings, AssetSchemaAttributes schemaAttributes, AssetSchemaLinks schemaLinks) {
        super(schemaBean, assetMeanings);
        this.schemaBean = schemaBean == null ? new Schema() : schemaBean;
        this.schemaAttributes = schemaAttributes == null ? null : schemaAttributes.cloneIterator(super.getParentAsset());
        this.schemaLinks = schemaLinks == null ? null : schemaLinks.cloneIterator(super.getParentAsset());
    }

    public AssetComplexSchemaType(AssetDescriptor parentAsset, Schema schemaBean, AssetMeanings assetMeanings, AssetSchemaAttributes schemaAttributes, AssetSchemaLinks schemaLinks) {
        super(parentAsset, schemaBean, assetMeanings);
        this.schemaBean = schemaBean == null ? new Schema() : schemaBean;
        this.schemaAttributes = schemaAttributes == null ? null : schemaAttributes.cloneIterator(super.getParentAsset());
        this.schemaLinks = schemaLinks == null ? null : schemaLinks.cloneIterator(super.getParentAsset());
    }

    public AssetComplexSchemaType(AssetDescriptor parentAsset, AssetComplexSchemaType templateSchema) {
        super(parentAsset, templateSchema);
        if (templateSchema == null) {
            this.schemaBean = new Schema();
            this.schemaAttributes = null;
            this.schemaLinks = null;
        } else {
            this.schemaBean = templateSchema.getSchemaBean();
            AssetSchemaAttributes schemaAttributes = templateSchema.getSchemaAttributes();
            this.schemaAttributes = schemaAttributes == null ? null : schemaAttributes.cloneIterator(super.getParentAsset());
            AssetSchemaLinks schemaLinks = templateSchema.getSchemaLinks();
            this.schemaLinks = schemaLinks == null ? null : schemaLinks.cloneIterator(super.getParentAsset());
        }
    }

    protected Schema getSchemaBean() {
        return this.schemaBean;
    }

    public SchemaType getSchemaType() {
        return this.schemaBean.getSchemaType();
    }

    public AssetSchemaAttributes getSchemaAttributes() {
        if (this.schemaAttributes == null) {
            return null;
        }
        return this.schemaAttributes.cloneIterator(super.getParentAsset());
    }

    public int getMaximumElements() {
        if (this.schemaBean.getSchemaType() == SchemaType.STRUCT) {
            return 0;
        }
        return this.schemaBean.getMaximumElements();
    }

    public AssetSchemaLinks getSchemaLinks() {
        if (this.schemaLinks == null) {
            return null;
        }
        return this.schemaLinks.cloneIterator(super.getParentAsset());
    }

    @Override
    protected AssetSchemaType cloneAssetSchemaElement(AssetDescriptor parentAsset) {
        return new AssetComplexSchemaType(parentAsset, this);
    }

    @Override
    protected SchemaElement getSchemaElementBean() {
        return this.schemaBean;
    }

    @Override
    public String toString() {
        return this.schemaBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetComplexSchemaType)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetComplexSchemaType that = (AssetComplexSchemaType)objectToCompare;
        return Objects.equals(this.getSchemaBean(), that.getSchemaBean()) && Objects.equals(this.getSchemaAttributes(), that.getSchemaAttributes()) && Objects.equals(this.getSchemaLinks(), that.getSchemaLinks());
    }
}

